package cbrrecommender.main;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.List;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ScrollPaneConstants;

import de.dfki.mycbr.core.similarity.AmalgamationFct;

/**
 *  @author the cbr team 
 */

public class GUI {

	public JPanel       Inframe, Outframe, Buttonframe, Labelframe, Fieldframe;
	public JTextField   InputPrice, InputColor, InputMileage, InputNumberofcases, InputAmalgam;
	public JEditorPane  Output,Info;
	public JLabel       InputlabelPrice, InputlabelColor, InputlabelMileage, InputlabelNumberofcases, InputlabelAmalgam, OutputlabelAmalgam;
	public JButton      SubmitQuery;
	public JScrollPane  Scroll;
	public Recommender  remy;

	public GUI() {                                               

		InputPrice = new JTextField(10);	
		InputlabelPrice = new JLabel("Price : Please Enter like: 1000.50");

		InputColor = new JTextField(10);	
		InputlabelColor = new JLabel("Color : Please enter like: White");

		InputMileage = new JTextField(10);	
		InputlabelMileage = new JLabel("Mileage: Please enter like: 7050.00");

		InputNumberofcases = new JTextField(10);	
		InputlabelNumberofcases = new JLabel("Number of cases to tretrieve:");

		InputAmalgam = new JTextField(10);	
		InputlabelAmalgam = new JLabel("Amalgamationfunction to use:");

		Output = new JEditorPane("text/html","<b>Welcome to a small CBR recommender demo</b>");
		Output.setEditable(false);                

		Scroll = new JScrollPane(Output);          						                
		Scroll.setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);
		Scroll.setHorizontalScrollBarPolicy(ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER);
		Scroll.setBorder(BorderFactory.createTitledBorder("User dialog:"));
		Scroll.getViewport().setPreferredSize(new Dimension(450,200));

		SubmitQuery = new JButton("Submit Query");
		SubmitQuery.setToolTipText("Press me to process the Query.");
		
		Inframe = new JPanel();                                 
		Inframe.setLayout(new GridLayout(5,2));
				
		Inframe.add(InputlabelPrice);                          
		Inframe.add(InputPrice);
		Inframe.add(InputlabelColor); 
		Inframe.add(InputColor);
		Inframe.add(InputlabelMileage);
		Inframe.add(InputMileage);			
		Inframe.add(InputlabelNumberofcases);
		Inframe.add(InputNumberofcases);
		Inframe.add(InputlabelAmalgam);
		Inframe.add(InputAmalgam);
		
		Outframe = new JPanel();                           
		Outframe.setSize(new Dimension(300,250));
		Outframe.add(Scroll);

		JFrame Main = new JFrame("myCBR little recommender demo");   
		
		Main.getContentPane().setLayout(new BorderLayout());
		Main.getContentPane().add(Inframe, BorderLayout.NORTH);
		Main.add(SubmitQuery, BorderLayout.SOUTH);
		Main.getContentPane().add(Outframe, BorderLayout.CENTER);			

		remy = new Recommender();
		remy.loadengine();
		Output.setText(remy.displayAmalgamationFunctions());
		InputAmalgam.setText(remy.myConcept.getActiveAmalgamFct().getName());

		Main.addWindowListener(new WindowAdapter() {       

			public void windowClosing(WindowEvent e) {     

				System.exit(0);                             
			}
		});

		SubmitQuery.addActionListener(new ActionListener() { 
			public void actionPerformed(ActionEvent e) {

				CheckforAmalgamSelection();			
				String recomendation = remy.solveOuery(InputColor.getText(),
						Float.valueOf(InputPrice.getText()),
						Float.valueOf(InputMileage.getText()), 
						Integer.valueOf(InputNumberofcases.getText())
						);
				Output.setText(recomendation);
			}
		});

		InputPrice.addActionListener(new ActionListener() {      
			public void actionPerformed(ActionEvent e) {    

				InputPrice.setText("");
			}
		});
		Main.pack();
		Main.setSize(500,400);
		Main.setVisible(true);                               
	}                                                      

	public void CheckforAmalgamSelection(){

		List<AmalgamationFct> liste = remy.myConcept.getAvailableAmalgamFcts();

		for (int i = 0; i < liste.size(); i++){

			if  ((liste.get(i).getName()).equals(InputAmalgam.getText())) {

				remy.myConcept.setActiveAmalgamFct(liste.get(i));
			}		 
		}			
	}

	public static void main(String[] args) {                
		
		GUI mygui = new GUI();		                              
	}
}




