<%@ page language="java" contentType="text/html; charset=ISO-8859-1"
    pageEncoding="ISO-8859-1"%>
    
<%@page import="material.CBREngine"%>

<%@page import="java.text.SimpleDateFormat"%>
<%@page import="de.dfki.mycbr.core.retrieval.Retrieval.RetrievalMethod"%>
<%@page import="de.dfki.mycbr.core.similarity.*"%>
<%@page import="de.dfki.mycbr.util.*"%>
<%@page import="de.dfki.mycbr.core.casebase.*"%>
<%@page import="de.dfki.mycbr.core.retrieval.*"%>
<%@ page import="java.util.*" %>
<%@ page import="de.dfki.mycbr.*" %>
<%@page import="de.dfki.mycbr.core.model.*"%>
<%@page import="de.dfki.mycbr.core.*"%>
<%@page import="de.dfki.mycbr.core.model.StringDesc"%>
    
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=ISO-8859-1">
<title>Recommender Demo</title>
</head>
<body>

<%!

CBREngine engine; 
Project rec;
DefaultCaseBase cb;
Concept myConcept;

public void loadengine(){
	
	engine = new CBREngine();
	
	rec = engine.createProjectFromPRJ();
	
	// create case bases and assign the case bases that will be used for submitting a query 
	cb = (DefaultCaseBase)rec.getCaseBases().get(engine.getCaseBase());
			// create a concept and get the main concept of the project; 
			// the name has to be specified at the beginning of this class
	myConcept = rec.getConceptByID(engine.getConceptName());
	
	System.out.println("Engine loaded");
	
}


/**
 * This method delivers a String containing the 'n' best matching cases to a query sorted descending 
 * by their similarity to the query case and displayed within a HTML table
 * @author bach,weber,koehler,namuth,sauer
 * @param color = Specifies the color of the query instance
 * @param price = Specifies the price of the query insatnce
 * @param mileage = Specifies the mileage of the query instance
 * @param numberofcases = The number of cases to be listed ('n' best cases)
 * @return String = A String describing the 'n' best matching cases and their similarity in an HTML table 
 */
public String solveOuery(String color, Float price, Float mileage, Integer numberofcases){
	
	String answer="";		
	
	// create a new retrieval
	Retrieval ret = new Retrieval(myConcept, cb);
	// specify the retrieval method
	ret.setRetrievalMethod(RetrievalMethod.RETRIEVE_SORTED);
	// create a query instance
	Instance query = ret.getQueryInstance();	
	// Insert values into the query: Symbolic Description
	SymbolDesc colorDesc = (SymbolDesc) myConcept.getAllAttributeDescs().get("Color");
	query.addAttribute(colorDesc,colorDesc.getAttribute(color));

	// Insert values into the query: Float Description
	FloatDesc priceDesc = (FloatDesc) myConcept.getAllAttributeDescs().get("Price");
	try {
		query.addAttribute(priceDesc,priceDesc.getAttribute(price));
	} catch (Exception e) {
		// TODO Auto-generated catch block
		e.printStackTrace();
	}

	// Insert values into the query: Float Description
	FloatDesc mileageDesc = (FloatDesc) myConcept.getAllAttributeDescs().get("Mileage");
	try {
		query.addAttribute(mileageDesc,mileageDesc.getAttribute(mileage));
	} catch (Exception e) {
		// TODO Auto-generated catch block
		e.printStackTrace();
	}
					
	// perform retrieval
	ret.start();	
	// get the retrieval result
	List <Pair<Instance, Similarity>> result = ret.getResult(); 

	// get the case name	
	if(result.size()>0){
			
		// get the best case's name
		String casename = result.get(0).getFirst().getName();	
		// get the similarity value
		Double sim = result.get(0).getSecond().getValue();		
		answer = "I found "+casename+" with a similarity of "+sim+" as the best match.";
		answer = answer+"The "+numberofcases+" best cases shown in a table: <br /> <br /> <table border=\"1\">";	
		ArrayList<Hashtable<String, String>> liste = new ArrayList<Hashtable<String, String>>();	
		// if more case results are requested than we have in our case base at all:
		if(numberofcases>=cb.getCases().size()){numberofcases = cb.getCases().size();}
		
		for(int i = 0; i<numberofcases; i++){
			
			liste.add(getAttributes(result.get(i), rec.getConceptByID(engine.getConceptName())));
			System.out.println("liste "+liste.get(i).toString());
			answer=answer+"<tr><td>"+result.get(i).getFirst().getName()+"</td><td>"+liste.get(i).toString()+"</td></tr>";
		}
		
		answer= answer+"</table>";		
	}
	
	else{System.out.println("Retrieval Result is empty");}
	
	return answer;
}
/**
 * This method delivers a Hashtable which contains the Attributs names (Attributes of the case) combined with their respective values.
 * @author weber,koehler,namuth
 * @param r = An Instance.
 * @param concept = A Concept
 * @return List = List containing the Attributes of a case with their values.
 */
 public static Hashtable<String, String> getAttributes(Pair<Instance, Similarity> r, Concept concept) {
    
	Hashtable<String, String> table = new Hashtable<String, String>();
    ArrayList<String> cats = getCategories(r);
    // Add the similarity of the case
    table.put("Sim", String.valueOf(r.getSecond().getValue()));
    for (String cat : cats) {
        // Add the Attribute name and its value into the Hashtable
        table.put(cat, r.getFirst().getAttForDesc(concept.getAllAttributeDescs().get(cat)).getValueAsString());
    }
    return table;
 }
 /**
  * This Method generates an ArrayList, which contains all Categories of aa Concept.
  * @author weber,koehler,namuth
  * @param r  =  An Instance.
  * @return List = List containing the Attributes names.
  */
  public static ArrayList<String> getCategories(Pair<Instance, Similarity> r) {
    
	 ArrayList<String> cats = new ArrayList<String>();

     // Read all Attributes of a Concept
     Set<AttributeDesc> catlist = r.getFirst().getAttributes().keySet();

     for (AttributeDesc cat : catlist) {
         if (cat != null) {
             // Add the String literals for each Attribute into the ArrayList
             cats.add(cat.getName());
         }
     }
     return cats;
 }

%>
Your input values from the query where:  <br /> <br />
Testing: <% out.println(request.getParameter("color")); %> <br />
Testing: <% out.println(request.getParameter("price")); %> <br />
Testing: <% out.println(request.getParameter("mileage")); %> <br /><br />
The results found for your query are: <br /> <br />

 <% 
if(engine == null) {loadengine();}
else{ /*do nothing, engine is already loaded */ }
%>
 
<b><i> <% String answ = solveOuery(request.getParameter("color"),Float.valueOf(request.getParameter("price")),
		               Float.valueOf(request.getParameter("mileage")),Integer.valueOf(request.getParameter("number")));
			out.print(answ);
		%> 
</i></b>
<br /><br />
<form method="POST" action='PostQuery.jsp' name="backtoquery">
<input type="submit" value="Back to Query">
</form>
</body>
</html>