package material;

import de.dfki.mycbr.core.Project;
import de.dfki.mycbr.core.model.Concept;
import de.dfki.mycbr.io.CSVImporter;
import de.dfki.mycbr.io.DataBaseImporter;


/**
 * @author bach, hundt, sauer
 */

public class CBREngine {

	// set path to myCBR projects	
	private static String data_path = "D:\\cbrmaterial\\projects\\NewExampleProject\\";
	// name of the project file
	private static String projectName = "NewExampleProject.prj";
	// name of the central concept 
	private static String conceptName = "Car";
	// name of the csv containing the instances
	private static String csv = "default.csv";
	/// set the separators that are used in the csv file
	private static String columnseparator = ";";
	private static String multiplevalueseparator = ",";
	// specify the path to the database mapping
	private static String dbmapping = "databasemapping.xml";
	// name of the case base that should be used; the default name in myCBR is CB_csvImport
	private static String casebase = "CarsCB";

	
	// Getter for the Project meta data
	public static String getCaseBase() {
		return casebase;
	}

	public static void setCasebase(String casebase) {
		CBREngine.casebase = casebase;
	}

	public static String getProjectName() {
		return projectName;
	}	

	public static void setProjectName(String projectName) {
		CBREngine.projectName = projectName;
	}

	public static String getConceptName() {
		return conceptName;
	}

	public static void setConceptName(String conceptName) {
		CBREngine.conceptName = conceptName;
	}

	public static String getCsv() {
		return csv;
	}

	public static void setCsv(String csv) {
		CBREngine.csv = csv;
	}

	/**
	 * This methods loads a myCBR project from a .prj file and loads the cases in this project.
	 * The specification of the project's location and according file names has to be
	 * done at the beginning of this class.
	 * @return Project instance containing model, sims and cases (if available)
	 */
	public Project createProjectFromPRJ(){

		Project project = null;

		try {
			// load new project
			project = new Project(data_path+projectName);
			// create a concept and get the main concept of the project; 
			// the name has to be specified at the beginning of this class
			while (project.isImporting()){
				Thread.sleep(1000);
				System.out.print(".");
			}
			System.out.print("\n");
		}

		catch(Exception ex) {

			System.out.println("Error loading .prj file");

		}

		return project;
	}
	
	/**
	 * This methods creates a myCBR project and loads the cases in this project.
	 * The specification of the project's location and according file names has to be
	 * done at the beginning of this class.
	 * @return Project instance containing model, sims and cases (if available)
	 */
	public Project createCBRProject(){
	Project project = null;

		
	try {
		// load new project
		project = new Project(data_path+projectName);
		// create a concept and get the main concept of the project; 
		// the name has to be specified at the beginning of this class
		while (project.isImporting()){
			Thread.sleep(1000);
			System.out.print(".");
		}
		System.out.print("\n");	//console pretty print
			
		Concept concept = project.getConceptByID(conceptName);
		
		// Initialize CSV Import  
		CSVImporter csvImporter = new CSVImporter(data_path+csv, concept);
		
		// set the separators that are used in the csv file
		csvImporter.setSeparator(columnseparator); // column separator
		csvImporter.setSeparatorMultiple(multiplevalueseparator); //multiple value separator
		
		// prepare for import
		csvImporter.readData();	
		csvImporter.checkData();
		csvImporter.addMissingValues();
		csvImporter.addMissingDescriptions();
		// do the import of the instances 
		csvImporter.doImport();
		// wait until the import is done
		System.out.print("Importing ");
		while (csvImporter.isImporting()){
			Thread.sleep(1000);
			System.out.print(".");
		}
		System.out.print("\n");	//console pretty print
		

	} catch (Exception e) {
		// TODO Auto-generated catch block
		e.printStackTrace();
	}
	return project;
	}

	/**
	 * This methods creates an EMPTY myCBR project.
	 * The specification of the project's location and according file names has to be
	 * done at the beginning of this class.
	 * @return Project instance containing model, sims and cases (if available)
	 */
	public Project createemptyCBRProject(){
	Project project = null;

		
	try {
		// load new project
		project = new Project(data_path+projectName);
		// create a concept and get the main concept of the project; 
		// the name has to be specified at the beginning of this class
		while (project.isImporting()){
			Thread.sleep(1000);
			System.out.print(".");
		}
		System.out.print("\n");	//console pretty print
			
	//	

	} catch (Exception e) {
		// TODO Auto-generated catch block
		e.printStackTrace();
	}
	return project;
	}
	

	/**
	 * This methods creates an EMPTY myCBR project and imports the cases from a db.
	 * The specification of the project's location and according file names has to be
	 * done at the beginning of this class.
	 * @return Project instance containing model, sims and cases (if available)
	 */
	public Project createCBRProjectDBImport(String conceptName, String table, int tableID, String [] filtercolums, String [] filtervalues){
	Project project = null;

		
	try {
		// load new project
		project = new Project(data_path+projectName);
		// create a concept and get the main concept of the project; 
		// the name has to be specified at the beginning of this class
		while (project.isImporting()){
			Thread.sleep(1000);
			System.out.print(".");
		}
		System.out.print("\n");	//console pretty print
		
		// load the cases from PostgreSQL DB
		
		// just in case the table exists, it is deleted
		project.deleteCaseBase("CB_" + table);
		
		Concept concept = project.getConceptByID(conceptName);
		
		//Setting parameters for database connection and myCBR model
		DataBaseImporter dbimport = new DataBaseImporter(tableID, project, concept, data_path+dbmapping);
		
		System.out.println("DbImporter initialized");
		dbimport.setSeperatorMultiple(",");
		System.out.println("Reading");
		dbimport.readData(table, filtercolums, filtervalues);
		dbimport.checkData();
		System.out.println("Do the Import");
		dbimport.doImport();
		
		while (dbimport.isImporting()) {
			Thread.sleep(1000);
			System.out.println("..");
		}
			

	} catch (Exception e) {
		// TODO Auto-generated catch block
		e.printStackTrace();
	}
	return project;
	}
}
