/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.io.InputStream;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkImage;
import org.eclipse.swt.internal.gtk.OS;

public final class Image
extends Resource
implements Drawable {
    public int type;
    public int pixmap;
    public int mask;
    public int surface;
    int transparentPixel = -1;
    GC memGC;
    byte[] alphaData;
    int alpha = -1;
    int width = -1;
    int height = -1;
    static final int DEFAULT_SCANLINE_PAD = 4;

    Image(Device device) {
        super(device);
    }

    public Image(Device device, int width, int height) {
        super(device);
        this.init(width, height);
        this.init();
    }

    public Image(Device device, Image srcImage, int flag) {
        super(device);
        int gdkGC;
        if (srcImage == null) {
            SWT.error(4);
        }
        if (srcImage.isDisposed()) {
            SWT.error(5);
        }
        switch (flag) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        device = this.device;
        this.type = srcImage.type;
        if (OS.USE_CAIRO) {
            int cairo;
            if (flag != 1) {
                this.transparentPixel = srcImage.transparentPixel;
            }
            this.alpha = srcImage.alpha;
            if (srcImage.alphaData != null) {
                this.alphaData = new byte[srcImage.alphaData.length];
                System.arraycopy(srcImage.alphaData, 0, this.alphaData, 0, this.alphaData.length);
            }
            int imageSurface = srcImage.surface;
            int width = this.width = srcImage.width;
            int height = this.height = srcImage.height;
            int format = Cairo.cairo_surface_get_content(imageSurface) == 4096 ? 1 : 0;
            boolean hasAlpha = format == 0;
            this.surface = Cairo.cairo_image_surface_create(format, width, height);
            if (this.surface == 0) {
                SWT.error(2);
            }
            if ((cairo = Cairo.cairo_create(this.surface)) == 0) {
                SWT.error(2);
            }
            Cairo.cairo_set_operator(cairo, 1);
            Cairo.cairo_set_source_surface(cairo, imageSurface, 0.0, 0.0);
            Cairo.cairo_paint(cairo);
            Cairo.cairo_destroy(cairo);
            if (flag != 0) {
                int ob;
                int og;
                int or;
                int oa;
                int stride = Cairo.cairo_image_surface_get_stride(this.surface);
                int data = Cairo.cairo_image_surface_get_data(this.surface);
                if (OS.BIG_ENDIAN) {
                    oa = 0;
                    or = 1;
                    og = 2;
                    ob = 3;
                } else {
                    oa = 3;
                    or = 2;
                    og = 1;
                    ob = 0;
                }
                switch (flag) {
                    case 1: {
                        Color zeroColor = device.getSystemColor(18);
                        RGB zeroRGB = zeroColor.getRGB();
                        int zeroRed = zeroRGB.red;
                        int zeroGreen = zeroRGB.green;
                        int zeroBlue = zeroRGB.blue;
                        Color oneColor = device.getSystemColor(22);
                        RGB oneRGB = oneColor.getRGB();
                        int oneRed = oneRGB.red;
                        int oneGreen = oneRGB.green;
                        int oneBlue = oneRGB.blue;
                        byte[] line = new byte[stride];
                        int y = 0;
                        while (y < height) {
                            C.memmove(line, data + y * stride, stride);
                            int x = 0;
                            int offset = 0;
                            while (x < width) {
                                int intensity;
                                int a = line[offset + oa] & 0xFF;
                                int r = line[offset + or] & 0xFF;
                                int g = line[offset + og] & 0xFF;
                                int b = line[offset + ob] & 0xFF;
                                if (hasAlpha && a != 0) {
                                    r = (r * 255 + a / 2) / a;
                                    g = (g * 255 + a / 2) / a;
                                    b = (b * 255 + a / 2) / a;
                                }
                                if ((intensity = r * r + g * g + b * b) < 98304) {
                                    r = zeroRed;
                                    g = zeroGreen;
                                    b = zeroBlue;
                                } else {
                                    r = oneRed;
                                    g = oneGreen;
                                    b = oneBlue;
                                }
                                if (hasAlpha) {
                                    r = r * a + 128;
                                    r = r + (r >> 8) >> 8;
                                    g = g * a + 128;
                                    g = g + (g >> 8) >> 8;
                                    b = b * a + 128;
                                    b = b + (b >> 8) >> 8;
                                }
                                line[offset + or] = (byte)r;
                                line[offset + og] = (byte)g;
                                line[offset + ob] = (byte)b;
                                ++x;
                                offset += 4;
                            }
                            C.memmove(data + y * stride, line, stride);
                            ++y;
                        }
                        break;
                    }
                    case 2: {
                        byte[] line = new byte[stride];
                        int y = 0;
                        while (y < height) {
                            C.memmove(line, data + y * stride, stride);
                            int x = 0;
                            int offset = 0;
                            while (x < width) {
                                int a = line[offset + oa] & 0xFF;
                                int r = line[offset + or] & 0xFF;
                                int g = line[offset + og] & 0xFF;
                                int b = line[offset + ob] & 0xFF;
                                if (hasAlpha && a != 0) {
                                    r = (r * 255 + a / 2) / a;
                                    g = (g * 255 + a / 2) / a;
                                    b = (b * 255 + a / 2) / a;
                                }
                                int intensity = r + r + g + g + g + g + g + b >> 3;
                                if (hasAlpha) {
                                    intensity = intensity * a + 128;
                                    intensity = intensity + (intensity >> 8) >> 8;
                                }
                                byte by = (byte)intensity;
                                line[offset + ob] = by;
                                line[offset + og] = by;
                                line[offset + or] = by;
                                ++x;
                                offset += 4;
                            }
                            C.memmove(data + y * stride, line, stride);
                            ++y;
                        }
                        break;
                    }
                }
            }
            this.init();
            return;
        }
        int[] w = new int[1];
        int[] h = new int[1];
        if (OS.GTK_VERSION >= OS.VERSION(2, 24, 0)) {
            OS.gdk_pixmap_get_size(srcImage.pixmap, w, h);
        } else {
            OS.gdk_drawable_get_size(srcImage.pixmap, w, h);
        }
        int width = w[0];
        int height = h[0];
        if (srcImage.type == 1 && srcImage.mask != 0 || srcImage.transparentPixel != -1) {
            int mask;
            if (srcImage.transparentPixel != -1) {
                srcImage.createMask();
            }
            if ((mask = OS.gdk_pixmap_new(0, width, height, 1)) == 0) {
                SWT.error(2);
            }
            if ((gdkGC = OS.gdk_gc_new(mask)) == 0) {
                SWT.error(2);
            }
            OS.gdk_draw_drawable(mask, gdkGC, srcImage.mask, 0, 0, 0, 0, width, height);
            OS.g_object_unref(gdkGC);
            this.mask = mask;
            if (srcImage.transparentPixel != -1 && srcImage.memGC != null) {
                srcImage.destroyMask();
            }
        }
        if (flag != 1) {
            this.transparentPixel = srcImage.transparentPixel;
        }
        this.alpha = srcImage.alpha;
        if (srcImage.alphaData != null) {
            this.alphaData = new byte[srcImage.alphaData.length];
            System.arraycopy(srcImage.alphaData, 0, this.alphaData, 0, this.alphaData.length);
        }
        this.createAlphaMask(width, height);
        int pixmap = OS.gdk_pixmap_new(OS.gdk_get_default_root_window(), width, height, -1);
        if (pixmap == 0) {
            SWT.error(2);
        }
        if ((gdkGC = OS.gdk_gc_new(pixmap)) == 0) {
            SWT.error(2);
        }
        this.pixmap = pixmap;
        if (flag == 0) {
            OS.gdk_draw_drawable(pixmap, gdkGC, srcImage.pixmap, 0, 0, 0, 0, width, height);
            OS.g_object_unref(gdkGC);
        } else {
            int pixbuf = OS.gdk_pixbuf_new(0, false, 8, width, height);
            if (pixbuf == 0) {
                SWT.error(2);
            }
            int colormap = OS.gdk_colormap_get_system();
            OS.gdk_pixbuf_get_from_drawable(pixbuf, srcImage.pixmap, colormap, 0, 0, 0, 0, width, height);
            int stride = OS.gdk_pixbuf_get_rowstride(pixbuf);
            int pixels = OS.gdk_pixbuf_get_pixels(pixbuf);
            switch (flag) {
                case 1: {
                    Color zeroColor = device.getSystemColor(18);
                    RGB zeroRGB = zeroColor.getRGB();
                    byte zeroRed = (byte)zeroRGB.red;
                    byte zeroGreen = (byte)zeroRGB.green;
                    byte zeroBlue = (byte)zeroRGB.blue;
                    Color oneColor = device.getSystemColor(22);
                    RGB oneRGB = oneColor.getRGB();
                    byte oneRed = (byte)oneRGB.red;
                    byte oneGreen = (byte)oneRGB.green;
                    byte oneBlue = (byte)oneRGB.blue;
                    byte[] line = new byte[stride];
                    int y = 0;
                    while (y < height) {
                        C.memmove(line, pixels + y * stride, stride);
                        int x = 0;
                        while (x < width) {
                            int offset = x * 3;
                            int red = line[offset] & 0xFF;
                            int green = line[offset + 1] & 0xFF;
                            int blue = line[offset + 2] & 0xFF;
                            int intensity = red * red + green * green + blue * blue;
                            if (intensity < 98304) {
                                line[offset] = zeroRed;
                                line[offset + 1] = zeroGreen;
                                line[offset + 2] = zeroBlue;
                            } else {
                                line[offset] = oneRed;
                                line[offset + 1] = oneGreen;
                                line[offset + 2] = oneBlue;
                            }
                            ++x;
                        }
                        C.memmove(pixels + y * stride, line, stride);
                        ++y;
                    }
                    break;
                }
                case 2: {
                    byte[] line = new byte[stride];
                    int y = 0;
                    while (y < height) {
                        C.memmove(line, pixels + y * stride, stride);
                        int x = 0;
                        while (x < width) {
                            byte intensity;
                            int offset = x * 3;
                            int red = line[offset] & 0xFF;
                            int green = line[offset + 1] & 0xFF;
                            int blue = line[offset + 2] & 0xFF;
                            byte by = intensity = (byte)(red + red + green + green + green + green + green + blue >> 3);
                            line[offset + 2] = by;
                            line[offset + 1] = by;
                            line[offset] = by;
                            ++x;
                        }
                        C.memmove(pixels + y * stride, line, stride);
                        ++y;
                    }
                    break;
                }
            }
            OS.gdk_pixbuf_render_to_drawable(pixbuf, pixmap, gdkGC, 0, 0, 0, 0, width, height, 1, 0, 0);
            OS.g_object_unref(pixbuf);
            OS.g_object_unref(gdkGC);
        }
        this.init();
    }

    public Image(Device device, Rectangle bounds) {
        super(device);
        if (bounds == null) {
            SWT.error(4);
        }
        this.init(bounds.width, bounds.height);
        this.init();
    }

    public Image(Device device, ImageData data) {
        super(device);
        this.init(data);
        this.init();
    }

    public Image(Device device, ImageData source, ImageData mask) {
        super(device);
        if (source == null) {
            SWT.error(4);
        }
        if (mask == null) {
            SWT.error(4);
        }
        if (source.width != mask.width || source.height != mask.height) {
            SWT.error(5);
        }
        mask = ImageData.convertMask(mask);
        ImageData image = new ImageData(source.width, source.height, source.depth, source.palette, source.scanlinePad, source.data);
        image.maskPad = mask.scanlinePad;
        image.maskData = mask.data;
        this.init(image);
        this.init();
    }

    public Image(Device device, InputStream stream) {
        super(device);
        this.init(new ImageData(stream));
        this.init();
    }

    public Image(Device device, String filename) {
        super(device);
        if (filename == null) {
            SWT.error(4);
        }
        this.initNative(filename);
        if (this.pixmap == 0 && this.surface == 0) {
            this.init(new ImageData(filename));
        }
        this.init();
    }

    void initNative(String filename) {
        block6: {
            try {
                int length = filename.length();
                char[] chars = new char[length];
                filename.getChars(0, length, chars, 0);
                byte[] buffer = Converter.wcsToMbcs(null, chars, true);
                int pixbuf = OS.gdk_pixbuf_new_from_file(buffer, null);
                if (pixbuf == 0) break block6;
                try {
                    this.createFromPixbuf(0, pixbuf);
                }
                finally {
                    if (pixbuf != 0) {
                        OS.g_object_unref(pixbuf);
                    }
                }
            }
            catch (SWTException sWTException) {}
        }
    }

    void createAlphaMask(int width, int height) {
        if (this.device.useXRender && (this.alpha != -1 || this.alphaData != null)) {
            this.mask = OS.gdk_pixmap_new(0, this.alpha != -1 ? 1 : width, this.alpha != -1 ? 1 : height, 8);
            if (this.mask == 0) {
                SWT.error(2);
            }
            int gc = OS.gdk_gc_new(this.mask);
            if (this.alpha != -1) {
                GdkColor color = new GdkColor();
                color.pixel = (this.alpha & 0xFF) << 8 | this.alpha & 0xFF;
                OS.gdk_gc_set_foreground(gc, color);
                OS.gdk_draw_rectangle(this.mask, gc, 1, 0, 0, 1, 1);
            } else {
                int imagePtr = OS.gdk_drawable_get_image(this.mask, 0, 0, width, height);
                if (imagePtr == 0) {
                    SWT.error(2);
                }
                GdkImage gdkImage = new GdkImage();
                OS.memmove(gdkImage, imagePtr);
                if (gdkImage.bpl == width) {
                    C.memmove(gdkImage.mem, this.alphaData, this.alphaData.length);
                } else {
                    byte[] line = new byte[gdkImage.bpl];
                    int y = 0;
                    while (y < height) {
                        System.arraycopy(this.alphaData, width * y, line, 0, width);
                        C.memmove(gdkImage.mem + gdkImage.bpl * y, line, (int)gdkImage.bpl);
                        ++y;
                    }
                }
                OS.gdk_draw_image(this.mask, gc, imagePtr, 0, 0, 0, 0, width, height);
                OS.g_object_unref(imagePtr);
            }
            OS.g_object_unref(gc);
        }
    }

    void createFromPixbuf(int type, int pixbuf) {
        this.type = type;
        boolean hasAlpha = OS.gdk_pixbuf_get_has_alpha(pixbuf);
        if (OS.USE_CAIRO) {
            int width = this.width = OS.gdk_pixbuf_get_width(pixbuf);
            int height = this.height = OS.gdk_pixbuf_get_height(pixbuf);
            int stride = OS.gdk_pixbuf_get_rowstride(pixbuf);
            int pixels = OS.gdk_pixbuf_get_pixels(pixbuf);
            int format = hasAlpha ? 0 : 1;
            this.surface = Cairo.cairo_image_surface_create(format, width, height);
            if (this.surface == 0) {
                SWT.error(2);
            }
            int data = Cairo.cairo_image_surface_get_data(this.surface);
            int cairoStride = Cairo.cairo_image_surface_get_stride(this.surface);
            int oa = 0;
            int or = 0;
            int og = 0;
            int ob = 0;
            if (OS.BIG_ENDIAN) {
                oa = 0;
                or = 1;
                og = 2;
                ob = 3;
            } else {
                oa = 3;
                or = 2;
                og = 1;
                ob = 0;
            }
            byte[] line = new byte[stride];
            if (hasAlpha) {
                this.alphaData = new byte[width * height];
                int y = 0;
                int alphaOffset = 0;
                while (y < height) {
                    C.memmove(line, pixels + y * stride, stride);
                    int x = 0;
                    int offset = 0;
                    while (x < width) {
                        int a = line[offset + 3] & 0xFF;
                        int r = (line[offset + 0] & 0xFF) * a + 128;
                        r = r + (r >> 8) >> 8;
                        int g = (line[offset + 1] & 0xFF) * a + 128;
                        g = g + (g >> 8) >> 8;
                        int b = (line[offset + 2] & 0xFF) * a + 128;
                        b = b + (b >> 8) >> 8;
                        line[offset + oa] = (byte)a;
                        line[offset + or] = (byte)r;
                        line[offset + og] = (byte)g;
                        line[offset + ob] = (byte)b;
                        this.alphaData[alphaOffset++] = (byte)a;
                        ++x;
                        offset += 4;
                    }
                    C.memmove(data + y * stride, line, stride);
                    ++y;
                }
            } else {
                byte[] cairoLine = new byte[cairoStride];
                int y = 0;
                while (y < height) {
                    C.memmove(line, pixels + y * stride, stride);
                    int x = 0;
                    int offset = 0;
                    int cairoOffset = 0;
                    while (x < width) {
                        int r = line[offset + 0] & 0xFF;
                        int g = line[offset + 1] & 0xFF;
                        int b = line[offset + 2] & 0xFF;
                        cairoLine[cairoOffset + or] = (byte)r;
                        cairoLine[cairoOffset + og] = (byte)g;
                        cairoLine[cairoOffset + ob] = (byte)b;
                        ++x;
                        offset += 3;
                        cairoOffset += 4;
                    }
                    C.memmove(data + y * cairoStride, cairoLine, cairoStride);
                    ++y;
                }
            }
            Cairo.cairo_surface_mark_dirty(this.surface);
        } else {
            if (hasAlpha) {
                int width = OS.gdk_pixbuf_get_width(pixbuf);
                int height = OS.gdk_pixbuf_get_height(pixbuf);
                int stride = OS.gdk_pixbuf_get_rowstride(pixbuf);
                int pixels = OS.gdk_pixbuf_get_pixels(pixbuf);
                byte[] line = new byte[stride];
                this.alphaData = new byte[width * height];
                int y = 0;
                while (y < height) {
                    C.memmove(line, pixels + y * stride, stride);
                    int x = 0;
                    while (x < width) {
                        this.alphaData[y * width + x] = line[x * 4 + 3];
                        line[x * 4 + 3] = -1;
                        ++x;
                    }
                    C.memmove(pixels + y * stride, line, stride);
                    ++y;
                }
                this.createAlphaMask(width, height);
            }
            int[] pixmap_return = new int[1];
            OS.gdk_pixbuf_render_pixmap_and_mask(pixbuf, pixmap_return, null, 0);
            this.pixmap = pixmap_return[0];
            if (this.pixmap == 0) {
                SWT.error(2);
            }
        }
    }

    void createMask() {
        if (OS.USE_CAIRO) {
            int tb;
            int tg;
            int tr;
            int ob;
            int og;
            int or;
            int oa;
            int width = this.width;
            int height = this.height;
            int stride = Cairo.cairo_image_surface_get_stride(this.surface);
            int surfaceData = Cairo.cairo_image_surface_get_data(this.surface);
            if (OS.BIG_ENDIAN) {
                oa = 0;
                or = 1;
                og = 2;
                ob = 3;
                tr = this.transparentPixel >> 24 & 0xFF;
                tg = this.transparentPixel >> 16 & 0xFF;
                tb = this.transparentPixel >> 8 & 0xFF;
            } else {
                oa = 3;
                or = 2;
                og = 1;
                ob = 0;
                tr = this.transparentPixel >> 16 & 0xFF;
                tg = this.transparentPixel >> 8 & 0xFF;
                tb = this.transparentPixel >> 0 & 0xFF;
            }
            byte[] srcData = new byte[stride * height];
            C.memmove(srcData, surfaceData, srcData.length);
            int offset = 0;
            int y = 0;
            while (y < height) {
                int x = 0;
                while (x < width) {
                    int a = srcData[offset + oa] & 0xFF;
                    int r = srcData[offset + or] & 0xFF;
                    int g = srcData[offset + og] & 0xFF;
                    int b = srcData[offset + ob] & 0xFF;
                    if (r == tr && g == tg && b == tb) {
                        b = 0;
                        g = 0;
                        r = 0;
                        a = 0;
                    } else {
                        a = 255;
                    }
                    srcData[offset + oa] = (byte)a;
                    srcData[offset + or] = (byte)r;
                    srcData[offset + og] = (byte)g;
                    srcData[offset + ob] = (byte)b;
                    ++x;
                    offset += 4;
                }
                ++y;
            }
            C.memmove(surfaceData, srcData, srcData.length);
            return;
        }
        if (this.mask != 0) {
            return;
        }
        this.mask = this.createMask(this.getImageData(), false);
        if (this.mask == 0) {
            SWT.error(2);
        }
    }

    int createMask(ImageData image, boolean copy) {
        ImageData mask = image.getTransparencyMask();
        byte[] data = mask.data;
        byte[] maskData = copy ? new byte[data.length] : data;
        int i = 0;
        while (i < maskData.length) {
            byte s = data[i];
            maskData[i] = (byte)((s & 0x80) >> 7 | (s & 0x40) >> 5 | (s & 0x20) >> 3 | (s & 0x10) >> 1 | (s & 8) << 1 | (s & 4) << 3 | (s & 2) << 5 | (s & 1) << 7);
            ++i;
        }
        maskData = ImageData.convertPad(maskData, mask.width, mask.height, mask.depth, mask.scanlinePad, 1);
        return OS.gdk_bitmap_create_from_data(0, maskData, mask.width, mask.height);
    }

    void createSurface() {
        if (this.surface != 0) {
            return;
        }
        if (OS.GTK3) {
            return;
        }
        if (this.transparentPixel != -1) {
            this.createMask();
        }
        int[] w = new int[1];
        int[] h = new int[1];
        if (OS.GTK_VERSION >= OS.VERSION(2, 24, 0)) {
            OS.gdk_pixmap_get_size(this.pixmap, w, h);
        } else {
            OS.gdk_drawable_get_size(this.pixmap, w, h);
        }
        int width = w[0];
        int height = h[0];
        this.width = width;
        this.height = height;
        if (this.mask != 0 || this.alpha != -1 || this.alphaData != null) {
            int offset;
            int ob;
            int og;
            int or;
            int oa;
            int pixbuf = OS.gdk_pixbuf_new(0, true, 8, width, height);
            if (pixbuf == 0) {
                SWT.error(2);
            }
            int colormap = OS.gdk_colormap_get_system();
            OS.gdk_pixbuf_get_from_drawable(pixbuf, this.pixmap, colormap, 0, 0, 0, 0, width, height);
            int stride = OS.gdk_pixbuf_get_rowstride(pixbuf);
            int pixels = OS.gdk_pixbuf_get_pixels(pixbuf);
            byte[] line = new byte[stride];
            if (OS.BIG_ENDIAN) {
                oa = 0;
                or = 1;
                og = 2;
                ob = 3;
            } else {
                oa = 3;
                or = 2;
                og = 1;
                ob = 0;
            }
            if (this.mask != 0 && OS.gdk_drawable_get_depth(this.mask) == 1) {
                int maskPixbuf = OS.gdk_pixbuf_new(0, false, 8, width, height);
                if (maskPixbuf == 0) {
                    SWT.error(2);
                }
                OS.gdk_pixbuf_get_from_drawable(maskPixbuf, this.mask, 0, 0, 0, 0, 0, width, height);
                int maskStride = OS.gdk_pixbuf_get_rowstride(maskPixbuf);
                int maskPixels = OS.gdk_pixbuf_get_pixels(maskPixbuf);
                byte[] maskLine = new byte[maskStride];
                int offset2 = pixels;
                int maskOffset = maskPixels;
                int y = 0;
                while (y < height) {
                    C.memmove(line, offset2, stride);
                    C.memmove(maskLine, maskOffset, maskStride);
                    int x = 0;
                    int offset1 = 0;
                    while (x < width) {
                        if (maskLine[x * 3] == 0) {
                            line[offset1 + 3] = 0;
                            line[offset1 + 2] = 0;
                            line[offset1 + 1] = 0;
                            line[offset1 + 0] = 0;
                        } else {
                            byte r = line[offset1 + 0];
                            byte g = line[offset1 + 1];
                            byte b = line[offset1 + 2];
                            line[offset1 + oa] = -1;
                            line[offset1 + or] = r;
                            line[offset1 + og] = g;
                            line[offset1 + ob] = b;
                        }
                        ++x;
                        offset1 += 4;
                    }
                    C.memmove(offset2, line, stride);
                    offset2 += stride;
                    maskOffset += maskStride;
                    ++y;
                }
                OS.g_object_unref(maskPixbuf);
            } else if (this.alpha != -1) {
                offset = pixels;
                int y = 0;
                while (y < height) {
                    C.memmove(line, offset, stride);
                    int x = 0;
                    int offset1 = 0;
                    while (x < width) {
                        int r = (line[offset1 + 0] & 0xFF) * this.alpha + 128;
                        r = r + (r >> 8) >> 8;
                        int g = (line[offset1 + 1] & 0xFF) * this.alpha + 128;
                        g = g + (g >> 8) >> 8;
                        int b = (line[offset1 + 2] & 0xFF) * this.alpha + 128;
                        b = b + (b >> 8) >> 8;
                        line[offset1 + oa] = (byte)this.alpha;
                        line[offset1 + or] = (byte)r;
                        line[offset1 + og] = (byte)g;
                        line[offset1 + ob] = (byte)b;
                        ++x;
                        offset1 += 4;
                    }
                    C.memmove(offset, line, stride);
                    offset += stride;
                    ++y;
                }
            } else if (this.alphaData != null) {
                offset = pixels;
                int y = 0;
                while (y < h[0]) {
                    C.memmove(line, offset, stride);
                    int x = 0;
                    int offset1 = 0;
                    while (x < width) {
                        int alpha = this.alphaData[y * w[0] + x] & 0xFF;
                        int r = (line[offset1 + 0] & 0xFF) * alpha + 128;
                        r = r + (r >> 8) >> 8;
                        int g = (line[offset1 + 1] & 0xFF) * alpha + 128;
                        g = g + (g >> 8) >> 8;
                        int b = (line[offset1 + 2] & 0xFF) * alpha + 128;
                        b = b + (b >> 8) >> 8;
                        line[offset1 + oa] = (byte)alpha;
                        line[offset1 + or] = (byte)r;
                        line[offset1 + og] = (byte)g;
                        line[offset1 + ob] = (byte)b;
                        ++x;
                        offset1 += 4;
                    }
                    C.memmove(offset, line, stride);
                    offset += stride;
                    ++y;
                }
            } else {
                offset = pixels;
                int y = 0;
                while (y < h[0]) {
                    C.memmove(line, offset, stride);
                    int x = 0;
                    int offset1 = 0;
                    while (x < width) {
                        byte r = line[offset1 + 0];
                        byte g = line[offset1 + 1];
                        byte b = line[offset1 + 2];
                        line[offset1 + oa] = -1;
                        line[offset1 + or] = r;
                        line[offset1 + og] = g;
                        line[offset1 + ob] = b;
                        ++x;
                        offset1 += 4;
                    }
                    C.memmove(offset, line, stride);
                    offset += stride;
                    ++y;
                }
            }
            this.surface = Cairo.cairo_image_surface_create(0, width, height);
            int data = Cairo.cairo_image_surface_get_data(this.surface);
            C.memmove(data, pixels, stride * height);
            Cairo.cairo_surface_mark_dirty(this.surface);
            OS.g_object_unref(pixbuf);
        } else {
            int xDisplay = OS.gdk_x11_display_get_xdisplay(OS.gdk_display_get_default());
            int xDrawable = OS.GDK_PIXMAP_XID(this.pixmap);
            int xVisual = OS.gdk_x11_visual_get_xvisual(OS.gdk_visual_get_system());
            this.surface = Cairo.cairo_xlib_surface_create(xDisplay, xDrawable, xVisual, width, height);
        }
        if (this.transparentPixel != -1 && this.memGC != null) {
            this.destroyMask();
        }
    }

    void destroyMask() {
        if (this.mask == 0) {
            return;
        }
        OS.g_object_unref(this.mask);
        this.mask = 0;
    }

    void destroy() {
        if (this.memGC != null) {
            this.memGC.dispose();
        }
        if (this.pixmap != 0) {
            OS.g_object_unref(this.pixmap);
        }
        if (this.mask != 0) {
            OS.g_object_unref(this.mask);
        }
        if (this.surface != 0) {
            Cairo.cairo_surface_destroy(this.surface);
        }
        this.mask = 0;
        this.pixmap = 0;
        this.surface = 0;
        this.memGC = null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Image)) {
            return false;
        }
        Image image = (Image)object;
        if (OS.USE_CAIRO) {
            return this.device == image.device && this.surface == image.surface;
        }
        return this.device == image.device && this.pixmap == image.pixmap;
    }

    public Color getBackground() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (this.transparentPixel == -1) {
            return null;
        }
        return null;
    }

    public Rectangle getBounds() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (this.width != -1 && this.height != -1) {
            return new Rectangle(0, 0, this.width, this.height);
        }
        int[] w = new int[1];
        int[] h = new int[1];
        if (OS.GTK_VERSION >= OS.VERSION(2, 24, 0)) {
            OS.gdk_pixmap_get_size(this.pixmap, w, h);
        } else {
            OS.gdk_drawable_get_size(this.pixmap, w, h);
        }
        this.width = w[0];
        this.height = h[0];
        return new Rectangle(0, 0, this.width, this.height);
    }

    public ImageData getImageData() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (OS.USE_CAIRO) {
            int ob;
            int og;
            int or;
            int oa;
            boolean hasAlpha;
            int surface = ImageList.convertSurface(this);
            int format = Cairo.cairo_image_surface_get_format(surface);
            int width = Cairo.cairo_image_surface_get_width(surface);
            int height = Cairo.cairo_image_surface_get_height(surface);
            int stride = Cairo.cairo_image_surface_get_stride(surface);
            int surfaceData = Cairo.cairo_image_surface_get_data(surface);
            boolean bl = hasAlpha = format == 0;
            if (OS.BIG_ENDIAN) {
                oa = 0;
                or = 1;
                og = 2;
                ob = 3;
            } else {
                oa = 3;
                or = 2;
                og = 1;
                ob = 0;
            }
            byte[] srcData = new byte[stride * height];
            C.memmove(srcData, surfaceData, srcData.length);
            PaletteData palette = new PaletteData(0xFF0000, 65280, 255);
            ImageData data = new ImageData(width, height, 32, palette, 4, srcData);
            if (hasAlpha) {
                data.alphaData = new byte[width * height];
                byte[] alphaData = data.alphaData;
                int y = 0;
                int offset = 0;
                int alphaOffset = 0;
                while (y < height) {
                    int x = 0;
                    while (x < width) {
                        int a = srcData[offset + oa] & 0xFF;
                        int r = srcData[offset + or] & 0xFF;
                        int g = srcData[offset + og] & 0xFF;
                        int b = srcData[offset + ob] & 0xFF;
                        srcData[offset + 0] = 0;
                        alphaData[alphaOffset++] = (byte)a;
                        if (a != 0) {
                            srcData[offset + 1] = (byte)((r * 255 + a / 2) / a);
                            srcData[offset + 2] = (byte)((g * 255 + a / 2) / a);
                            srcData[offset + 3] = (byte)((b * 255 + a / 2) / a);
                        }
                        ++x;
                        offset += 4;
                    }
                    ++y;
                }
            } else {
                int y = 0;
                int offset = 0;
                while (y < height) {
                    int x = 0;
                    while (x < width) {
                        byte r = srcData[offset + or];
                        byte g = srcData[offset + og];
                        byte b = srcData[offset + ob];
                        srcData[offset + 0] = 0;
                        srcData[offset + 1] = r;
                        srcData[offset + 2] = g;
                        srcData[offset + 3] = b;
                        ++x;
                        offset += 4;
                    }
                    ++y;
                }
            }
            Cairo.cairo_surface_destroy(surface);
            return data;
        }
        int[] w = new int[1];
        int[] h = new int[1];
        if (OS.GTK_VERSION >= OS.VERSION(2, 24, 0)) {
            OS.gdk_pixmap_get_size(this.pixmap, w, h);
        } else {
            OS.gdk_drawable_get_size(this.pixmap, w, h);
        }
        int width = w[0];
        int height = h[0];
        int pixbuf = OS.gdk_pixbuf_new(0, false, 8, width, height);
        if (pixbuf == 0) {
            SWT.error(2);
        }
        int colormap = OS.gdk_colormap_get_system();
        OS.gdk_pixbuf_get_from_drawable(pixbuf, this.pixmap, colormap, 0, 0, 0, 0, width, height);
        int stride = OS.gdk_pixbuf_get_rowstride(pixbuf);
        int pixels = OS.gdk_pixbuf_get_pixels(pixbuf);
        byte[] srcData = new byte[stride * height];
        C.memmove(srcData, pixels, srcData.length);
        OS.g_object_unref(pixbuf);
        PaletteData palette = new PaletteData(0xFF0000, 65280, 255);
        ImageData data = new ImageData(width, height, 24, palette, 4, srcData);
        data.bytesPerLine = stride;
        if (this.transparentPixel == -1 && this.type == 1 && this.mask != 0) {
            int gdkImagePtr = OS.gdk_drawable_get_image(this.mask, 0, 0, width, height);
            if (gdkImagePtr == 0) {
                SWT.error(2);
            }
            GdkImage gdkImage = new GdkImage();
            OS.memmove(gdkImage, gdkImagePtr);
            byte[] maskData = new byte[gdkImage.bpl * gdkImage.height];
            C.memmove(maskData, gdkImage.mem, maskData.length);
            OS.g_object_unref(gdkImagePtr);
            int maskPad = 1;
            while (maskPad < 128) {
                int bpl = ((width + 7) / 8 + (maskPad - 1)) / maskPad * maskPad;
                if (gdkImage.bpl == bpl) break;
                ++maskPad;
            }
            data.maskPad = 2;
            maskData = ImageData.convertPad(maskData, width, height, 1, maskPad, data.maskPad);
            if (gdkImage.byte_order == 0) {
                int i = 0;
                while (i < maskData.length) {
                    byte b = maskData[i];
                    maskData[i] = (byte)((b & 1) << 7 | (b & 2) << 5 | (b & 4) << 3 | (b & 8) << 1 | (b & 0x10) >> 1 | (b & 0x20) >> 3 | (b & 0x40) >> 5 | (b & 0x80) >> 7);
                    ++i;
                }
            }
            data.maskData = maskData;
        }
        data.transparentPixel = this.transparentPixel;
        data.alpha = this.alpha;
        if (this.alpha == -1 && this.alphaData != null) {
            data.alphaData = new byte[this.alphaData.length];
            System.arraycopy(this.alphaData, 0, data.alphaData, 0, this.alphaData.length);
        }
        return data;
    }

    public static Image gtk_new(Device device, int type, int imageHandle, int mask) {
        Image image = new Image(device);
        image.type = type;
        if (OS.GTK3) {
            image.surface = imageHandle;
        } else {
            image.pixmap = imageHandle;
            if (OS.USE_CAIRO) {
                image.createSurface();
            }
        }
        image.mask = mask;
        return image;
    }

    public static Image gtk_new_from_pixbuf(Device device, int type, int pixbuf) {
        Image image = new Image(device);
        image.createFromPixbuf(type, pixbuf);
        image.type = type;
        return image;
    }

    public int hashCode() {
        if (OS.USE_CAIRO) {
            return this.surface;
        }
        return this.pixmap;
    }

    void init(int width, int height) {
        if (width <= 0 || height <= 0) {
            SWT.error(5);
        }
        this.type = 0;
        if (OS.USE_CAIRO) {
            int cairo;
            if (OS.GTK_VERSION >= OS.VERSION(2, 22, 0)) {
                this.surface = OS.gdk_window_create_similar_surface(OS.gdk_get_default_root_window(), 4096, width, height);
            } else {
                int xVisual;
                int xDrawable;
                int xDisplay = OS.gdk_x11_display_get_xdisplay(OS.gdk_display_get_default());
                int rootSurface = Cairo.cairo_xlib_surface_create(xDisplay, xDrawable = OS.gdk_x11_drawable_get_xid(OS.gdk_get_default_root_window()), xVisual = OS.gdk_x11_visual_get_xvisual(OS.gdk_visual_get_system()), 1, 1);
                if (rootSurface == 0) {
                    SWT.error(2);
                }
                this.surface = Cairo.cairo_surface_create_similar(rootSurface, 4096, width, height);
                Cairo.cairo_surface_destroy(rootSurface);
            }
            if (this.surface == 0) {
                SWT.error(2);
            }
            if ((cairo = Cairo.cairo_create(this.surface)) == 0) {
                SWT.error(2);
            }
            Cairo.cairo_set_source_rgb(cairo, 1.0, 1.0, 1.0);
            Cairo.cairo_rectangle(cairo, 0.0, 0.0, width, height);
            Cairo.cairo_fill(cairo);
            Cairo.cairo_destroy(cairo);
            this.width = width;
            this.height = height;
            return;
        }
        this.pixmap = OS.gdk_pixmap_new(OS.gdk_get_default_root_window(), width, height, -1);
        if (this.pixmap == 0) {
            SWT.error(2);
        }
        GdkColor white = new GdkColor();
        white.red = (short)-1;
        white.green = (short)-1;
        white.blue = (short)-1;
        int colormap = OS.gdk_colormap_get_system();
        OS.gdk_colormap_alloc_color(colormap, white, true, true);
        int gdkGC = OS.gdk_gc_new(this.pixmap);
        OS.gdk_gc_set_foreground(gdkGC, white);
        OS.gdk_draw_rectangle(this.pixmap, gdkGC, 1, 0, 0, width, height);
        OS.g_object_unref(gdkGC);
        OS.gdk_colormap_free_colors(colormap, white, 1);
    }

    void init(ImageData image) {
        boolean isIcon;
        int gdkGC;
        if (image == null) {
            SWT.error(4);
        }
        int width = this.width = image.width;
        int height = this.height = image.height;
        PaletteData palette = image.palette;
        if ((image.depth != 1 && image.depth != 2 && image.depth != 4 && image.depth != 8 || palette.isDirect) && image.depth != 8 && (image.depth != 16 && image.depth != 24 && image.depth != 32 || !palette.isDirect)) {
            SWT.error(38);
        }
        if (OS.USE_CAIRO) {
            int destOrder;
            int blueMask;
            int greenMask;
            int redMask;
            boolean hasAlpha = image.transparentPixel != -1 || image.alpha != -1 || image.maskData != null || image.alphaData != null;
            int format = hasAlpha ? 0 : 1;
            this.surface = Cairo.cairo_image_surface_create(format, width, height);
            if (this.surface == 0) {
                SWT.error(2);
            }
            int stride = Cairo.cairo_image_surface_get_stride(this.surface);
            int data = Cairo.cairo_image_surface_get_data(this.surface);
            int oa = 0;
            int or = 0;
            int og = 0;
            int ob = 0;
            int destDepth = 32;
            if (OS.BIG_ENDIAN) {
                oa = 0;
                or = 1;
                og = 2;
                ob = 3;
                redMask = 65280;
                greenMask = 0xFF0000;
                blueMask = -16777216;
                destOrder = 1;
            } else {
                oa = 3;
                or = 2;
                og = 1;
                ob = 0;
                redMask = 0xFF0000;
                greenMask = 65280;
                blueMask = 255;
                destOrder = 0;
            }
            byte[] buffer = image.data;
            if (!palette.isDirect || image.depth != destDepth || stride != image.bytesPerLine || palette.redMask != redMask || palette.greenMask != greenMask || palette.blueMask != blueMask || destOrder != image.getByteOrder()) {
                buffer = new byte[stride * height];
                if (palette.isDirect) {
                    ImageData.blit(1, image.data, image.depth, image.bytesPerLine, image.getByteOrder(), 0, 0, width, height, palette.redMask, palette.greenMask, palette.blueMask, 255, null, 0, 0, 0, buffer, destDepth, stride, destOrder, 0, 0, width, height, redMask, greenMask, blueMask, false, false);
                } else {
                    RGB[] rgbs = palette.getRGBs();
                    int length = rgbs.length;
                    byte[] srcReds = new byte[length];
                    byte[] srcGreens = new byte[length];
                    byte[] srcBlues = new byte[length];
                    int i = 0;
                    while (i < rgbs.length) {
                        RGB rgb = rgbs[i];
                        if (rgb != null) {
                            srcReds[i] = (byte)rgb.red;
                            srcGreens[i] = (byte)rgb.green;
                            srcBlues[i] = (byte)rgb.blue;
                        }
                        ++i;
                    }
                    ImageData.blit(1, image.data, image.depth, image.bytesPerLine, image.getByteOrder(), 0, 0, width, height, srcReds, srcGreens, srcBlues, 255, null, 0, 0, 0, buffer, destDepth, stride, destOrder, 0, 0, width, height, redMask, greenMask, blueMask, false, false);
                }
            }
            boolean isIcon2 = image.getTransparencyType() == 2;
            int n = this.type = isIcon2 ? 1 : 0;
            if (isIcon2 || image.transparentPixel != -1) {
                if (image.transparentPixel != -1) {
                    RGB rgb = null;
                    if (palette.isDirect) {
                        rgb = palette.getRGB(image.transparentPixel);
                    } else if (image.transparentPixel < palette.colors.length) {
                        rgb = palette.getRGB(image.transparentPixel);
                    }
                    if (rgb != null) {
                        this.transparentPixel = rgb.red << 16 | rgb.green << 8 | rgb.blue;
                    }
                }
                ImageData mask = image.getTransparencyMask();
                int y = 0;
                int offset = 0;
                while (y < height) {
                    int x = 0;
                    while (x < width) {
                        int alpha = mask.getPixel(x, y) == 0 ? 0 : 255;
                        int r = (buffer[offset + or] & 0xFF) * alpha + 128;
                        r = r + (r >> 8) >> 8;
                        int g = (buffer[offset + og] & 0xFF) * alpha + 128;
                        g = g + (g >> 8) >> 8;
                        int b = (buffer[offset + ob] & 0xFF) * alpha + 128;
                        b = b + (b >> 8) >> 8;
                        buffer[offset + oa] = (byte)alpha;
                        buffer[offset + or] = (byte)r;
                        buffer[offset + og] = (byte)g;
                        buffer[offset + ob] = (byte)b;
                        ++x;
                        offset += 4;
                    }
                    ++y;
                }
            } else {
                int r;
                int y;
                this.alpha = image.alpha;
                if (image.alpha == -1 && image.alphaData != null) {
                    this.alphaData = new byte[image.alphaData.length];
                    System.arraycopy(image.alphaData, 0, this.alphaData, 0, this.alphaData.length);
                }
                if (this.alpha != -1) {
                    y = 0;
                    int offset = 0;
                    while (y < height) {
                        int x = 0;
                        while (x < width) {
                            int alpha = this.alpha;
                            r = (buffer[offset + or] & 0xFF) * alpha + 128;
                            r = r + (r >> 8) >> 8;
                            int g = (buffer[offset + og] & 0xFF) * alpha + 128;
                            g = g + (g >> 8) >> 8;
                            int b = (buffer[offset + ob] & 0xFF) * alpha + 128;
                            b = b + (b >> 8) >> 8;
                            buffer[offset + oa] = (byte)alpha;
                            buffer[offset + or] = (byte)r;
                            buffer[offset + og] = (byte)g;
                            buffer[offset + ob] = (byte)b;
                            ++x;
                            offset += 4;
                        }
                        ++y;
                    }
                } else if (this.alphaData != null) {
                    y = 0;
                    int offset = 0;
                    while (y < height) {
                        int x = 0;
                        while (x < width) {
                            int alpha = this.alphaData[y * width + x] & 0xFF;
                            r = (buffer[offset + or] & 0xFF) * alpha + 128;
                            r = r + (r >> 8) >> 8;
                            int g = (buffer[offset + og] & 0xFF) * alpha + 128;
                            g = g + (g >> 8) >> 8;
                            int b = (buffer[offset + ob] & 0xFF) * alpha + 128;
                            b = b + (b >> 8) >> 8;
                            buffer[offset + oa] = (byte)alpha;
                            buffer[offset + or] = (byte)r;
                            buffer[offset + og] = (byte)g;
                            buffer[offset + ob] = (byte)b;
                            ++x;
                            offset += 4;
                        }
                        ++y;
                    }
                }
            }
            C.memmove(data, buffer, stride * height);
            Cairo.cairo_surface_mark_dirty(this.surface);
            return;
        }
        int pixbuf = OS.gdk_pixbuf_new(0, false, 8, width, height);
        if (pixbuf == 0) {
            SWT.error(2);
        }
        int stride = OS.gdk_pixbuf_get_rowstride(pixbuf);
        int data = OS.gdk_pixbuf_get_pixels(pixbuf);
        byte[] buffer = image.data;
        if (!palette.isDirect || image.depth != 24 || stride != image.bytesPerLine || palette.redMask != 0xFF0000 || palette.greenMask != 65280 || palette.blueMask != 255) {
            buffer = new byte[stride * height];
            if (palette.isDirect) {
                ImageData.blit(1, image.data, image.depth, image.bytesPerLine, image.getByteOrder(), 0, 0, width, height, palette.redMask, palette.greenMask, palette.blueMask, 255, null, 0, 0, 0, buffer, 24, stride, 1, 0, 0, width, height, 0xFF0000, 65280, 255, false, false);
            } else {
                RGB[] rgbs = palette.getRGBs();
                int length = rgbs.length;
                byte[] srcReds = new byte[length];
                byte[] srcGreens = new byte[length];
                byte[] srcBlues = new byte[length];
                int i = 0;
                while (i < rgbs.length) {
                    RGB rgb = rgbs[i];
                    if (rgb != null) {
                        srcReds[i] = (byte)rgb.red;
                        srcGreens[i] = (byte)rgb.green;
                        srcBlues[i] = (byte)rgb.blue;
                    }
                    ++i;
                }
                ImageData.blit(1, image.data, image.depth, image.bytesPerLine, image.getByteOrder(), 0, 0, width, height, srcReds, srcGreens, srcBlues, 255, null, 0, 0, 0, buffer, 24, stride, 1, 0, 0, width, height, 0xFF0000, 65280, 255, false, false);
            }
        }
        C.memmove(data, buffer, stride * height);
        int pixmap = OS.gdk_pixmap_new(OS.gdk_get_default_root_window(), width, height, -1);
        if (pixmap == 0) {
            SWT.error(2);
        }
        if ((gdkGC = OS.gdk_gc_new(pixmap)) == 0) {
            SWT.error(2);
        }
        OS.gdk_pixbuf_render_to_drawable(pixbuf, pixmap, gdkGC, 0, 0, 0, 0, width, height, 1, 0, 0);
        OS.g_object_unref(gdkGC);
        OS.g_object_unref(pixbuf);
        boolean bl = isIcon = image.getTransparencyType() == 2;
        if (isIcon || image.transparentPixel != -1) {
            int mask;
            if (image.transparentPixel != -1) {
                RGB rgb = null;
                if (palette.isDirect) {
                    rgb = palette.getRGB(image.transparentPixel);
                } else if (image.transparentPixel < palette.colors.length) {
                    rgb = palette.getRGB(image.transparentPixel);
                }
                if (rgb != null) {
                    this.transparentPixel = rgb.red << 16 | rgb.green << 8 | rgb.blue;
                }
            }
            if ((mask = this.createMask(image, isIcon)) == 0) {
                SWT.error(2);
            }
            this.mask = mask;
            this.type = isIcon ? 1 : 0;
        } else {
            this.type = 0;
            this.mask = 0;
            this.alpha = image.alpha;
            if (image.alpha == -1 && image.alphaData != null) {
                this.alphaData = new byte[image.alphaData.length];
                System.arraycopy(image.alphaData, 0, this.alphaData, 0, this.alphaData.length);
            }
            this.createAlphaMask(width, height);
        }
        this.pixmap = pixmap;
    }

    public int internal_new_GC(GCData data) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (this.type != 0 || this.memGC != null) {
            SWT.error(5);
        }
        int gc = OS.USE_CAIRO ? Cairo.cairo_create(this.surface) : OS.gdk_gc_new(this.pixmap);
        if (data != null) {
            int mask = 0x6000000;
            if ((data.style & mask) == 0) {
                data.style |= 0x2000000;
            } else if ((data.style & 0x4000000) != 0) {
                data.style |= 0x8000000;
            }
            data.device = this.device;
            data.drawable = this.pixmap;
            data.background = this.device.COLOR_WHITE.handle;
            data.foreground = this.device.COLOR_BLACK.handle;
            data.font = this.device.systemFont;
            data.image = this;
        }
        return gc;
    }

    public void internal_dispose_GC(int hDC, GCData data) {
        int gc = hDC;
        if (OS.USE_CAIRO) {
            Cairo.cairo_destroy(gc);
        } else {
            OS.g_object_unref(gc);
        }
    }

    public boolean isDisposed() {
        if (OS.USE_CAIRO) {
            return this.surface == 0;
        }
        return this.pixmap == 0;
    }

    public void setBackground(Color color) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        if (this.transparentPixel == -1) {
            return;
        }
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Image {*DISPOSED*}";
        }
        if (OS.USE_CAIRO) {
            return "Image {" + this.surface + "}";
        }
        return "Image {" + this.pixmap + "}";
    }
}

