/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.mycbr.gui.attribute.editor.type;

import de.dfki.mycbr.core.model.AttributeDesc;
import de.dfki.mycbr.core.model.FloatDesc;
import de.dfki.mycbr.gui.attribute.editor.type.AttributeTypeEditor;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class FloatAttributeEditor
extends AttributeTypeEditor {
    private Text txtMin;
    private Text txtMax;
    private FloatDesc attribute;
    private ControlDecoration cdTooLow;
    private ControlDecoration cdTooHigh;

    @Override
    public void init(AttributeDesc attribute) {
        this.attribute = (FloatDesc)attribute;
    }

    @Override
    public void fillModel() {
        this.txtMin.setText(String.valueOf(this.attribute.getMin()));
        this.txtMax.setText(String.valueOf(this.attribute.getMax()));
    }

    @Override
    public void buildComposite(Composite base) {
        Label lblMin = new Label(base, 0);
        lblMin.setText("Minimum");
        this.txtMin = new Text(base, 2048);
        this.cdTooHigh = new ControlDecoration((Control)this.txtMin, 16512);
        FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
        this.cdTooHigh.setDescriptionText("The min-value must be lower than the max value.");
        this.cdTooHigh.setImage(fieldDecoration.getImage());
        this.cdTooHigh.hide();
        Label lblMax = new Label(base, 0);
        lblMax.setText("Maximum");
        this.txtMax = new Text(base, 2048);
        this.cdTooLow = new ControlDecoration((Control)this.txtMax, 16512);
        this.cdTooLow.setDescriptionText("The max-value must be higher than the min value.");
        this.cdTooLow.setImage(fieldDecoration.getImage());
        this.cdTooLow.hide();
        this.fillModel();
        this.txtMin.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Float newValue = FloatAttributeEditor.this.parseFloat(FloatAttributeEditor.this.txtMin.getText());
                if (newValue.floatValue() > FloatAttributeEditor.this.attribute.getMax()) {
                    FloatAttributeEditor.this.cdTooHigh.show();
                } else {
                    FloatAttributeEditor.this.attribute.setMin(newValue.floatValue());
                    FloatAttributeEditor.this.cdTooHigh.hide();
                    try {
                        if (!FloatAttributeEditor.this.attribute.getOwner().getProject().getName().endsWith("_UNSAFED")) {
                            FloatAttributeEditor.this.attribute.getOwner().getProject().setName(String.valueOf(FloatAttributeEditor.this.attribute.getOwner().getProject().getName()) + "_UNSAFED");
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        this.txtMax.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Float newValue = FloatAttributeEditor.this.parseFloat(FloatAttributeEditor.this.txtMax.getText());
                if (newValue.floatValue() < FloatAttributeEditor.this.attribute.getMin()) {
                    FloatAttributeEditor.this.cdTooLow.show();
                } else {
                    FloatAttributeEditor.this.attribute.setMax(newValue.floatValue());
                    FloatAttributeEditor.this.cdTooLow.hide();
                    try {
                        if (!FloatAttributeEditor.this.attribute.getOwner().getProject().getName().endsWith("_UNSAFED")) {
                            FloatAttributeEditor.this.attribute.getOwner().getProject().setName(String.valueOf(FloatAttributeEditor.this.attribute.getOwner().getProject().getName()) + "_UNSAFED");
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).span(2, 1).applyTo((Control)this.txtMin);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).span(2, 1).applyTo((Control)this.txtMax);
    }

    private Float parseFloat(String str) {
        Float result = null;
        try {
            result = Float.valueOf(Float.parseFloat(str));
        }
        catch (NumberFormatException numberFormatException) {}
        return result;
    }

    @Override
    public String getName() {
        return "Float";
    }

    @Override
    public void save() {
    }

    @Override
    public String getClassName() {
        return this.attribute.getClass().getSimpleName();
    }
}

