/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.mycbr.gui.commands;

import de.dfki.mycbr.core.Project;
import de.dfki.mycbr.gui.casebase.list.CasebaseListView;
import de.dfki.mycbr.gui.function.list.FunctionListView;
import de.dfki.mycbr.gui.instance.list.InstanceListView;
import de.dfki.mycbr.gui.misc.MyCbrInterface;
import de.dfki.mycbr.gui.project.list.ProjectListView;
import java.io.File;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.handlers.IHandlerService;

public class CloseProjectHandler
extends AbstractHandler
implements IHandler {
    private Project project;
    private IWorkbenchPage page;
    private IWorkbenchWindow window;
    private IPerspectiveRegistry registry;
    private FunctionListView functionView;
    private CasebaseListView casebaseView;
    private InstanceListView instanceView;
    private int check;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object obj;
        this.window = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        this.registry = this.window.getWorkbench().getPerspectiveRegistry();
        this.page = this.window.getActivePage();
        ProjectListView view = (ProjectListView)this.page.findView("de.dfki.mycbr.gui.project.list.ProjectListView");
        this.check = 0;
        ISelection selection = view.getSite().getSelectionProvider().getSelection();
        if (selection != null && selection instanceof IStructuredSelection && (obj = ((IStructuredSelection)selection).getFirstElement()) != null && obj instanceof Project) {
            this.project = (Project)obj;
            System.out.println(this.project.getName());
            this.page.closeAllEditors(true);
            MyCbrInterface.getInstance().close(this.project);
            int i = 0;
            while (i <= 1) {
                this.casebaseView = (CasebaseListView)this.page.findView("de.dfki.mycbr.gui.casebase.list.CasebaseListView");
                this.instanceView = (InstanceListView)this.page.findView("de.dfki.mycbr.gui.instance.list.InstanceListView");
                if (this.casebaseView != null && this.project.equals(this.casebaseView.getCurrentProject())) {
                    this.casebaseView.clear();
                }
                if (this.instanceView != null && this.project.equals(this.instanceView.getProject())) {
                    this.instanceView.clear();
                }
                IHandlerService handlerService = (IHandlerService)this.window.getService(IHandlerService.class);
                try {
                    handlerService.executeCommand("de.dfki.mycbr.gui.project.list.ProjectListRefreshHandler", null);
                }
                catch (Exception exception) {
                    throw new RuntimeException("de.dfki.mycbr.gui.project.list.ProjectListRefreshHandler not found");
                }
                if (this.check == 1 && this.project.getName().endsWith("_UNSAFED")) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            Shell shell = new Shell(Display.getDefault());
                            MessageBox messageBox = new MessageBox(shell, 196);
                            messageBox.setMessage("Do you want to safe before closing?");
                            int rc = messageBox.open();
                            if (rc == 64) {
                                FileDialog fileDialog = new FileDialog(CloseProjectHandler.this.window.getShell(), 8192);
                                String[] filterExt = new String[]{"*.prj", "*.zip", "*.*"};
                                fileDialog.setFilterExtensions(filterExt);
                                String projectPath = fileDialog.open();
                                if (projectPath != null) {
                                    if (projectPath.endsWith(".zip") || projectPath.endsWith(".prj")) {
                                        projectPath = projectPath.substring(0, projectPath.lastIndexOf(46));
                                    }
                                    File file = new File(projectPath);
                                    try {
                                        CloseProjectHandler.this.project.setName(file.getName());
                                        CloseProjectHandler.this.project.setPath(String.valueOf(file.getParent()) + "/");
                                        CloseProjectHandler.this.project.save();
                                    }
                                    catch (Exception exception) {}
                                    Shell saveShell = new Shell(Display.getDefault());
                                    saveShell.setText("Saved");
                                    saveShell.setSize(250, 100);
                                    Monitor primary = Display.getDefault().getPrimaryMonitor();
                                    Rectangle bounds = primary.getBounds();
                                    Rectangle rect = saveShell.getBounds();
                                    int x = bounds.x + (bounds.width - rect.width) / 2;
                                    int y = bounds.y + (bounds.height - rect.height) / 2;
                                    saveShell.setLocation(x, y);
                                    Label label = new Label((Composite)saveShell, 0);
                                    label.setText("You have successfully saved the project!");
                                    label.setBounds(20, 20, 300, 20);
                                    saveShell.open();
                                    try {
                                        Thread.sleep(2000L);
                                        saveShell.close();
                                    }
                                    catch (InterruptedException e1) {
                                        e1.printStackTrace();
                                    }
                                }
                            }
                        }
                    });
                }
                if (this.check == 0) {
                    this.page.setPerspective(this.registry.findPerspectiveWithId("de.dfki.mycbr.gui.perspectives.CaseBasePerspective"));
                } else {
                    this.page.setPerspective(this.registry.findPerspectiveWithId("de.dfki.mycbr.gui.perspectives.Perspective"));
                }
                this.functionView = (FunctionListView)this.page.findView("de.dfki.mycbr.gui.function.list.FunctionListView");
                if (this.functionView != null && this.project.equals(this.functionView.getProject())) {
                    this.functionView.clear();
                }
                ++this.check;
                ++i;
            }
        }
        return null;
    }
}

