/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.mycbr.gui.commands;

import de.dfki.mycbr.gui.misc.MyCbrInterface;
import java.io.File;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.handlers.IHandlerService;

public class NewProjectHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        FileDialog dialog = new FileDialog(window.getShell(), 8192);
        dialog.setText("New Project");
        dialog.setFilterExtensions(new String[]{"*.prj", "*.zip", "*.*"});
        dialog.setFilterNames(new String[]{"myCBR project File (*.prj)", "zip File (*.zip)", "*.*"});
        String fileSelected = dialog.open();
        if (fileSelected != null) {
            MessageDialog messageDialog;
            int response;
            String projectName = fileSelected.substring(fileSelected.lastIndexOf(System.getProperty("file.separator")) + 1, fileSelected.lastIndexOf(46));
            if (MyCbrInterface.getInstance().projectExists(projectName)) {
                MessageDialog messageDialog2 = new MessageDialog(window.getShell(), "Project with this name already opened!", null, "A project with the same name is already open. It is currently not supported open several projects with the same name.", 4, new String[]{"Ok"}, 0);
                messageDialog2.open();
                return null;
            }
            File file = new File(fileSelected);
            if (file.exists() && (response = (messageDialog = new MessageDialog(window.getShell(), "File already exists!", null, "You are about to overwrite an existing file. Are you sure you want to continue?", 4, new String[]{"Overwrite", "Cancel"}, 0)).open()) != 0) {
                return null;
            }
            MyCbrInterface.getInstance().create(fileSelected);
            IHandlerService handlerService = (IHandlerService)window.getService(IHandlerService.class);
            try {
                handlerService.executeCommand("de.dfki.mycbr.gui.project.list.ProjectListRefreshHandler", null);
            }
            catch (Exception exception) {
                throw new RuntimeException("de.dfki.mycbr.gui.project.list.ProjectListRefreshHandler not found");
            }
        }
        return null;
    }
}

