/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.mycbr.gui.commands;

import de.dfki.mycbr.core.Project;
import de.dfki.mycbr.gui.Properties;
import de.dfki.mycbr.gui.misc.MyCbrInterface;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.handlers.IHandlerService;

public class OpenRecentHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        final IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        Shell shell = window.getShell();
        final Shell dialog = new Shell(shell, 67680);
        dialog.setText("Recent Projects...");
        dialog.setSize(600, 330);
        Label label = new Label((Composite)dialog, 0);
        label.setText("Recent Projects:");
        label.setBounds(20, 15, 100, 20);
        final List list = new List((Composite)dialog, 2818);
        list.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
                OpenRecentHandler.this.open(list, window, dialog);
            }
        });
        for (String p : Properties.getInstance().getRecentProjects()) {
            list.add(p);
        }
        list.setBounds(20, 35, 500, 200);
        final Button buttonOK = new Button((Composite)dialog, 8);
        buttonOK.setText("Open");
        buttonOK.setBounds(20, 255, 80, 25);
        Button buttonCancel = new Button((Composite)dialog, 8);
        buttonCancel.setText("Cancel");
        buttonCancel.setBounds(120, 255, 80, 25);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                if (event.widget == buttonOK) {
                    OpenRecentHandler.this.open(list, window, dialog);
                }
            }
        };
        buttonOK.addListener(13, listener);
        buttonCancel.addListener(13, listener);
        dialog.setActive();
        dialog.open();
        return null;
    }

    private void open(List list, IWorkbenchWindow window, Shell dialog) {
        String[] stringArray = list.getSelection();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            final Project project = MyCbrInterface.getInstance().load(s);
            if (project != null) {
                IHandlerService handlerService = (IHandlerService)window.getService(IHandlerService.class);
                try {
                    handlerService.executeCommand("de.dfki.mycbr.gui.project.list.ProjectListRefreshHandler", null);
                }
                catch (Exception exception) {
                    throw new RuntimeException("de.dfki.mycbr.gui.project.list.ProjectListRefreshHandler not found");
                }
                if (!s.endsWith(".XML")) {
                    Job job = new Job("Loading cases..."){

                        protected IStatus run(IProgressMonitor monitor) {
                            monitor.beginTask("Loading cases...", project.getTotalNumberOfCases());
                            int lastNumberOfCases = 0;
                            while (project.isImporting()) {
                                if (monitor.isCanceled()) {
                                    return Status.CANCEL_STATUS;
                                }
                                int currentNumberOfCases = project.getCurrentNumberOfCases();
                                monitor.worked(project.getCurrentNumberOfCases() - lastNumberOfCases);
                                lastNumberOfCases = currentNumberOfCases;
                                try {
                                    Thread.sleep(1000L);
                                }
                                catch (InterruptedException e) {
                                    e.printStackTrace();
                                }
                            }
                            monitor.done();
                            return Status.OK_STATUS;
                        }
                    };
                    job.setUser(true);
                    job.schedule();
                }
            }
            ++n2;
        }
        dialog.close();
    }
}

