/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.mycbr.gui.commands;

import de.dfki.mycbr.core.Project;
import de.dfki.mycbr.gui.filter.FilterManager;
import de.dfki.mycbr.gui.misc.MyCbrInterface;
import de.dfki.mycbr.gui.project.list.ProjectListView;
import java.io.IOException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.ui.handlers.HandlerUtil;

public class SaveHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (MyCbrInterface.getInstance().getProjects().size() == 1) {
            Project project = MyCbrInterface.getInstance().getProjects().get(0);
            IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
            IWorkbenchPage page = window.getActivePage();
            ProjectListView view = (ProjectListView)page.findView("de.dfki.mycbr.gui.project.list.ProjectListView");
            try {
                if (project.getName().endsWith("_UNSAFED")) {
                    project.setName(project.getName().substring(0, project.getName().length() - 8));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            project.save();
            view.refresh();
            try {
                FilterManager.getInstance().save(project);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (MyCbrInterface.getInstance().getProjects().size() > 1) {
            Object obj;
            Project project = null;
            IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
            IWorkbenchPage page = window.getActivePage();
            ProjectListView view = (ProjectListView)page.findView("de.dfki.mycbr.gui.project.list.ProjectListView");
            ISelection selection = view.getSite().getSelectionProvider().getSelection();
            if (selection != null && selection instanceof IStructuredSelection && (obj = ((IStructuredSelection)selection).getFirstElement()) != null && obj instanceof Project) {
                project = (Project)obj;
            }
            if (project == null) {
                ListDialog ld = new ListDialog(window.getShell());
                ld.setAddCancelButton(true);
                ld.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
                ld.setLabelProvider((ILabelProvider)new LabelProvider(){

                    public String getText(Object obj) {
                        return ((Project)obj).getName();
                    }
                });
                ld.setInput((Object)MyCbrInterface.getInstance().getProjects().toArray());
                ld.setTitle("Select the project to save:");
                ld.open();
                if (ld.getResult() != null) {
                    project = (Project)ld.getResult()[0];
                }
            }
            if (project != null) {
                try {
                    if (project.getName().endsWith("_UNSAFED")) {
                        project.setName(project.getName().substring(0, project.getName().length() - 8));
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                project.save();
                view.refresh();
                try {
                    FilterManager.getInstance().save(project);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }
}

