/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.mycbr.gui.filter;

import de.dfki.mycbr.core.model.AttributeDesc;
import de.dfki.mycbr.gui.filter.FilterEditorInput;
import de.dfki.mycbr.gui.filter.FilterManager;
import de.dfki.mycbr.gui.filter.IFilter;
import de.dfki.mycbr.gui.filter.InstanceFilter;
import de.dfki.mycbr.gui.filter.SetFilter;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.part.EditorPart;

public class FilterEditor
extends EditorPart {
    public static final String ID = "de.dfki.mycbr.gui.filter.FilterEditor";
    private FormToolkit toolkit;
    private ScrolledForm form;
    private IFilter f;
    private TableViewer tblLinks;

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.f = ((FilterEditorInput)input).getFilter();
        this.setPartName("Filter Editor");
        this.setTitleToolTip("Filter Editor");
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.form = this.toolkit.createScrolledForm(parent);
        if (this.f instanceof SetFilter) {
            this.createSetFilterUi((SetFilter)this.f);
        } else if (this.f instanceof InstanceFilter) {
            this.createInstanceFilterUi((InstanceFilter)this.f);
        }
    }

    private void createInstanceFilterUi(final InstanceFilter f) {
        GridLayoutFactory.fillDefaults().margins(5, 5).spacing(5, 3).numColumns(3).applyTo(this.form.getBody());
        Section sctCase = this.toolkit.createSection(this.form.getBody(), 384);
        sctCase.setText("Filter");
        GridDataFactory.fillDefaults().span(3, 1).applyTo((Control)sctCase);
        Label l0 = new Label(this.form.getBody(), 0);
        l0.setText("ID");
        Text txtName = new Text(this.form.getBody(), 18432);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)txtName);
        txtName.setText(f.getID());
        txtName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text t = (Text)e.widget;
                if (!t.getText().isEmpty()) {
                    f.setID(t.getText());
                }
            }
        });
        new Label(this.form.getBody(), 0).setText("Filter by attribute description");
        final Combo attDesc = new Combo(this.form.getBody(), 2048);
        final String[] attDescs = new String[f.getConcept().getAllAttributeDescs().size()];
        int i = 0;
        for (AttributeDesc att : f.getConcept().getAllAttributeDescs().values()) {
            attDescs[i++] = att.getName();
        }
        attDesc.setItems(attDescs);
        attDesc.setLayoutData((Object)new GridData(4, 2, true, false));
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)attDesc);
        attDesc.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AttributeDesc d = (AttributeDesc)f.getConcept().getAttributeDescs().get(attDescs[attDesc.getSelectionIndex()]);
                if (f.getInternalFilter() == null) {
                    f.setInternalFilter(new SetFilter());
                }
                if (f.getInternalFilter() instanceof SetFilter) {
                    SetFilter setFilter = (SetFilter)f.getInternalFilter();
                    setFilter.setDesc(d);
                    f.setInternalFilter(setFilter);
                }
            }
        });
        new Label(this.form.getBody(), 0).setText("Filter for attribute value");
        final Combo attFilter = new Combo(this.form.getBody(), 2048);
        int countSetFilter = 0;
        for (IFilter fil : FilterManager.getInstance().getFilter(f.getConcept().getProject())) {
            if (!(fil instanceof SetFilter)) continue;
            ++countSetFilter;
        }
        final String[] filter = new String[countSetFilter];
        int j = 0;
        for (IFilter fil : FilterManager.getInstance().getFilter(f.getConcept().getProject())) {
            if (!(fil instanceof SetFilter)) continue;
            filter[j++] = fil.getID();
        }
        attFilter.setItems(filter);
        attFilter.setLayoutData((Object)new GridData(4, 2, true, false));
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)attFilter);
        attFilter.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                for (IFilter fil : FilterManager.getInstance().getFilter(f.getConcept().getProject())) {
                    if (!fil.getID().equals(filter[attFilter.getSelectionIndex()])) continue;
                    AttributeDesc d = null;
                    if (f.getInternalFilter() != null) {
                        d = ((SetFilter)f.getInternalFilter()).getDesc();
                    }
                    ((SetFilter)fil).setDesc(d);
                    f.setInternalFilter(fil);
                    return;
                }
            }
        });
    }

    private void createSetFilterUi(final SetFilter f) {
        GridLayoutFactory.fillDefaults().margins(5, 5).spacing(5, 3).numColumns(3).applyTo(this.form.getBody());
        Section sctCase = this.toolkit.createSection(this.form.getBody(), 384);
        sctCase.setText("Filter");
        GridDataFactory.fillDefaults().span(3, 1).applyTo((Control)sctCase);
        Label l0 = new Label(this.form.getBody(), 0);
        l0.setText("ID");
        Text txtName = new Text(this.form.getBody(), 18432);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)txtName);
        txtName.setText(f.getID());
        txtName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text t = (Text)e.widget;
                if (!t.getText().isEmpty()) {
                    f.setID(t.getText());
                }
            }
        });
        Group group2 = new Group(this.form.getBody(), 2048);
        GridData data = new GridData(4, 0, true, false);
        data.horizontalSpan = 3;
        group2.setLayoutData((Object)data);
        group2.setLayout((Layout)new GridLayout());
        group2.setText("Filter elements that are");
        Button[] radioButtons2 = new Button[2];
        radioButtons2[0] = new Button((Composite)group2, 16);
        radioButtons2[0].setSelection(true);
        radioButtons2[0].setText("contained in base set");
        radioButtons2[0].pack();
        radioButtons2[1] = new Button((Composite)group2, 16);
        radioButtons2[1].setText("not contained in base set");
        radioButtons2[1].pack();
        radioButtons2[0].addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (f instanceof SetFilter) {
                    f.setType(SetFilter.FilterType.CONTAINED);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        radioButtons2[1].addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (f instanceof SetFilter) {
                    f.setType(SetFilter.FilterType.NOT_CONTAINED);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Group group3 = new Group(this.form.getBody(), 2048);
        group3.setLayout((Layout)new GridLayout(2, false));
        group3.setText("Base set");
        data = new GridData(4, 4, true, true);
        data.horizontalSpan = 3;
        group3.setLayoutData((Object)data);
        this.tblLinks = new TableViewer((Composite)group3, 68354);
        data = new GridData(4, 4, true, true);
        data.horizontalSpan = 1;
        data.verticalSpan = 3;
        this.tblLinks.getTable().setLayoutData((Object)data);
        this.tblLinks.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        for (String s : f.getBaseSet()) {
            this.tblLinks.add((Object)s);
        }
        Button btnAdd = new Button((Composite)group3, 8);
        btnAdd.setText("add");
        data = new GridData(0, 0x1000000, false, false);
        data.horizontalSpan = 1;
        data.verticalSpan = 1;
        btnAdd.setLayoutData((Object)data);
        Button btnRemove = new Button((Composite)group3, 8);
        btnRemove.setText("remove");
        data = new GridData(0, 0x1000000, false, false);
        data.horizontalSpan = 1;
        data.verticalSpan = 1;
        btnRemove.setLayoutData((Object)data);
        btnAdd.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                String newValue;
                SetFilter sf = f;
                do {
                    InputDialog inputDialog = new InputDialog(FilterEditor.this.form.getShell(), "Add filter element", "Please add a valid filter element", "", null);
                    inputDialog.open();
                    newValue = inputDialog.getValue();
                    if (newValue == null || newValue.isEmpty()) continue;
                    sf.add(newValue);
                    FilterEditor.this.tblLinks.setInput(sf.getBaseSet());
                } while (newValue != null && !newValue.isEmpty());
            }
        });
        btnRemove.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                if (FilterEditor.this.tblLinks.getSelection() != null) {
                    Object[] objectArray = ((IStructuredSelection)FilterEditor.this.tblLinks.getSelection()).toArray();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object o = objectArray[n2];
                        f.remove(o.toString());
                        FilterEditor.this.tblLinks.setInput(f.getBaseSet());
                        ++n2;
                    }
                }
            }
        });
    }

    public void setFocus() {
    }
}

