/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.mycbr.gui.filter;

import de.dfki.mycbr.core.casebase.FloatAttribute;
import de.dfki.mycbr.core.casebase.IntegerAttribute;
import de.dfki.mycbr.core.casebase.SimpleAttribute;
import de.dfki.mycbr.core.model.AttributeDesc;
import de.dfki.mycbr.gui.filter.IFilter;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class NumberFilter
extends ViewerFilter
implements IFilter {
    private Number n = 0;
    private FilterType type = FilterType.LESS;
    private AttributeDesc desc;
    private String ID = "";

    public void setDesc(AttributeDesc desc) {
        this.desc = desc;
    }

    public AttributeDesc getDesc() {
        return this.desc;
    }

    public void setN(Number n) {
        this.n = n;
    }

    public Number getN() {
        return this.n;
    }

    public void setType(FilterType type) {
        this.type = type;
    }

    public FilterType getType() {
        return this.type;
    }

    @Override
    public boolean select(Viewer viewer, Object parentElement, Object element) {
        AttributeDesc d;
        if (element instanceof SimpleAttribute && !(d = ((SimpleAttribute)element).getDesc()).equals(this.desc)) {
            return true;
        }
        Number v = null;
        if (element instanceof IntegerAttribute) {
            v = ((IntegerAttribute)element).getValue();
        } else if (element instanceof FloatAttribute) {
            v = Float.valueOf(((FloatAttribute)element).getValue());
        }
        if (v != null) {
            switch (this.type) {
                case LESS: {
                    return (double)((IntegerAttribute)element).getValue() < this.n.doubleValue();
                }
                case GREATER: {
                    return (double)((IntegerAttribute)element).getValue() > this.n.doubleValue();
                }
                case EQUAL: {
                    return (double)((IntegerAttribute)element).getValue() == this.n.doubleValue();
                }
                case LESS_EQUAL: {
                    return (double)((IntegerAttribute)element).getValue() <= this.n.doubleValue();
                }
                case GREATER_EQUAL: {
                    return (double)((IntegerAttribute)element).getValue() >= this.n.doubleValue();
                }
            }
            System.err.println("Unknown Filter Type: " + this.type.name());
            return true;
        }
        return true;
    }

    @Override
    public void setID(String iD) {
        this.ID = iD;
    }

    @Override
    public String getID() {
        return this.ID;
    }

    public static enum FilterType {
        LESS,
        GREATER,
        EQUAL,
        LESS_EQUAL,
        GREATER_EQUAL;

    }
}

