/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.mycbr.gui.function.editor;

import de.dfki.mycbr.core.model.ConceptDesc;
import de.dfki.mycbr.core.similarity.AmalgamationFct;
import de.dfki.mycbr.gui.function.editor.AmalgamationEditorInput;
import de.dfki.mycbr.gui.function.editor.ConceptDescEditorInput;
import de.dfki.mycbr.gui.function.editor.SetSimilarityWizard;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.part.EditorPart;

public class ConceptDescEditor
extends EditorPart {
    public static final String ID = "de.dfki.mycbr.gui.function.editor.ConceptDescEditor";
    private AmalgamationFct function;
    private ConceptDesc conceptDesc;

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.conceptDesc = ((ConceptDescEditorInput)input).getConceptDesc();
        this.function = ((ConceptDescEditorInput)input).getFunction();
        this.setPartName(this.function.getName());
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        this.createUi(parent);
    }

    private void createUi(Composite parent) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        ScrolledForm form = toolkit.createScrolledForm(parent);
        toolkit.createLabel(form.getBody(), "Amalgamation Function");
        Hyperlink lnkName = toolkit.createHyperlink(form.getBody(), this.function.getName(), 64);
        lnkName.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                AmalgamationEditorInput input = new AmalgamationEditorInput(ConceptDescEditor.this.function);
                try {
                    page.openEditor((IEditorInput)input, "de.dfki.mycbr.gui.function.editor.AmalgamationEditor");
                }
                catch (PartInitException ex) {
                    ex.printStackTrace();
                }
            }
        });
        final Shell shell = form.getShell();
        if (this.conceptDesc.isMultiple()) {
            Button btnSetSimilarity = toolkit.createButton(form.getBody(), "Configure set similarity", 8);
            btnSetSimilarity.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SetSimilarityWizard wizard = new SetSimilarityWizard(ConceptDescEditor.this.conceptDesc.getMultipleConfig(ConceptDescEditor.this.function));
                    WizardDialog wizardDialog = new WizardDialog(shell, (IWizard)wizard){

                        public void updateButtons() {
                            super.updateButtons();
                            this.getButton(1).setEnabled(false);
                        }
                    };
                    wizardDialog.create();
                    wizardDialog.open();
                }
            });
        }
        GridLayoutFactory.fillDefaults().margins(5, 5).spacing(5, 3).numColumns(3).applyTo(form.getBody());
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)lnkName);
    }

    public void setFocus() {
    }
}

