/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.mycbr.gui.instance.list;

import de.dfki.mycbr.core.Project;
import de.dfki.mycbr.core.casebase.Instance;
import de.dfki.mycbr.core.model.AttributeDesc;
import de.dfki.mycbr.core.model.Concept;
import de.dfki.mycbr.gui.instance.list.AddInstanceAction;
import de.dfki.mycbr.gui.instance.list.DeleteAction;
import de.dfki.mycbr.gui.instance.list.FillThread;
import de.dfki.mycbr.gui.instance.list.FilterAction;
import de.dfki.mycbr.gui.misc.ListUtil;
import de.dfki.mycbr.gui.misc.MyCbrInterface;
import de.dfki.mycbr.gui.plugin.Activator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;

public class InstanceListView
extends ViewPart {
    public static final String ID = "de.dfki.mycbr.gui.instance.list.InstanceListView";
    private TableViewer tableViewer;
    private FillThread thread;
    private DeleteAction deleteAction;
    private FilterAction filterAction;
    private Concept currentConcept;
    private Project project;
    ISelectionListener listener = new ISelectionListener(){

        public void selectionChanged(IWorkbenchPart part, ISelection sel) {
            if (!(sel instanceof IStructuredSelection) || sel == null) {
                return;
            }
            IStructuredSelection ss = (IStructuredSelection)sel;
            Object o = ss.getFirstElement();
            if (o instanceof Concept) {
                InstanceListView.this.currentConcept = (Concept)o;
                InstanceListView.this.project = InstanceListView.this.currentConcept.getProject();
                InstanceListView.this.fillTable();
            } else if (o instanceof AttributeDesc) {
                InstanceListView.this.currentConcept = ((AttributeDesc)o).getOwner();
                InstanceListView.this.project = InstanceListView.this.currentConcept.getProject();
                InstanceListView.this.fillTable();
            }
        }
    };

    public Concept getCurrentConcept() {
        return this.currentConcept;
    }

    public Project getProject() {
        return this.project;
    }

    public void createPartControl(Composite parent) {
        this.tableViewer = new TableViewer(parent, 770);
        this.tableViewer.setContentProvider((IContentProvider)new AttributeTreeContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new AttributeTreeLabelProvider());
        this.getSite().getPage().addSelectionListener(this.listener);
        this.getSite().setSelectionProvider((ISelectionProvider)this.tableViewer);
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection ss = (IStructuredSelection)event.getSelection();
                Object o = ss.getFirstElement();
                if (o instanceof Instance) {
                    IHandlerService handlerService = (IHandlerService)InstanceListView.this.getSite().getService(IHandlerService.class);
                    try {
                        handlerService.executeCommand("de.dfki.mycbr.gui.instance.list.CallInstanceEditor", null);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        throw new RuntimeException("de.dfki.mycbr.gui.instance.list.CallInstanceEditor not found");
                    }
                }
            }
        });
        MenuManager menuManager = new MenuManager();
        menuManager.add((IContributionItem)new Separator("additions"));
        this.tableViewer.getTable().setMenu(menuManager.createContextMenu((Control)this.tableViewer.getTable()));
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.tableViewer);
        AddInstanceAction addCaseAction = new AddInstanceAction(this);
        addCaseAction.setText("Add Case Base");
        addCaseAction.setImageDescriptor(ImageDescriptor.createFromImage((Image)Activator.getDefault().getImageRegistry().get("caseAddIcon")));
        this.getViewSite().getActionBars().getToolBarManager().add((IAction)addCaseAction);
        this.deleteAction = new DeleteAction(this.tableViewer, this);
        this.deleteAction.setText("Delete");
        this.deleteAction.setImageDescriptor(ImageDescriptor.createFromImage((Image)PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE")));
        this.getViewSite().getActionBars().getToolBarManager().add((IAction)this.deleteAction);
        this.deleteAction.setEnabled(false);
        this.filterAction = new FilterAction(this.tableViewer, this);
        this.filterAction.setImageDescriptor(ImageDescriptor.createFromImage((Image)Activator.getDefault().getImageRegistry().get("filterIcon")));
        this.getViewSite().getActionBars().getToolBarManager().add((IAction)this.filterAction);
        this.filterAction.setEnabled(true);
        Transfer[] transfers = new Transfer[]{TextTransfer.getInstance()};
        this.tableViewer.addDragSupport(2, transfers, new DragSourceListener(){

            public void dragFinished(DragSourceEvent event) {
            }

            public void dragSetData(DragSourceEvent event) {
                IStructuredSelection selection = (IStructuredSelection)InstanceListView.this.tableViewer.getSelection();
                String s = "";
                for (Object o : selection.toList()) {
                    Instance desc = (Instance)o;
                    s = s.concat(String.valueOf(desc.getName()) + ";");
                }
                event.data = s.substring(0, s.length() - 1);
            }

            public void dragStart(DragSourceEvent event) {
            }
        });
    }

    public void setFocus() {
    }

    public void addInstance(Instance i) {
        this.tableViewer.add((Object)i);
    }

    public void clear() {
        this.currentConcept = null;
        this.tableViewer.getTable().clearAll();
    }

    public void refresh(Concept c) {
        this.refresh(c, false);
    }

    public void refresh(Concept c, boolean force) {
        if (this.currentConcept.equals(c) && !force) {
            return;
        }
        this.currentConcept = c;
        this.fillTable();
    }

    public void fillTable() {
        if (this.thread != null) {
            this.thread.done();
        }
        if (this.currentConcept == null && MyCbrInterface.getInstance().getProjects().size() != 0) {
            this.currentConcept = (Concept)MyCbrInterface.getInstance().getProjects().get(0);
        }
        if (this.currentConcept != null) {
            this.tableViewer.getTable().clearAll();
            this.thread = new FillThread(this.tableViewer, this.currentConcept, this.deleteAction);
            this.thread.start();
            this.tableViewer.refresh();
        }
    }

    class AttributeTreeContentProvider
    implements ITreeContentProvider {
        AttributeTreeContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Concept) {
                Concept concept = (Concept)inputElement;
                if (InstanceListView.this.currentConcept == null) {
                    InstanceListView.this.currentConcept = concept;
                }
                return ListUtil.sortInstances(InstanceListView.this.currentConcept.getAllInstances()).toArray();
            }
            if (inputElement instanceof AttributeDesc) {
                InstanceListView.this.currentConcept = ((AttributeDesc)inputElement).getOwner();
                InstanceListView.this.project = InstanceListView.this.currentConcept.getProject();
                return ListUtil.sortInstances(InstanceListView.this.currentConcept.getAllInstances()).toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }
    }

    class AttributeTreeLabelProvider
    extends LabelProvider {
        AttributeTreeLabelProvider() {
        }

        public String getText(Object obj) {
            String columnText = "";
            if (obj instanceof Instance) {
                Instance inst = (Instance)obj;
                columnText = inst.getName();
            }
            return columnText;
        }

        public Image getColumnImage(Object obj, int index) {
            return this.getImage(obj);
        }

        public Image getImage(Object obj) {
            return Activator.getDefault().getImageRegistry().get("caseIcon");
        }
    }
}

