/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.mycbr.gui;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public class Properties {
    private static final Properties instance = new Properties();
    private static final int MAX_PROJECTS = 20;
    private LinkedList<String> recentProjects = new LinkedList();

    public static Properties getInstance() {
        return instance;
    }

    public List<String> getRecentProjects() {
        return this.recentProjects;
    }

    public void addRecentProject(String recentProject) {
        if (!this.hasRecentProject(recentProject)) {
            this.recentProjects.add(recentProject);
        }
    }

    public boolean hasRecentProject(String recentProject) {
        return this.recentProjects.contains(recentProject);
    }

    public void load() {
        File f = new File(".myCBR_config");
        if (f.exists()) {
            try {
                FileReader is = new FileReader(f);
                BufferedReader bis = new BufferedReader(is);
                String line = bis.readLine();
                while (line != null) {
                    String[] property = line.split("=");
                    if (property[0].equals(Property.RECENT_PROJECT.toString())) {
                        this.addRecentProject(property[1]);
                    }
                    line = bis.readLine();
                }
                is.close();
                bis.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            try {
                f.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void save() {
        try {
            FileWriter fstream = new FileWriter(".myCBR_config");
            BufferedWriter out = new BufferedWriter(fstream);
            int count = this.recentProjects.size();
            for (String p : this.recentProjects) {
                if (count <= 20) {
                    out.write(String.valueOf(Property.RECENT_PROJECT.toString()) + "=" + p);
                    out.newLine();
                    continue;
                }
                --count;
            }
            out.close();
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
        }
    }

    public static enum Property {
        RECENT_PROJECT;

    }
}

