/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.mycbr.gui.attribute.wizard;

import de.dfki.mycbr.core.model.AttributeDesc;
import de.dfki.mycbr.core.model.Concept;
import de.dfki.mycbr.core.model.DateDesc;
import de.dfki.mycbr.core.model.DoubleDesc;
import de.dfki.mycbr.core.model.FloatDesc;
import de.dfki.mycbr.core.model.IntegerDesc;
import de.dfki.mycbr.core.model.IntervalDesc;
import de.dfki.mycbr.core.model.SymbolDesc;
import de.dfki.mycbr.gui.attribute.wizard.AttributePage;
import java.lang.reflect.Constructor;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class AttributeWizard
extends Wizard {
    private Concept concept;
    private AttributeDesc attrDesc;

    public AttributeWizard(Concept concept) {
        this.concept = concept;
    }

    public void addPages() {
        this.addPage((IWizardPage)new AttributePage(this.concept));
    }

    public boolean performFinish() {
        AttributePage attrPage = (AttributePage)this.getPage("Attribute");
        AttributeDesc attrDesc = this.createAttribute(attrPage.getType(), attrPage.getAttrName());
        if (attrDesc != null) {
            attrDesc.setMultiple(attrPage.getMultiple());
            this.attrDesc = attrDesc;
            return true;
        }
        return false;
    }

    private AttributeDesc createAttribute(String attrType, String attrName) {
        try {
            if (attrType.equals("Float")) {
                return new FloatDesc(this.concept, attrName, 0.0f, 1.0f);
            }
            if (attrType.equals("Double")) {
                return new DoubleDesc(this.concept, attrName, 0.0, 1.0);
            }
            if (attrType.equals("Integer")) {
                return new IntegerDesc(this.concept, attrName, 0, 1);
            }
            if (attrType.equals("Interval")) {
                return new IntervalDesc(this.concept, attrName, (Number)0, (Number)1);
            }
            if (attrType.equals("Date")) {
                return new DateDesc(this.concept, attrName, new Date(), new Date(), new SimpleDateFormat());
            }
            if (attrType.equals("Symbol")) {
                return new SymbolDesc(this.concept, attrName, new HashSet());
            }
            Class<?> attributeClass = Class.forName("de.dfki.mycbr.core.model." + attrType + "Desc");
            Constructor<?> c = attributeClass.getConstructor(this.concept.getClass(), attrName.getClass());
            AttributeDesc attribute = (AttributeDesc)c.newInstance(this.concept, attrName);
            return attribute;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public AttributeDesc getAttributeDesc() {
        return this.attrDesc;
    }
}

