/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.mycbr.gui.csvimporter.wizard;

import de.dfki.mycbr.core.model.Concept;
import de.dfki.mycbr.io.CSVImporter;
import java.util.regex.Pattern;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class FilePage
extends WizardPage {
    public static final String PAGE_NAME = "File";
    private Text txtFile;
    private Text txtSeparator;
    private Text txtSeparatorMultiple;
    private Button btnFile;
    private TableViewer tblPreview;
    private Label lblCSV;
    private CSVImporter importer;
    private Concept concept;

    public FilePage(Concept concept) {
        super(PAGE_NAME, "File page", null);
        this.concept = concept;
    }

    public void createControl(Composite container) {
        Composite parent = new Composite(container, 0);
        Label lblSeparator = new Label(parent, 0);
        lblSeparator.setText("Separator (columns)");
        this.txtSeparator = new Text(parent, 2048);
        this.txtSeparator.setText(";");
        this.txtSeparator.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (FilePage.this.importer != null) {
                    String s = ((Text)e.widget).getText();
                    FilePage.this.importer.setSeparator(Pattern.quote(s));
                    FilePage.this.updatePreview();
                }
            }
        });
        Label lblSeparatorMultiple = new Label(parent, 0);
        lblSeparatorMultiple.setText("Separator (multiple values)");
        this.txtSeparatorMultiple = new Text(parent, 2048);
        this.txtSeparatorMultiple.setText(",");
        this.txtSeparatorMultiple.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (FilePage.this.importer != null) {
                    String s = ((Text)e.widget).getText();
                    FilePage.this.importer.setSeparatorMultiple(Pattern.quote(s));
                    FilePage.this.updatePreview();
                }
            }
        });
        Label lblFile = new Label(parent, 0);
        lblFile.setText("CSV file");
        this.txtFile = new Text(parent, 2056);
        final Shell shell = parent.getShell();
        this.btnFile = new Button(parent, 8);
        this.btnFile.setText("Choose...");
        this.btnFile.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(shell, 4096);
                dialog.setFilterExtensions(new String[]{"*.csv", "*.*"});
                dialog.setFilterNames(new String[]{"CSV Files (*.csv)", "*.*"});
                String fileSelected = dialog.open();
                if (fileSelected != null) {
                    FilePage.this.txtFile.setText(fileSelected);
                    FilePage.this.importer = new CSVImporter(fileSelected, FilePage.this.concept);
                    FilePage.this.importer.setSeparator(Pattern.quote(FilePage.this.txtSeparator.getText()));
                    FilePage.this.importer.setSeparatorMultiple(Pattern.quote(FilePage.this.txtSeparatorMultiple.getText()));
                    FilePage.this.updatePreview();
                    if (FilePage.this.tblPreview.getTable().getColumn(0).getText().equals(" ")) {
                        FilePage.this.setPageComplete(false);
                        FilePage.this.lblCSV.setVisible(true);
                    } else {
                        FilePage.this.lblCSV.setVisible(false);
                        FilePage.this.setPageComplete(true);
                    }
                }
            }
        });
        Label lblPreview = new Label(parent, 0);
        lblPreview.setText("Preview");
        this.tblPreview = new TableViewer(parent, 68356);
        this.tblPreview.getTable().setLinesVisible(true);
        this.tblPreview.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tblPreview.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.tblPreview.getTable().setHeaderVisible(true);
        GridLayoutFactory.fillDefaults().margins(5, 5).spacing(5, 3).numColumns(3).applyTo(parent);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.txtFile);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).span(2, 1).applyTo((Control)this.txtSeparator);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).span(2, 1).applyTo((Control)this.txtSeparatorMultiple);
        GridDataFactory.fillDefaults().align(4, 128).span(3, 1).applyTo((Control)lblPreview);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, true).span(3, 1).applyTo((Control)this.tblPreview.getTable());
        this.lblCSV = new Label(parent, 0);
        this.lblCSV.setText("This is not a valid csv file");
        this.lblCSV.setForeground(parent.getDisplay().getSystemColor(3));
        FontData[] fD = this.lblCSV.getFont().getFontData();
        fD[0].setHeight(14);
        this.lblCSV.setFont(new Font((Device)parent.getDisplay(), fD[0]));
        this.lblCSV.setVisible(false);
        this.setControl((Control)parent);
        this.setPageComplete(false);
    }

    private void updatePreview() {
        this.importer.reset();
        this.importer.readData();
        this.importer.checkData();
        this.createColumns(this.importer.getHeader().length);
        this.tblPreview.setInput((Object)this.importer.getData());
        this.tblPreview.getTable().pack(true);
        this.getControl().setSize(this.getControl().getSize().x + 1, this.getControl().getSize().y + 1);
    }

    private void createColumns(int numCols) {
        TableColumn c;
        int i;
        int difference = numCols - this.tblPreview.getTable().getColumnCount();
        if (difference > 0) {
            i = 0;
            while (i < difference) {
                c = new TableColumn(this.tblPreview.getTable(), 0, this.tblPreview.getTable().getColumnCount());
                c.pack();
                ++i;
            }
        } else if (difference < 0) {
            i = 0;
            while (i < -difference) {
                this.tblPreview.getTable().getColumn(0).dispose();
                ++i;
            }
        }
        i = 0;
        while (i < numCols) {
            c = this.tblPreview.getTable().getColumn(i);
            c.setText(this.importer.getHeader()[i]);
            ++i;
        }
    }

    public CSVImporter getImporter() {
        return this.importer;
    }

    private class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private TableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String[] row = (String[])element;
            if (columnIndex < row.length) {
                return row[columnIndex];
            }
            return "";
        }
    }
}

