/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.mycbr.gui.filter;

import de.dfki.mycbr.core.Project;
import de.dfki.mycbr.gui.filter.IFilter;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class FilterManager
extends Observable {
    private HashMap<Project, List<IFilter>> filterMap = new HashMap();
    private static final FilterManager instance = new FilterManager();
    public static final String CONFIG_FILE_EXTENSION = ".config";
    private ZipFile zipfile;
    private String path;
    private static final int BUFFER_SIZE = 1024;
    private String myCBR;
    private String myCB;
    private String myExp;
    private String config;

    private FilterManager() {
    }

    public static FilterManager getInstance() {
        return instance;
    }

    public void addFilter(Project p, IFilter f) {
        List<IFilter> filter = this.filterMap.get(p);
        if (filter == null) {
            filter = new LinkedList<IFilter>();
        }
        filter.add(f);
        this.filterMap.put(p, filter);
        this.setChanged();
        this.notifyObservers(f);
    }

    public boolean removeFilter(Project p, IFilter f) {
        List<IFilter> filter = this.filterMap.get(p);
        if (filter == null) {
            return false;
        }
        boolean removed = filter.remove(f);
        if (removed) {
            this.setChanged();
            this.notifyObservers(f);
        }
        return removed;
    }

    public List<IFilter> getFilter(Project p) {
        List<IFilter> f = this.filterMap.get(p);
        if (f == null) {
            f = new LinkedList<IFilter>();
        }
        return f;
    }

    public void save(Project prj) throws IOException {
        this.zipfile = new ZipFile(String.valueOf(prj.getPath()) + prj.getName() + prj.getExtension());
        this.path = String.valueOf(prj.getPath()) + prj.getName() + prj.getExtension();
        System.err.println(this.path);
        Enumeration<? extends ZipEntry> e = this.zipfile.entries();
        while (e.hasMoreElements()) {
            ZipEntry entry = e.nextElement();
            String filename = String.valueOf(this.path.substring(0, this.path.lastIndexOf(File.separator))) + File.separator + entry.getName();
            if (filename.endsWith(".myCBR")) {
                this.myCBR = filename;
            } else if (filename.endsWith(".myCB")) {
                this.myCB = filename;
            } else if (filename.endsWith(".myExp")) {
                this.myExp = filename;
            } else if (filename.endsWith(CONFIG_FILE_EXTENSION)) {
                this.config = filename;
            }
            try {
                this.copyInputStream(this.zipfile.getInputStream(entry), new BufferedOutputStream(new FileOutputStream(filename)));
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        if (this.config == null) {
            this.config = this.myCBR.replace(".myCBR", CONFIG_FILE_EXTENSION);
        }
        try {
            FileOutputStream fout = new FileOutputStream(new File(this.config));
            BufferedOutputStream bout = new BufferedOutputStream(fout);
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)bout, "8859_1");
            out.write("<?xml version=\"1.0\" ");
            out.write("encoding=\"ISO-8859-1\"?>\r\n");
            out.write("<Config author=\"" + FilterManager.encode(prj.getAuthor()) + "\" >\r\n");
            for (IFilter f : FilterManager.getInstance().getFilter(prj)) {
                out.write("<filter id=\"" + FilterManager.encode(f.getID()) + "\" >\r\n");
                out.write("</filter>\r\n");
            }
            out.write("</Config>\r\n");
            out.flush();
            out.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.zip(this.path);
    }

    private void zip(String path) {
        new File(path).delete();
        FileOutputStream dest = null;
        try {
            dest = new FileOutputStream(path);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(dest));
        File f1 = new File(this.myCBR);
        File f2 = new File(this.myCB);
        File f3 = new File(this.myExp);
        File f4 = new File(this.config);
        FilterManager.addFile(f1, out);
        FilterManager.addFile(f2, out);
        FilterManager.addFile(f3, out);
        FilterManager.addFile(f4, out);
        new File(this.myCBR).delete();
        new File(this.myCB).delete();
        new File(this.myExp).delete();
        new File(this.config).delete();
        try {
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void addFile(File f, ZipOutputStream out) {
        try {
            int len;
            byte[] data = new byte[2048];
            FileInputStream in = new FileInputStream(f);
            int slash = f.getName().lastIndexOf(File.separator);
            String name = f.getName().substring(slash + 1);
            out.putNextEntry(new ZipEntry(name));
            while ((len = in.read(data)) > 0) {
                out.write(data, 0, len);
            }
            in.close();
            out.closeEntry();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String encode(String in) {
        if (in == null) {
            return null;
        }
        boolean anyCharactersProtected = false;
        StringBuffer stringBuffer = new StringBuffer();
        int i = 0;
        while (i < in.length()) {
            boolean characterWithSpecialMeaningInXML;
            char ch = in.charAt(i);
            boolean controlCharacter = ch < ' ';
            boolean unicodeButNotAscii = ch > '~';
            boolean bl = characterWithSpecialMeaningInXML = ch == '<' || ch == '&' || ch == '>' || ch == '\"';
            if (characterWithSpecialMeaningInXML || unicodeButNotAscii || controlCharacter) {
                stringBuffer.append("&#" + ch + ";");
                anyCharactersProtected = true;
            } else {
                stringBuffer.append(ch);
            }
            ++i;
        }
        if (!anyCharactersProtected) {
            return in;
        }
        return stringBuffer.toString();
    }

    public void copyInputStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        while ((len = in.read(buffer)) >= 0) {
            out.write(buffer, 0, len);
        }
        in.close();
        out.close();
    }
}

