/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.mycbr.gui.filter;

import de.dfki.mycbr.core.Project;
import de.dfki.mycbr.core.casebase.Instance;
import de.dfki.mycbr.core.casebase.SimpleAttribute;
import de.dfki.mycbr.core.casebase.SymbolAttribute;
import de.dfki.mycbr.core.model.AttributeDesc;
import de.dfki.mycbr.core.model.Concept;
import de.dfki.mycbr.core.model.ConceptDesc;
import de.dfki.mycbr.gui.filter.FilterManager;
import de.dfki.mycbr.gui.filter.IFilter;
import java.util.HashSet;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class SetFilter
extends ViewerFilter
implements IFilter {
    private HashSet<String> baseSet = new HashSet();
    private FilterType type = FilterType.CONTAINED;
    private ApplicableType applyType = ApplicableType.STRING;
    private AttributeDesc desc;
    private String ID = "";
    private Project p;

    public SetFilter(Project p) {
        this.p = p;
        FilterManager.getInstance().addFilter(p, this);
    }

    public SetFilter() {
    }

    public Project getProject() {
        return this.p;
    }

    public void setDesc(AttributeDesc desc) {
        this.desc = desc;
    }

    public AttributeDesc getDesc() {
        return this.desc;
    }

    public boolean add(String s) {
        return this.baseSet.add(s);
    }

    public boolean remove(String s) {
        return this.baseSet.remove(s);
    }

    public boolean contains(String s) {
        return this.baseSet.contains(s);
    }

    public HashSet<String> getBaseSet() {
        return this.baseSet;
    }

    public void setType(FilterType type) {
        this.type = type;
    }

    public FilterType getType() {
        return this.type;
    }

    public void setApplyType(ApplicableType applyType) {
        this.applyType = applyType;
    }

    public ApplicableType getApplyType() {
        return this.applyType;
    }

    @Override
    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (this.applyType != ApplicableType.INSTANCE) {
            if (element instanceof SimpleAttribute) {
                AttributeDesc d = ((SimpleAttribute)element).getDesc();
                if (!d.equals(this.desc)) {
                    return true;
                }
            } else if (element instanceof Instance) {
                ConceptDesc cd;
                Concept c2;
                Concept c1 = ((Instance)element).getConcept();
                if (this.desc != null && this.desc instanceof ConceptDesc && !c1.equals(c2 = (cd = (ConceptDesc)this.desc).getConcept())) {
                    return true;
                }
            }
        }
        switch (this.applyType) {
            case SYMBOL: {
                if (!(element instanceof SymbolAttribute)) break;
                switch (this.type) {
                    case CONTAINED: {
                        return this.baseSet.contains(((SymbolAttribute)element).getValueAsString());
                    }
                    case NOT_CONTAINED: {
                        return !this.baseSet.contains(((SymbolAttribute)element).getValueAsString());
                    }
                }
                System.err.println("Unknown Filter Type: " + this.type.name());
                return true;
            }
            case INSTANCE: {
                if (element instanceof Instance) {
                    switch (this.type) {
                        case CONTAINED: {
                            return this.baseSet.contains(((Instance)element).getValueAsString());
                        }
                        case NOT_CONTAINED: {
                            return !this.baseSet.contains(((Instance)element).getValueAsString());
                        }
                    }
                    System.err.println("Unknown Filter Type: " + this.type.name());
                    return true;
                }
                if (!(element instanceof String)) break;
                switch (this.type) {
                    case CONTAINED: {
                        return this.baseSet.contains(element);
                    }
                    case NOT_CONTAINED: {
                        return !this.baseSet.contains(element);
                    }
                }
                System.err.println("Unknown Filter Type: " + this.type.name());
                return true;
            }
            case STRING: {
                switch (this.type) {
                    case CONTAINED: {
                        return this.baseSet.contains(element.toString());
                    }
                    case NOT_CONTAINED: {
                        return !this.baseSet.contains(element.toString());
                    }
                }
                System.err.println("Unknown Filter Type: " + this.type.name());
                return true;
            }
            default: {
                System.err.println("Unknown application type for filter: " + this.applyType.name());
                return true;
            }
        }
        return true;
    }

    @Override
    public void setID(String iD) {
        this.ID = iD;
    }

    @Override
    public String getID() {
        return this.ID;
    }

    public static enum ApplicableType {
        STRING,
        SYMBOL,
        INSTANCE;

    }

    public static enum FilterType {
        CONTAINED,
        NOT_CONTAINED;

    }
}

