/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.mycbr.gui.function.editor;

import de.dfki.mycbr.core.model.IntegerDesc;
import de.dfki.mycbr.core.similarity.AdvancedIntegerFct;
import de.dfki.mycbr.core.similarity.Similarity;
import de.dfki.mycbr.core.similarity.config.DistanceConfig;
import de.dfki.mycbr.gui.function.editor.AdvancedIntegerEditorInput;
import de.dfki.mycbr.gui.function.editor.MultipleInputDialog;
import de.dfki.mycbr.gui.function.editor.SetSimilarityWizard;
import de.dfki.mycbr.gui.function.editor.function2d.AdvancedIntegerFunction2D;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.function.Function2D;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.data.xy.XYDataset;
import org.jfree.experimental.chart.swt.ChartComposite;

public class AdvancedIntegerEditor
extends EditorPart {
    public static final String ID = "de.dfki.mycbr.gui.function.editor.AdvancedIntegerEditor";
    private AdvancedIntegerFct function;
    private Button[] btnSymmetry;
    private TableViewer tblPoints;
    private ChartComposite cmpChart;
    private double min;
    private double max;
    private double diff;
    private static final String DISTANCE_PROPERTY = "Distance";
    private static final String SIMILARITY_PROPERTY = "Similarity";

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.function = ((AdvancedIntegerEditorInput)input).getFunction();
        this.min = ((IntegerDesc)this.function.getDesc()).getMin().intValue();
        this.max = ((IntegerDesc)this.function.getDesc()).getMax().intValue();
        this.diff = this.max - this.min;
        this.setPartName(this.function.getName());
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        this.createUi(parent);
        this.fillModel();
        this.addDirtyOnChangeListeners();
    }

    private void createUi(Composite parent) {
        Label lblSymmetry = new Label(parent, 0);
        lblSymmetry.setText("Symmetry");
        Composite cmpSymmetry = new Composite(parent, 0);
        cmpSymmetry.setLayout((Layout)new FillLayout(256));
        this.btnSymmetry = new Button[2];
        this.btnSymmetry[0] = new Button(cmpSymmetry, 16);
        this.btnSymmetry[0].setText("symmetric");
        this.btnSymmetry[1] = new Button(cmpSymmetry, 16);
        this.btnSymmetry[1].setText("asymmetric");
        Label lblPoints = new Label(parent, 0);
        lblPoints.setText("Similarity Points");
        this.tblPoints = new TableViewer(parent, 772);
        this.tblPoints.getTable().setLinesVisible(true);
        this.tblPoints.getTable().setHeaderVisible(true);
        this.tblPoints.setContentProvider((IContentProvider)new PointContentProvider());
        this.tblPoints.setLabelProvider((IBaseLabelProvider)new PointLabelProvider());
        TableColumn tcnDistance = new TableColumn(this.tblPoints.getTable(), 16384);
        tcnDistance.setText(DISTANCE_PROPERTY);
        tcnDistance.setWidth(100);
        TableColumn tcnSimilarity = new TableColumn(this.tblPoints.getTable(), 16384);
        tcnSimilarity.setText(SIMILARITY_PROPERTY);
        tcnSimilarity.setWidth(100);
        CellEditor[] tblPointsEditors = new CellEditor[2];
        TextCellEditor tceDistance = new TextCellEditor((Composite)this.tblPoints.getTable());
        tblPointsEditors[0] = tceDistance;
        TextCellEditor tceSimilarity = new TextCellEditor((Composite)this.tblPoints.getTable());
        tblPointsEditors[1] = tceSimilarity;
        this.tblPoints.setColumnProperties(new String[]{DISTANCE_PROPERTY, SIMILARITY_PROPERTY});
        this.tblPoints.setCellEditors(tblPointsEditors);
        this.tblPoints.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return true;
            }

            public Object getValue(Object element, String property) {
                Map.Entry point = (Map.Entry)element;
                if (property.equals(AdvancedIntegerEditor.DISTANCE_PROPERTY)) {
                    return ((Double)point.getKey()).toString();
                }
                return String.valueOf(((Similarity)point.getValue()).getValue());
            }

            public void modify(Object element, String property, Object value) {
                TableItem tableItem = (TableItem)element;
                Map.Entry point = (Map.Entry)tableItem.getData();
                if (property.equals(AdvancedIntegerEditor.DISTANCE_PROPERTY)) {
                    Similarity oldSim = (Similarity)point.getValue();
                    AdvancedIntegerEditor.this.function.getAdditionalPoints().remove(point.getKey());
                    AdvancedIntegerEditor.this.function.addAdditionalPoint(Double.valueOf((String)value), oldSim);
                    AdvancedIntegerEditor.this.tblPoints.setInput((Object)AdvancedIntegerEditor.this.function.getAdditionalPoints());
                } else {
                    Similarity newSim = Similarity.get((Double)Double.valueOf((String)value));
                    point.setValue(newSim);
                    AdvancedIntegerEditor.this.tblPoints.refresh((Object)point);
                }
                AdvancedIntegerEditor.this.redrawChart();
            }
        });
        Composite cmpButtonGroup = new Composite(parent, 0);
        FillLayout cmpButtonGroupLayout = new FillLayout(512);
        cmpButtonGroup.setLayout((Layout)cmpButtonGroupLayout);
        Button btnAdd = new Button(cmpButtonGroup, 8);
        btnAdd.setText("Add");
        Button btnRemove = new Button(cmpButtonGroup, 8);
        btnRemove.setText("Remove");
        final Shell shell = parent.getShell();
        btnAdd.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                IInputValidator distanceValidator = new IInputValidator(){

                    public String isValid(String newText) {
                        block4: {
                            try {
                                if (!newText.isEmpty()) break block4;
                                return "You must enter a distance value";
                            }
                            catch (NumberFormatException numberFormatException) {
                                return "This is not a valid number";
                            }
                        }
                        if (AdvancedIntegerEditor.this.function.getAdditionalPoints().containsKey(Double.valueOf(newText))) {
                            return "This distance already exists.";
                        }
                        return null;
                    }
                };
                IInputValidator similarityValidator = new IInputValidator(){

                    public String isValid(String newText) {
                        if (newText.isEmpty()) {
                            return "You must enter a similarity value";
                        }
                        double d = Double.valueOf(newText);
                        if (d < 0.0 || d > 1.0) {
                            return "This similarity value must be between 0 and 1.";
                        }
                        return null;
                    }
                };
                ArrayList<String> dialogMessages = new ArrayList<String>(Arrays.asList("Please enter a distance", "Please enter a similarity value"));
                ArrayList<IInputValidator> validators = new ArrayList<IInputValidator>(Arrays.asList(distanceValidator, similarityValidator));
                MultipleInputDialog inputDialog = new MultipleInputDialog(shell, "Add an additional point", dialogMessages, validators);
                inputDialog.open();
                List<String> newValues = inputDialog.getValue();
                if (newValues != null) {
                    Similarity newSim = Similarity.get((Double)Double.valueOf(newValues.get(1)));
                    AdvancedIntegerEditor.this.function.addAdditionalPoint(Double.valueOf(newValues.get(0)), newSim);
                }
                AdvancedIntegerEditor.this.tblPoints.setInput((Object)AdvancedIntegerEditor.this.function.getAdditionalPoints());
                AdvancedIntegerEditor.this.redrawChart();
            }
        });
        btnRemove.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection ss = (IStructuredSelection)AdvancedIntegerEditor.this.tblPoints.getSelection();
                Map.Entry point = (Map.Entry)ss.getFirstElement();
                if (point != null) {
                    AdvancedIntegerEditor.this.function.getAdditionalPoints().remove(point.getKey());
                    AdvancedIntegerEditor.this.tblPoints.setInput((Object)AdvancedIntegerEditor.this.function.getAdditionalPoints());
                    AdvancedIntegerEditor.this.redrawChart();
                }
            }
        });
        Composite cmpLabel = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).margins(100, 0).applyTo(cmpLabel);
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).align(4, 4).applyTo((Control)cmpLabel);
        Label l1 = new Label(cmpLabel, 2048);
        l1.setText("case < query");
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).align(16384, 128).applyTo((Control)l1);
        Label l2 = new Label(cmpLabel, 2048);
        GridDataFactory.fillDefaults().span(1, 1).align(131072, 128).applyTo((Control)l2);
        l2.setText("case > query");
        this.cmpChart = new ChartComposite(parent, 0);
        this.redrawChart();
        if (this.function.getDesc().isMultiple()) {
            Button btnSetSimilarity = new Button(parent, 8);
            btnSetSimilarity.setText("Configure set similarity");
            btnSetSimilarity.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SetSimilarityWizard wizard = new SetSimilarityWizard(AdvancedIntegerEditor.this.function.getMultipleConfig());
                    WizardDialog wizardDialog = new WizardDialog(shell, (IWizard)wizard){

                        public void updateButtons() {
                            super.updateButtons();
                            this.getButton(1).setEnabled(false);
                        }
                    };
                    wizardDialog.create();
                    wizardDialog.open();
                }
            });
        }
        GridLayoutFactory.fillDefaults().margins(5, 5).spacing(5, 3).numColumns(3).applyTo(parent);
        GridDataFactory.fillDefaults().align(16384, 128).span(2, 1).applyTo((Control)cmpSymmetry);
        GridDataFactory.fillDefaults().align(16384, 128).applyTo((Control)lblPoints);
        GridDataFactory.fillDefaults().align(16384, 128).hint(200, 75).grab(false, false).applyTo((Control)this.tblPoints.getTable());
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).span(3, 1).applyTo((Control)this.cmpChart);
    }

    private void fillModel() {
        if (this.function.isSymmetric()) {
            this.btnSymmetry[0].setSelection(true);
        } else {
            this.btnSymmetry[1].setSelection(true);
        }
        this.tblPoints.setInput((Object)this.function.getAdditionalPoints());
    }

    private void redrawChart() {
        XYDataset dataset = this.function.getDistanceFct() == DistanceConfig.QUOTIENT ? DatasetUtilities.sampleFunction2D((Function2D)new AdvancedIntegerFunction2D(this.function), (double)0.0, (double)(this.max / this.min), (int)100, (Comparable)((Object)"Function")) : DatasetUtilities.sampleFunction2D((Function2D)new AdvancedIntegerFunction2D(this.function), (double)(-this.diff), (double)this.diff, (int)100, (Comparable)((Object)"Function"));
        JFreeChart chart = ChartFactory.createXYLineChart((String)"", (String)"", (String)"", (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        XYPlot plot = chart.getXYPlot();
        NumberAxis axis = (NumberAxis)plot.getRangeAxis();
        axis.setRange(0.0, 1.0);
        plot.setOutlineVisible(false);
        ValueMarker yAxisMarker = this.function.getDistanceFct() == DistanceConfig.QUOTIENT ? new ValueMarker(1.0) : new ValueMarker(0.0);
        yAxisMarker.setPaint((Paint)Color.black);
        yAxisMarker.setStroke((Stroke)new BasicStroke(2.0f, 0, 2));
        chart.getXYPlot().addDomainMarker((Marker)yAxisMarker);
        this.cmpChart.setChart(chart);
        chart.fireChartChanged();
        try {
            if (!this.function.getProject().getName().endsWith("_UNSAFED")) {
                this.function.getProject().setName(String.valueOf(this.function.getProject().getName()) + "_UNSAFED");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void addDirtyOnChangeListeners() {
        this.btnSymmetry[0].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AdvancedIntegerEditor.this.function.setSymmetric(true);
                AdvancedIntegerEditor.this.redrawChart();
            }
        });
        this.btnSymmetry[1].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AdvancedIntegerEditor.this.function.setSymmetric(false);
                AdvancedIntegerEditor.this.redrawChart();
            }
        });
    }

    public void setFocus() {
    }

    class PointContentProvider
    implements IStructuredContentProvider {
        PointContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            TreeMap points = (TreeMap)parent;
            ArrayList elements = new ArrayList();
            for (Map.Entry e : points.entrySet()) {
                elements.add(e);
            }
            return elements.toArray();
        }
    }

    class PointLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        PointLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            Map.Entry point = (Map.Entry)obj;
            String result = "";
            switch (index) {
                case 0: {
                    result = ((Double)point.getKey()).toString();
                    break;
                }
                case 1: {
                    result = String.valueOf(((Similarity)point.getValue()).getValue());
                }
            }
            return result;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }
}

