/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.mycbr.gui.function.editor;

import de.dfki.mycbr.core.casebase.SymbolAttribute;
import de.dfki.mycbr.core.similarity.Similarity;
import de.dfki.mycbr.core.similarity.SymbolFct;
import de.dfki.mycbr.gui.function.editor.SetSimilarityWizard;
import de.dfki.mycbr.gui.function.editor.TableEditorInput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;

public class TableEditor
extends EditorPart {
    public static final String ID = "de.dfki.mycbr.gui.function.editor.TableEditor";
    private SymbolFct function;
    private Button[] btnSymmetry;
    private TableViewer tblTable;
    private org.eclipse.swt.custom.TableEditor[][] editors;

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.function = ((TableEditorInput)input).getFunction();
        this.setPartName(this.function.getName());
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        this.createUi(parent);
        this.fillModel();
        this.addDirtyOnChangeListeners();
    }

    private void createUi(Composite parent) {
        Label lblSymmetry = new Label(parent, 0);
        lblSymmetry.setText("Symmetry");
        this.btnSymmetry = new Button[2];
        this.btnSymmetry[0] = new Button(parent, 16);
        this.btnSymmetry[0].setText("symmetric");
        this.btnSymmetry[1] = new Button(parent, 16);
        this.btnSymmetry[1].setText("asymmetric");
        this.btnSymmetry[0].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableEditor.this.function.setSymmetric(true);
            }
        });
        this.btnSymmetry[1].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableEditor.this.function.setSymmetric(false);
            }
        });
        this.tblTable = new TableViewer(parent, 2820);
        this.tblTable.getTable().setHeaderVisible(false);
        this.tblTable.getTable().addListener(41, new Listener(){

            public void handleEvent(Event event) {
                event.height = 20;
            }
        });
        final Shell shell = parent.getShell();
        if (this.function.getDesc().isMultiple()) {
            Button btnSetSimilarity = new Button(parent, 8);
            btnSetSimilarity.setText("Configure set similarity");
            btnSetSimilarity.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SetSimilarityWizard wizard = new SetSimilarityWizard(TableEditor.this.function.getMultipleConfig());
                    WizardDialog wizardDialog = new WizardDialog(shell, (IWizard)wizard){

                        public void updateButtons() {
                            super.updateButtons();
                            this.getButton(1).setEnabled(false);
                        }
                    };
                    wizardDialog.create();
                    wizardDialog.open();
                }
            });
        }
        GridLayoutFactory.fillDefaults().margins(5, 5).spacing(5, 3).numColumns(3).applyTo(parent);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.horizontalSpan = 3;
        gridData.verticalSpan = 1;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        this.tblTable.getControl().setLayoutData((Object)gridData);
    }

    private void fillModel() {
        this.btnSymmetry[0].setSelection(this.function.isSymmetric());
        this.btnSymmetry[1].setSelection(!this.function.isSymmetric());
        TableViewerColumn emptyColumn = new TableViewerColumn(this.tblTable, 0x1000000);
        emptyColumn.getColumn().setText("  ");
        emptyColumn.getColumn().setWidth(100);
        emptyColumn.getColumn().setResizable(true);
        emptyColumn.getColumn().setMoveable(true);
        for (SymbolAttribute symAttr : this.function.getDesc().getSymbolAttributes()) {
            TableViewerColumn newColumn = new TableViewerColumn(this.tblTable, 0x1000000);
            newColumn.getColumn().setText(symAttr.toString());
            newColumn.getColumn().setWidth(100);
            newColumn.getColumn().setResizable(true);
            newColumn.getColumn().setMoveable(true);
        }
        ArrayList<String> symAttrs = new ArrayList<String>();
        Iterator it = this.function.getDesc().getSymbolAttributes().iterator();
        while (it.hasNext()) {
            symAttrs.add(((SymbolAttribute)it.next()).toString());
        }
        Collections.sort(symAttrs);
        int[] currentIndices = new int[symAttrs.size()];
        int i = 0;
        while (i < symAttrs.size()) {
            currentIndices[i] = i;
            ++i;
        }
        int numberOfColumns = this.function.getDesc().getSymbolAttributes().size();
        this.editors = new org.eclipse.swt.custom.TableEditor[numberOfColumns][numberOfColumns];
        org.eclipse.swt.custom.TableEditor[] headerRowEditors = new org.eclipse.swt.custom.TableEditor[numberOfColumns];
        Button[] headerRowButtons = new Button[numberOfColumns];
        TableItem headerRow = new TableItem(this.tblTable.getTable(), 0);
        int headerRowIndex = 0;
        ArrayList<String> collumName = new ArrayList<String>();
        for (String symAttr : symAttrs) {
            collumName.add(symAttr.toString());
        }
        for (String str : collumName) {
            headerRowEditors[headerRowIndex] = new org.eclipse.swt.custom.TableEditor(this.tblTable.getTable());
            headerRowButtons[headerRowIndex] = new Button((Composite)this.tblTable.getTable(), 8);
            headerRowButtons[headerRowIndex].setText(str);
            headerRowButtons[headerRowIndex].computeSize(-1, this.tblTable.getTable().getItemHeight());
            headerRowButtons[headerRowIndex].setEnabled(false);
            headerRowEditors[headerRowIndex].grabHorizontal = true;
            headerRowEditors[headerRowIndex].minimumHeight = headerRowButtons[headerRowIndex].getSize().y;
            headerRowEditors[headerRowIndex].minimumWidth = headerRowButtons[headerRowIndex].getSize().x;
            headerRowEditors[headerRowIndex].setEditor((Control)headerRowButtons[headerRowIndex], headerRow, headerRowIndex + 1);
            ++headerRowIndex;
        }
        org.eclipse.swt.custom.TableEditor[] headerColumnEditors = new org.eclipse.swt.custom.TableEditor[numberOfColumns];
        Button[] headerColumnButtons = new Button[numberOfColumns];
        int headerColumnIndex = 0;
        int currentRow = 0;
        ArrayList<String> rowName = new ArrayList<String>();
        for (final String symAttr : symAttrs) {
            rowName.add(symAttr.toString());
        }
        for (final String symAttr : symAttrs) {
            TableItem newRow = new TableItem(this.tblTable.getTable(), 0);
            headerColumnEditors[headerColumnIndex] = new org.eclipse.swt.custom.TableEditor(this.tblTable.getTable());
            headerColumnButtons[headerColumnIndex] = new Button((Composite)this.tblTable.getTable(), 8);
            headerColumnButtons[headerColumnIndex].setText(((String)rowName.get(currentRow)).toString());
            headerColumnButtons[headerColumnIndex].computeSize(-1, this.tblTable.getTable().getItemHeight());
            headerColumnButtons[headerColumnIndex].setEnabled(false);
            headerColumnEditors[headerColumnIndex].grabHorizontal = true;
            headerColumnEditors[headerColumnIndex].minimumHeight = headerColumnButtons[headerColumnIndex].getSize().y;
            headerColumnEditors[headerColumnIndex].minimumWidth = headerColumnButtons[headerColumnIndex].getSize().x;
            headerColumnEditors[headerColumnIndex].setEditor((Control)headerColumnButtons[headerColumnIndex], newRow, 0);
            int cellIndex = 1;
            for (final String otherAttr : symAttrs) {
                int colorGreenBlueComponent;
                int colorRedComponent;
                double similarity = 0.0;
                try {
                    similarity = this.function.calculateSimilarity(symAttr, otherAttr).getValue();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                org.eclipse.swt.custom.TableEditor editor = new org.eclipse.swt.custom.TableEditor(this.tblTable.getTable());
                Text txtCell = new Text((Composite)this.tblTable.getTable(), 0x1000000);
                txtCell.setText(String.valueOf(similarity));
                txtCell.computeSize(-1, this.tblTable.getTable().getItemHeight());
                if (headerRow.equals(newRow)) {
                    colorRedComponent = 128;
                    colorGreenBlueComponent = 170;
                    txtCell.setBackground(new Color((Device)Display.getDefault(), colorRedComponent, colorGreenBlueComponent, colorGreenBlueComponent));
                } else {
                    colorRedComponent = 128 + (127 - (int)(127.0 * similarity));
                    colorGreenBlueComponent = 170 + (85 - (int)(85.0 * similarity));
                    txtCell.setBackground(new Color((Device)Display.getDefault(), colorRedComponent, colorGreenBlueComponent, colorGreenBlueComponent));
                }
                final int row = cellIndex - 1;
                final int column = currentRow;
                txtCell.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        Similarity sim;
                        Text text = (Text)e.widget;
                        Double simValue = Double.valueOf(text.getText());
                        if (simValue != null && (sim = Similarity.get((Double)simValue)) != Similarity.INVALID_SIM) {
                            Text symText;
                            TableEditor.this.function.setSimilarity(symAttr, otherAttr.toString(), sim);
                            int colorRedComponent = 128 + (127 - (int)(127.0 * simValue));
                            int colorGreenBlueComponent = 170 + (85 - (int)(85.0 * simValue));
                            text.setBackground(new Color((Device)Display.getDefault(), colorRedComponent, colorGreenBlueComponent, colorGreenBlueComponent));
                            try {
                                if (!TableEditor.this.function.getProject().getName().endsWith("_UNSAFED")) {
                                    TableEditor.this.function.getProject().setName(String.valueOf(TableEditor.this.function.getProject().getName()) + "_UNSAFED");
                                }
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                            if (TableEditor.this.function.isSymmetric() && !(symText = (Text)TableEditor.this.editors[row][column].getEditor()).getText().equals(text.getText())) {
                                symText.setText(text.getText());
                                symText.setBackground(new Color((Device)Display.getDefault(), colorRedComponent, colorGreenBlueComponent, colorGreenBlueComponent));
                                try {
                                    if (!TableEditor.this.function.getProject().getName().endsWith("_UNSAFED")) {
                                        TableEditor.this.function.getProject().setName(String.valueOf(TableEditor.this.function.getProject().getName()) + "_UNSAFED");
                                    }
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                }
                            }
                        }
                    }
                });
                editor.grabHorizontal = true;
                editor.minimumHeight = headerColumnButtons[headerColumnIndex].getSize().y;
                editor.minimumWidth = headerColumnButtons[headerColumnIndex].getSize().x;
                editor.setEditor((Control)txtCell, newRow, cellIndex);
                this.editors[column][row] = editor;
                ++cellIndex;
            }
            ++currentRow;
        }
    }

    private void addDirtyOnChangeListeners() {
    }

    public void setFocus() {
    }
}

