/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.mycbr.gui.function.list;

import de.dfki.mycbr.core.Project;
import de.dfki.mycbr.core.model.AttributeDesc;
import de.dfki.mycbr.core.model.Concept;
import de.dfki.mycbr.core.model.ConceptDesc;
import de.dfki.mycbr.core.model.SimpleAttDesc;
import de.dfki.mycbr.core.similarity.AmalgamationFct;
import de.dfki.mycbr.core.similarity.ISimFct;
import de.dfki.mycbr.gui.function.list.DeleteAction;
import de.dfki.mycbr.gui.plugin.Activator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;

public class FunctionListView
extends ViewPart {
    public static final String ID = "de.dfki.mycbr.gui.function.list.FunctionListView";
    private TableViewer tableViewer;
    private Object currentSource;
    ISelectionListener listener = new ISelectionListener(){

        public void selectionChanged(IWorkbenchPart part, ISelection sel) {
            if (!(sel instanceof IStructuredSelection)) {
                return;
            }
            IStructuredSelection ss = (IStructuredSelection)sel;
            Object o = ss.getFirstElement();
            if (o instanceof Concept) {
                FunctionListView.this.currentSource = o;
                FunctionListView.this.tableViewer.setInput(o);
            } else if (o instanceof ConceptDesc) {
                FunctionListView.this.currentSource = o;
                FunctionListView.this.tableViewer.setInput(o);
            } else if (o instanceof SimpleAttDesc) {
                FunctionListView.this.currentSource = o;
                FunctionListView.this.tableViewer.setInput(o);
            }
        }
    };

    public void createPartControl(Composite parent) {
        this.tableViewer = new TableViewer(parent, 772);
        this.tableViewer.setContentProvider((IContentProvider)new AttributeTableContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new AttributeTableLabelProvider());
        this.getSite().getPage().addSelectionListener(this.listener);
        this.getSite().setSelectionProvider((ISelectionProvider)this.tableViewer);
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection ss = (IStructuredSelection)event.getSelection();
                Object o = ss.getFirstElement();
                if (o instanceof ISimFct || o instanceof AmalgamationFct) {
                    IHandlerService handlerService = (IHandlerService)FunctionListView.this.getSite().getService(IHandlerService.class);
                    try {
                        handlerService.executeCommand("de.dfki.mycbr.gui.function.editor.CallFunctionEditor", null);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        throw new RuntimeException("de.dfki.mycbr.gui.function.editor.CallFunctionEditor not found");
                    }
                }
            }
        });
        MenuManager menuManager = new MenuManager();
        menuManager.add((IContributionItem)new Separator("additions"));
        this.tableViewer.getTable().setMenu(menuManager.createContextMenu((Control)this.tableViewer.getTable()));
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.tableViewer);
        DeleteAction deleteAction = new DeleteAction(this.tableViewer);
        deleteAction.setText("Delete function");
        deleteAction.setImageDescriptor(ImageDescriptor.createFromImage((Image)PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE")));
        this.getViewSite().getActionBars().getToolBarManager().add((IAction)deleteAction);
    }

    public void dispose() {
        this.getSite().getPage().removeSelectionListener(this.listener);
    }

    public void setFocus() {
        this.tableViewer.getControl().setFocus();
    }

    public Object getCurrentSource() {
        return this.currentSource;
    }

    public void clear() {
        this.currentSource = null;
        this.tableViewer.setInput(null);
    }

    public void refresh() {
        this.refresh(true);
    }

    public void refresh(boolean selectLast) {
        this.tableViewer.refresh();
        if (selectLast) {
            this.tableViewer.getTable().select(this.getNumberOfFunctions() - 1);
        }
    }

    private int getNumberOfFunctions() {
        if (this.currentSource instanceof Concept) {
            return ((Concept)this.currentSource).getAvailableAmalgamFcts().size();
        }
        if (this.currentSource instanceof ConceptDesc) {
            return ((ConceptDesc)this.currentSource).getConcept().getAvailableAmalgamFcts().size();
        }
        if (this.currentSource instanceof SimpleAttDesc) {
            return ((SimpleAttDesc)this.currentSource).getSimFcts().size();
        }
        return 0;
    }

    public Project getProject() {
        if (this.currentSource instanceof Concept) {
            return ((Concept)this.currentSource).getProject();
        }
        if (this.currentSource instanceof AttributeDesc) {
            return ((AttributeDesc)this.currentSource).getOwner().getProject();
        }
        return null;
    }

    class AttributeTableContentProvider
    implements IStructuredContentProvider {
        AttributeTableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof SimpleAttDesc) {
                SimpleAttDesc attribute = (SimpleAttDesc)inputElement;
                return attribute.getSimFcts().toArray();
            }
            if (inputElement instanceof ConceptDesc) {
                ConceptDesc conceptDesc = (ConceptDesc)inputElement;
                return conceptDesc.getConcept().getAvailableAmalgamFcts().toArray();
            }
            if (inputElement instanceof Project) {
                Project project = (Project)inputElement;
                return new Object[]{project.getSpecialFct()};
            }
            if (inputElement instanceof Concept) {
                Concept concept = (Concept)inputElement;
                return concept.getAvailableAmalgamFcts().toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }
    }

    class AttributeTableLabelProvider
    extends LabelProvider {
        AttributeTableLabelProvider() {
        }

        public String getText(Object obj) {
            String columnText = null;
            if (obj instanceof ISimFct) {
                ISimFct function = (ISimFct)obj;
                columnText = function.getName();
            } else if (obj instanceof AmalgamationFct) {
                AmalgamationFct function = (AmalgamationFct)obj;
                columnText = function.getName();
            }
            return columnText;
        }

        public Image getColumnImage(Object obj, int index) {
            return this.getImage(obj);
        }

        public Image getImage(Object obj) {
            if (obj instanceof AmalgamationFct) {
                Concept concept = null;
                if (FunctionListView.this.currentSource instanceof Concept) {
                    concept = (Concept)FunctionListView.this.currentSource;
                } else if (FunctionListView.this.currentSource instanceof ConceptDesc) {
                    concept = ((ConceptDesc)FunctionListView.this.currentSource).getConcept();
                }
                if (((AmalgamationFct)obj).equals(concept.getActiveAmalgamFct())) {
                    return Activator.getDefault().getImageRegistry().get("functionIcon");
                }
                return Activator.getDefault().getImageRegistry().get("functionInactiveIcon");
            }
            return Activator.getDefault().getImageRegistry().get("functionIcon");
        }
    }
}

