/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.mycbr.gui.function.list;

import de.dfki.mycbr.core.model.Concept;
import de.dfki.mycbr.core.model.SimpleAttDesc;
import de.dfki.mycbr.core.similarity.config.AmalgamationConfig;
import de.dfki.mycbr.gui.function.list.FunctionListView;
import de.dfki.mycbr.gui.function.wizard.FunctionWizard;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;

public class NewFunctionAction
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        FunctionListView view = (FunctionListView)page.findView("de.dfki.mycbr.gui.function.list.FunctionListView");
        Object obj = view.getCurrentSource();
        if (obj instanceof SimpleAttDesc) {
            SimpleAttDesc attrDesc = (SimpleAttDesc)obj;
            FunctionWizard wizard = new FunctionWizard(attrDesc);
            WizardDialog wizardDialog = new WizardDialog(window.getShell(), (IWizard)wizard);
            wizardDialog.create();
            wizardDialog.open();
        } else if (obj instanceof Concept) {
            Concept concept = (Concept)obj;
            IInputValidator validator = new IInputValidator(){

                public String isValid(String newText) {
                    if (newText.isEmpty()) {
                        return "You must enter a function name";
                    }
                    return null;
                }
            };
            InputDialog inputDialog = new InputDialog(window.getShell(), "Enter a function name", "Enter a function name", "", validator);
            inputDialog.open();
            String functionName = inputDialog.getValue();
            if (functionName != null && !functionName.isEmpty()) {
                concept.addAmalgamationFct(AmalgamationConfig.WEIGHTED_SUM, functionName, false);
            }
        }
        IHandlerService handlerService = (IHandlerService)view.getSite().getService(IHandlerService.class);
        try {
            handlerService.executeCommand("de.dfki.mycbr.gui.function.list.FunctionListRefreshHandler", null);
        }
        catch (Exception exception) {
            throw new RuntimeException("de.dfki.mycbr.gui.function.list.FunctionListRefreshHandler not found");
        }
        return null;
    }
}

