/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.mycbr.gui.attribute.editor;

import de.dfki.mycbr.core.casebase.SimpleAttribute;
import de.dfki.mycbr.core.casebase.SymbolAttribute;
import de.dfki.mycbr.core.explanation.ConceptExplanation;
import de.dfki.mycbr.core.explanation.ExplanationManager;
import de.dfki.mycbr.core.model.SymbolDesc;
import de.dfki.mycbr.gui.attribute.editor.AttributeFormEditor;
import de.dfki.mycbr.gui.misc.ListUtil;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;

public class SymbolExplanationPage
extends FormPage {
    public static final String ID = "de.dfki.mycbr.gui.attribute.editor.SymbolExplanationPage";
    private SymbolDesc symbolDesc;
    private ExplanationManager explMan;
    private ConceptExplanation explanation;
    private String selectedValue;
    private Text txtDescription;
    private TableViewer tblLinks;

    public SymbolExplanationPage(FormEditor editor) {
        super(editor, ID, "Symbol Explanation");
        this.symbolDesc = (SymbolDesc)((AttributeFormEditor)editor).getAttribute();
        this.explMan = this.symbolDesc.getOwner().getProject().getExplanationManager();
    }

    protected void createFormContent(IManagedForm managedForm) {
        managedForm.getForm().setText("Symbol Explanation");
        this.createUi(managedForm.getForm().getBody());
        this.fillModel();
        this.addUpdateOnChangeListeners();
    }

    private void createUi(Composite parent) {
        GridLayoutFactory.fillDefaults().margins(5, 5).spacing(5, 3).numColumns(3).applyTo(parent);
        Label lblSymbol = new Label(parent, 128);
        lblSymbol.setText("Symbol attribute");
        ComboViewer cvSymbols = new ComboViewer(parent, 8);
        cvSymbols.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        cvSymbols.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        cvSymbols.setInput(ListUtil.sortSymbolAttributes(this.symbolDesc.getAllowedValues()));
        cvSymbols.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection ss = (IStructuredSelection)event.getSelection();
                String selectedSymbolName = (String)ss.getFirstElement();
                SymbolAttribute symbolAttr = (SymbolAttribute)SymbolExplanationPage.this.symbolDesc.getAttribute(selectedSymbolName);
                SymbolExplanationPage.this.explanation = SymbolExplanationPage.this.explMan.getExplanation((SimpleAttribute)symbolAttr);
                SymbolExplanationPage.this.fillModel();
            }
        });
        Label lblDescription = new Label(parent, 128);
        lblDescription.setText("Short description");
        this.txtDescription = new Text(parent, 2626);
        GridDataFactory.fillDefaults().align(4, 128).applyTo((Control)lblDescription);
        GridDataFactory.fillDefaults().align(4, 128).hint(-1, 200).grab(true, false).span(2, 1).applyTo((Control)this.txtDescription);
        Label lblLinks = new Label(parent, 0);
        lblLinks.setText("Links");
        this.tblLinks = new TableViewer(parent, 68356);
        this.tblLinks.getTable().setLinesVisible(true);
        this.tblLinks.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        Composite cmpButtonGroup = new Composite(parent, 0);
        FillLayout cmpButtonGroupLayout = new FillLayout(512);
        cmpButtonGroup.setLayout((Layout)cmpButtonGroupLayout);
        cmpButtonGroup.setBackground(Display.getDefault().getSystemColor(1));
        Button btnAdd = new Button(cmpButtonGroup, 8);
        btnAdd.setText("Add");
        Button btnRemove = new Button(cmpButtonGroup, 8);
        btnRemove.setText("Remove");
        this.tblLinks.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection ss = (IStructuredSelection)event.getSelection();
                SymbolExplanationPage.this.selectedValue = (String)ss.getFirstElement();
            }
        });
        final Shell shell = parent.getShell();
        btnAdd.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                String newValue;
                IInputValidator validator = new IInputValidator(){

                    public String isValid(String newText) {
                        if (newText.isEmpty()) {
                            return "You must enter a link";
                        }
                        return null;
                    }
                };
                do {
                    InputDialog inputDialog = new InputDialog(shell, "Add link", "Please a valid link", "", validator);
                    inputDialog.open();
                    newValue = inputDialog.getValue();
                    if (newValue == null || newValue.isEmpty()) continue;
                    SymbolExplanationPage.this.explanation.addLink(newValue);
                    SymbolExplanationPage.this.tblLinks.setInput((Object)SymbolExplanationPage.this.explanation.getLinks());
                } while (newValue != null && !newValue.isEmpty());
            }
        });
        btnRemove.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                if (SymbolExplanationPage.this.selectedValue != null) {
                    SymbolExplanationPage.this.explanation.removeLink(SymbolExplanationPage.this.selectedValue);
                    SymbolExplanationPage.this.tblLinks.setInput((Object)SymbolExplanationPage.this.explanation.getLinks());
                }
            }
        });
        cvSymbols.setSelection((ISelection)new StructuredSelection(this.symbolDesc.getAllowedValues().toArray()[0]));
        GridDataFactory.fillDefaults().align(4, 128).applyTo((Control)lblLinks);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).span(2, 1).applyTo((Control)cvSymbols.getCombo());
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).hint(300, 200).applyTo((Control)this.tblLinks.getTable());
        GridDataFactory.fillDefaults().align(4, 128).grab(false, false).applyTo((Control)cmpButtonGroup);
    }

    private void fillModel() {
        this.txtDescription.setText(this.explanation.getDescription());
        this.tblLinks.setInput((Object)this.explanation.getLinks());
    }

    private void addUpdateOnChangeListeners() {
        this.txtDescription.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SymbolExplanationPage.this.explanation.setDescription(SymbolExplanationPage.this.txtDescription.getText());
            }
        });
    }

    public boolean isDirty() {
        return false;
    }

    public void setFocus() {
        this.txtDescription.setFocus();
    }
}

