/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.mycbr.gui.casebase.editor;

import de.dfki.mycbr.core.DefaultCaseBase;
import de.dfki.mycbr.core.ICaseBase;
import de.dfki.mycbr.core.casebase.Attribute;
import de.dfki.mycbr.core.casebase.Instance;
import de.dfki.mycbr.core.model.AttributeDesc;
import de.dfki.mycbr.core.model.Concept;
import de.dfki.mycbr.core.retrieval.Retrieval;
import de.dfki.mycbr.core.retrieval.SequentialRetrieval;
import de.dfki.mycbr.core.similarity.Similarity;
import de.dfki.mycbr.gui.casebase.editor.CasebaseEditorInput;
import de.dfki.mycbr.gui.instance.list.InstanceEditorInput;
import de.dfki.mycbr.gui.misc.ListUtil;
import de.dfki.mycbr.util.Pair;
import java.text.Collator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.part.EditorPart;

public class CasebaseEditor
extends EditorPart
implements Observer {
    public static final String ID = "de.dfki.mycbr.gui.casebase.editor.CasebaseEditor";
    private ICaseBase cb;
    private FormToolkit toolkit;
    private ScrolledForm form;
    private TableItem item;
    private List<Case> cases;
    private Table caseInfo;
    private TableColumn[] column;
    private Concept concept;
    private Instance q;
    private List<Pair<Instance, Similarity>> results;
    private SequentialRetrieval sr;
    private int wholeColumns;
    private int numberOfAttr;
    private Label numberOfAttrLabel;
    private Label numberOfCasesLabel;
    private Label attrLabel;
    private int min;
    private int max;
    private List<String> valueList = new ArrayList<String>();
    private Set<String> unique = new HashSet<String>(this.valueList);
    private int setCount;
    private int numberOfCases;
    private ArrayList<String> concepts;
    private Text txtName;
    private Combo conceptCombo;
    private Section sctStatistics;
    private Composite cmpStatistics;
    private int check;
    org.eclipse.swt.widgets.List list;

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.cb = ((CasebaseEditorInput)input).getCB();
        this.setPartName(this.cb.getName());
        HashMap conceptMap = this.cb.getProject().getAllSubConcepts();
        this.concepts = new ArrayList();
        Iterator it = conceptMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry pairs = it.next();
            this.concepts.add(pairs.getKey().toString());
            it.remove();
        }
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.form = this.toolkit.createScrolledForm(parent);
        this.createUi();
    }

    private void createUi() {
        GridLayoutFactory.fillDefaults().margins(5, 5).spacing(5, 3).numColumns(3).applyTo(this.form.getBody());
        Section sctCase = this.toolkit.createSection(this.form.getBody(), 384);
        sctCase.setText("Case Base information");
        GridDataFactory.fillDefaults().span(3, 1).applyTo((Control)sctCase);
        Composite cmpLabelGroup = this.toolkit.createComposite(this.form.getBody());
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(cmpLabelGroup);
        GridDataFactory.fillDefaults().align(4, 1).grab(false, false).applyTo((Control)cmpLabelGroup);
        Label lname = this.toolkit.createLabel(cmpLabelGroup, "Name:");
        GridDataFactory.fillDefaults().align(1, 1).applyTo((Control)lname);
        this.txtName = new Text(cmpLabelGroup, 2048);
        this.txtName.setText(this.cb.getName());
        this.txtName.setEditable(true);
        Label lconcept = this.toolkit.createLabel(cmpLabelGroup, "Concept:");
        GridDataFactory.fillDefaults().align(1, 1).applyTo((Control)lconcept);
        this.conceptCombo = new Combo(cmpLabelGroup, 2052);
        this.conceptCombo.setItems(this.concepts.toArray(new String[this.concepts.size()]));
        this.conceptCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String selectedConcept = CasebaseEditor.this.conceptCombo.getText();
                CasebaseEditor.this.concept = CasebaseEditor.this.cb.getProject().getConceptByID(selectedConcept);
                Retrieval r = new Retrieval(CasebaseEditor.this.concept, CasebaseEditor.this.cb);
                CasebaseEditor.this.q = r.getQueryInstance();
                CasebaseEditor.this.sr = new SequentialRetrieval(CasebaseEditor.this.concept.getProject(), r);
                CasebaseEditor.this.results = new ArrayList();
                CasebaseEditor.this.numberOfAttr = CasebaseEditor.this.concept.getAllAttributeDescs().values().size();
                if (CasebaseEditor.this.check == 1) {
                    CasebaseEditor.this.sctStatistics.dispose();
                    CasebaseEditor.this.cmpStatistics.dispose();
                }
                CasebaseEditor.this.showStatistics();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                System.out.println(CasebaseEditor.this.conceptCombo.getText());
            }
        });
        this.txtName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text t = (Text)e.widget;
                if (!t.getText().isEmpty()) {
                    try {
                        CasebaseEditor.this.cb.setName(t.getText());
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
                try {
                    if (!CasebaseEditor.this.cb.getProject().getName().endsWith("_UNSAFED")) {
                        CasebaseEditor.this.cb.getProject().setName(String.valueOf(CasebaseEditor.this.cb.getProject().getName()) + "_UNSAFED");
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        Section sctAttribute = this.toolkit.createSection(this.form.getBody(), 384);
        sctAttribute.setText("Cases");
        GridDataFactory.fillDefaults().span(3, 1).applyTo((Control)sctAttribute);
        Button button = new Button(this.form.getBody(), 8);
        button.setText("Refresh");
        GridDataFactory.fillDefaults().align(1, 1).span(4, 1).applyTo((Control)button);
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                CasebaseEditor.this.list.removeAll();
                for (Instance i : ListUtil.sortInstances(CasebaseEditor.this.cb.getCases())) {
                    CasebaseEditor.this.list.add(i.getName());
                }
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                CasebaseEditor.this.list.removeAll();
                for (Instance i : ListUtil.sortInstances(CasebaseEditor.this.cb.getCases())) {
                    CasebaseEditor.this.list.add(i.getName());
                }
            }
        });
        Composite cmpEditGroup = this.toolkit.createComposite(this.form.getBody());
        RowLayout layout = new RowLayout(256);
        layout.wrap = true;
        layout.fill = false;
        layout.justify = true;
        cmpEditGroup.setLayout((Layout)layout);
        RowData data = new RowData();
        data.height = 400;
        data.width = 300;
        this.list = new org.eclipse.swt.widgets.List(cmpEditGroup, 2818);
        for (Instance i : ListUtil.sortInstances(this.cb.getCases())) {
            this.list.add(i.getName());
        }
        this.list.setLayoutData((Object)data);
        this.caseInfo = new Table(cmpEditGroup, 0x10000800);
        this.caseInfo.setLayoutData((Object)data);
        this.caseInfo.setHeaderVisible(true);
        this.caseInfo.setLinesVisible(true);
        this.column = new TableColumn[2];
        this.column[0] = new TableColumn(this.caseInfo, 0);
        this.column[0].setText("Name");
        this.column[1] = new TableColumn(this.caseInfo, 0);
        this.column[1].setText("Value");
        Listener sortListener = new Listener(){

            public void handleEvent(Event e) {
                TableItem[] items = CasebaseEditor.this.caseInfo.getItems();
                Collator collator = Collator.getInstance(Locale.getDefault());
                TableColumn sortColumn = (TableColumn)e.widget;
                int index = sortColumn == CasebaseEditor.this.column[0] ? 0 : 1;
                int i = 1;
                while (i < items.length) {
                    String value1 = items[i].getText(index);
                    int j = 0;
                    while (j < i) {
                        String value2 = items[j].getText(index);
                        if (collator.compare(value1, value2) < 0) {
                            String[] values = new String[]{items[i].getText(0), items[i].getText(1)};
                            items[i].dispose();
                            TableItem item = new TableItem(CasebaseEditor.this.caseInfo, 0, j);
                            item.setText(values);
                            items = CasebaseEditor.this.caseInfo.getItems();
                            break;
                        }
                        ++j;
                    }
                    ++i;
                }
                CasebaseEditor.this.caseInfo.setSortColumn(sortColumn);
            }
        };
        this.column[0].addListener(13, sortListener);
        this.column[1].addListener(13, sortListener);
        this.caseInfo.setSortDirection(128);
        this.list.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                String[] instances;
                String[] stringArray = instances = ((org.eclipse.swt.widgets.List)e.getSource()).getSelection();
                if (instances.length != 0) {
                    String inst = stringArray[0];
                    Instance i = CasebaseEditor.this.cb.containsCase(inst);
                    if (i != null) {
                        CasebaseEditor.this.caseInfo.removeAll();
                        for (Map.Entry entry : i.getAttributes().entrySet()) {
                            CasebaseEditor.this.cases = new ArrayList();
                            CasebaseEditor.this.cases.add(new Case(((AttributeDesc)entry.getKey()).getName(), ((Attribute)entry.getValue()).getValueAsString()));
                            CasebaseEditor.this.fillTable(CasebaseEditor.this.caseInfo);
                        }
                    }
                    return;
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
                String[] instances;
                String[] stringArray = instances = ((org.eclipse.swt.widgets.List)e.getSource()).getSelection();
                int n = instances.length;
                int n2 = 0;
                while (n2 < n) {
                    String inst = stringArray[n2];
                    Instance i = CasebaseEditor.this.cb.containsCase(inst);
                    if (i != null) {
                        IWorkbenchPage page = CasebaseEditor.this.getSite().getPage();
                        try {
                            page.openEditor((IEditorInput)new InstanceEditorInput(i), "de.dfki.mycbr.gui.instance.list.InstanceFormEditor");
                        }
                        catch (PartInitException e1) {
                            e1.printStackTrace();
                        }
                    }
                    ++n2;
                }
            }
        });
        this.list.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                String[] instances;
                String[] stringArray = instances = ((org.eclipse.swt.widgets.List)e.getSource()).getSelection();
                if (instances.length != 0) {
                    String inst = stringArray[0];
                    Instance i = CasebaseEditor.this.cb.containsCase(inst);
                    if (i != null) {
                        CasebaseEditor.this.caseInfo.removeAll();
                        for (Map.Entry entry : i.getAttributes().entrySet()) {
                            CasebaseEditor.this.cases = new ArrayList();
                            CasebaseEditor.this.cases.add(new Case(((AttributeDesc)entry.getKey()).getName(), ((Attribute)entry.getValue()).getValueAsString()));
                            CasebaseEditor.this.fillTable(CasebaseEditor.this.caseInfo);
                        }
                    }
                    return;
                }
            }
        });
        DropTarget target = new DropTarget((Control)this.list, 2);
        Transfer[] transfers = new Transfer[]{TextTransfer.getInstance()};
        target.setTransfer(transfers);
        target.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void drop(DropTargetEvent event) {
                String[] names;
                if (event.data == null) {
                    return;
                }
                String[] stringArray = names = ((String)event.data).split(";");
                int n = names.length;
                int n2 = 0;
                while (n2 < n) {
                    String name = stringArray[n2];
                    if (CasebaseEditor.this.cb.containsCase(name) == null) {
                        CasebaseEditor.this.cb.addCase(CasebaseEditor.this.cb.getProject().getInstance(name));
                        CasebaseEditor.this.list.add(name);
                    }
                    ++n2;
                }
            }
        });
    }

    private void showStatistics() {
        this.sctStatistics = this.toolkit.createSection(this.form.getBody(), 384);
        this.sctStatistics.setText("Statistics");
        GridDataFactory.fillDefaults().span(5, 1).align(4, 1).grab(true, false).applyTo((Control)this.sctStatistics);
        this.cmpStatistics = this.toolkit.createComposite(this.form.getBody());
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(this.cmpStatistics);
        GridDataFactory.fillDefaults().align(4, 1).grab(false, false).applyTo((Control)this.cmpStatistics);
        this.numberOfCasesLabel = this.toolkit.createLabel(this.cmpStatistics, "");
        GridDataFactory.fillDefaults().align(1, 1).span(1, 1).applyTo((Control)this.numberOfCasesLabel);
        this.numberOfAttrLabel = this.toolkit.createLabel(this.cmpStatistics, "Number of attributes: " + this.numberOfAttr);
        GridDataFactory.fillDefaults().align(1, 1).span(2, 1).applyTo((Control)this.numberOfAttrLabel);
        Label space = this.toolkit.createLabel(this.cmpStatistics, "");
        space.setText("");
        GridDataFactory.fillDefaults().align(1, 1).span(3, 1).applyTo((Control)space);
        List<AttributeDesc> sortedAttrDesc = ListUtil.sortAttributeDescs(this.concept.getAllAttributeDescs().values());
        try {
            this.results = this.sr.retrieveSorted((ICaseBase)((DefaultCaseBase)this.cb), this.q);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int i = 1;
        while (i <= this.numberOfAttr) {
            this.attrLabel = this.toolkit.createLabel(this.cmpStatistics, "");
            this.wholeColumns = this.cb.getCases().size();
            this.valueList.clear();
            this.unique.clear();
            int c = 1;
            while (c <= this.wholeColumns) {
                Pair<Instance, Similarity> result = this.results.get(c - 1);
                this.valueList.add(((Instance)result.getFirst()).getAttForDesc(sortedAttrDesc.get(i - 1)).getValueAsString());
                this.numberOfCases = this.valueList.size();
                this.numberOfCasesLabel.setText("Number of cases: " + this.numberOfCases);
                this.unique.add(((Instance)result.getFirst()).getAttForDesc(sortedAttrDesc.get(i - 1)).getValueAsString());
                this.setCount = this.unique.size();
                this.attrLabel.setText(String.valueOf(sortedAttrDesc.get(i - 1).getName()) + ": " + "different values = " + this.setCount);
                GridDataFactory.fillDefaults().align(1, 1).span(1, 1).applyTo((Control)this.attrLabel);
                try {
                    if (c == 1) {
                        this.min = Integer.parseInt(((Instance)result.getFirst()).getAttForDesc(sortedAttrDesc.get(i - 1)).getValueAsString());
                        this.max = Integer.parseInt(((Instance)result.getFirst()).getAttForDesc(sortedAttrDesc.get(i - 1)).getValueAsString());
                    }
                    if (Integer.parseInt(((Instance)result.getFirst()).getAttForDesc(sortedAttrDesc.get(i - 1)).getValueAsString()) < this.min) {
                        this.min = Integer.parseInt(((Instance)result.getFirst()).getAttForDesc(sortedAttrDesc.get(i - 1)).getValueAsString());
                    }
                    if (Integer.parseInt(((Instance)result.getFirst()).getAttForDesc(sortedAttrDesc.get(i - 1)).getValueAsString()) > this.max) {
                        this.max = Integer.parseInt(((Instance)result.getFirst()).getAttForDesc(sortedAttrDesc.get(i - 1)).getValueAsString());
                    }
                    this.attrLabel.setText(String.valueOf(sortedAttrDesc.get(i - 1).getName()) + ": " + "min = " + this.min + " | max = " + this.max);
                    GridDataFactory.fillDefaults().align(1, 1).span(1, 1).applyTo((Control)this.attrLabel);
                }
                catch (NumberFormatException numberFormatException) {}
                ++c;
            }
            ++i;
        }
        this.form.reflow(true);
        this.check = 1;
    }

    protected void fillTable(Table table) {
        this.caseInfo.setRedraw(false);
        for (Case newCase : this.cases) {
            this.item = new TableItem(table, 0);
            int c = 0;
            this.item.setText(c++, newCase.getName());
            this.item.setText(c++, newCase.getValue());
            int j = 0;
            int n = this.column.length;
            while (j < n) {
                this.column[j].pack();
                ++j;
            }
        }
        this.caseInfo.setRedraw(true);
    }

    public void setFocus() {
    }

    @Override
    public void update(Observable o, Object arg) {
    }

    class Case {
        private String name;
        private String value;

        public Case(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }
}

