/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.mycbr.gui.commands;

import de.dfki.mycbr.core.Project;
import de.dfki.mycbr.gui.misc.MyCbrInterface;
import de.dfki.mycbr.gui.project.list.ProjectListView;
import java.io.File;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.handlers.IHandlerService;

public class SaveAsHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        Project project = null;
        if (MyCbrInterface.getInstance().getProjects().size() == 1) {
            project = MyCbrInterface.getInstance().getProjects().get(0);
        } else if (MyCbrInterface.getInstance().getProjects().size() > 1) {
            Object obj;
            IWorkbenchPage page = window.getActivePage();
            ProjectListView view = (ProjectListView)page.findView("de.dfki.mycbr.gui.project.list.ProjectListView");
            ISelection selection = view.getSite().getSelectionProvider().getSelection();
            if (selection != null && selection instanceof IStructuredSelection && (obj = ((IStructuredSelection)selection).getFirstElement()) != null && obj instanceof Project) {
                project = (Project)obj;
            }
            if (project == null) {
                ListDialog ld = new ListDialog(window.getShell());
                ld.setAddCancelButton(true);
                ld.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
                ld.setLabelProvider((ILabelProvider)new LabelProvider(){

                    public String getText(Object obj) {
                        return ((Project)obj).getName();
                    }
                });
                ld.setInput((Object)MyCbrInterface.getInstance().getProjects().toArray());
                ld.setTitle("Select the project to save:");
                ld.open();
                if (ld.getResult() != null) {
                    project = (Project)ld.getResult()[0];
                }
            }
        }
        if (project != null) {
            try {
                if (project.getName().endsWith("_UNSAFED")) {
                    project.setName(project.getName().substring(0, project.getName().length() - 8));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            FileDialog fileDialog = new FileDialog(window.getShell(), 8192);
            String[] filterExt = new String[]{"*.prj", "*.zip", "*.*"};
            fileDialog.setFilterExtensions(filterExt);
            String projectPath = fileDialog.open();
            if (projectPath != null) {
                if (projectPath.endsWith(".zip") || projectPath.endsWith(".prj")) {
                    projectPath = projectPath.substring(0, projectPath.lastIndexOf(46));
                }
                File file = new File(projectPath);
                try {
                    project.setName(file.getName());
                    project.setPath(String.valueOf(file.getParent()) + "/");
                    project.save();
                    IHandlerService handlerService = (IHandlerService)window.getService(IHandlerService.class);
                    try {
                        handlerService.executeCommand("de.dfki.mycbr.gui.project.list.ProjectListRefreshHandler", null);
                    }
                    catch (Exception exception) {
                        throw new RuntimeException("de.dfki.mycbr.gui.project.list.ProjectListRefreshHandler not found");
                    }
                }
                catch (Exception exception) {}
            }
        }
        return null;
    }
}

