/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.mycbr.gui.concept.editor;

import de.dfki.mycbr.core.model.AttributeDesc;
import de.dfki.mycbr.core.model.Concept;
import de.dfki.mycbr.gui.concept.editor.ConceptFormEditor;
import de.dfki.mycbr.gui.ie.InformationExtractionInterface;
import de.dfki.mycbr.gui.misc.ListUtil;
import de.dfki.mycbr.ie.InformationExtractionConfig;
import de.dfki.mycbr.ie.InformationExtractionEngine;
import de.dfki.mycbr.ie.InformationExtractionFile;
import de.dfki.mycbr.ie.scoobie.ScoobieEngine;
import java.util.Set;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;

public class InformationExtractionPage
extends FormPage {
    public static final String ID = "de.dfki.mycbr.gui.concept.editor.InformationExtractionPage";
    private Concept concept;
    private InformationExtractionConfig config;
    private InformationExtractionFile file;
    ComboViewer[] combo;
    Label[] lblPreview;
    InformationExtractionEngine importer;

    public InformationExtractionPage(FormEditor editor) {
        super(editor, ID, "Information Extraction");
        this.concept = ((ConceptFormEditor)editor).getConcept();
        this.config = InformationExtractionInterface.getInstance().getConfig(this.concept);
        this.file = InformationExtractionInterface.getInstance().getFile(this.concept);
        try {
            this.importer = new ScoobieEngine("http://localhost:8080/scoobie2-delight-server-0.2-SNAPSHOT/RPC2");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void createFormContent(IManagedForm managedForm) {
        managedForm.getForm().setText("Information Extraction");
        this.createUi(managedForm.getForm().getBody());
    }

    private void createUi(Composite parent) {
        GridLayoutFactory.fillDefaults().margins(5, 5).spacing(5, 3).numColumns(4).applyTo(parent);
        Label lblFilename = new Label(parent, 0);
        lblFilename.setText("Filename");
        Text txtFilename = new Text(parent, 8);
        txtFilename.setText(this.file.getFilename());
        GridDataFactory.fillDefaults().span(3, 1).applyTo((Control)txtFilename);
        Label lblNumOfCases = new Label(parent, 0);
        lblNumOfCases.setText("Number of cases");
        final Text txtNumOfCases = new Text(parent, 8);
        txtNumOfCases.setText(String.valueOf(this.file.countNodes(this.config.getPrefix())));
        GridDataFactory.fillDefaults().span(3, 1).applyTo((Control)txtNumOfCases);
        Label lblPrefix = new Label(parent, 0);
        lblPrefix.setText("Prefix");
        ComboViewer cbvPrefix = new ComboViewer(parent, 8);
        cbvPrefix.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        cbvPrefix.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        cbvPrefix.setInput((Object)this.file.getAllPathSet());
        cbvPrefix.setSelection((ISelection)new StructuredSelection((Object)this.config.getPrefix()));
        cbvPrefix.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection ss = (IStructuredSelection)event.getSelection();
                String newValue = (String)ss.getFirstElement();
                InformationExtractionPage.this.config.setPrefix(newValue);
                int i = 0;
                while (i < InformationExtractionPage.this.combo.length) {
                    InformationExtractionPage.this.combo[i].refresh();
                    ++i;
                }
                txtNumOfCases.setText(String.valueOf(InformationExtractionPage.this.file.countNodes(InformationExtractionPage.this.config.getPrefix())));
            }
        });
        GridDataFactory.fillDefaults().grab(false, false).span(3, 1).applyTo((Control)cbvPrefix.getCombo());
        this.combo = new ComboViewer[this.concept.getAllAttributeDescs().values().size()];
        this.lblPreview = new Label[this.concept.getAllAttributeDescs().values().size()];
        int i = 0;
        Set xPathes = this.file.getXpathSet();
        for (final AttributeDesc attrDesc : ListUtil.sortAttributeDescs(this.concept.getAllAttributeDescs().values())) {
            Label lbl = new Label(parent, 0);
            lbl.setText(attrDesc.getName());
            this.combo[i] = new ComboViewer(parent, 8);
            this.combo[i].setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            this.combo[i].setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    String s = (String)element;
                    if (InformationExtractionPage.this.config.getPrefix() != null && !InformationExtractionPage.this.config.getPrefix().isEmpty()) {
                        return s.replaceAll(String.valueOf(InformationExtractionPage.this.config.getPrefix()) + "/", "");
                    }
                    return s;
                }
            });
            this.combo[i].setInput((Object)xPathes.toArray());
            this.combo[i].setSelection((ISelection)new StructuredSelection((Object)this.config.getXpath(attrDesc)));
            this.combo[i].addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection ss = (IStructuredSelection)event.getSelection();
                    String newValue = (String)ss.getFirstElement();
                    InformationExtractionPage.this.config.update(attrDesc, newValue);
                }
            });
            final Button btnCopyOnly = new Button(parent, 32);
            btnCopyOnly.setText("copy only");
            btnCopyOnly.setSelection(this.config.isCopyOnly(attrDesc));
            btnCopyOnly.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    InformationExtractionPage.this.config.update(attrDesc, Boolean.valueOf(btnCopyOnly.getSelection()));
                }
            });
            this.lblPreview[i] = new Label(parent, 0);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.lblPreview[i]);
            ++i;
        }
        Button btnStartExtraction = new Button(parent, 8);
        btnStartExtraction.setText("Start extraction");
        btnStartExtraction.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                InformationExtractionPage.this.importer.doImport(InformationExtractionPage.this.config, InformationExtractionPage.this.file);
            }
        });
    }

    public boolean isDirty() {
        return false;
    }

    public void setFocus() {
    }
}

