/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.mycbr.gui.concept.editor;

import de.dfki.mycbr.core.casebase.Instance;
import de.dfki.mycbr.core.model.Concept;
import de.dfki.mycbr.gui.concept.editor.ConceptFormEditor;
import de.dfki.mycbr.gui.instance.list.InstanceEditorInput;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class InstancePage
extends FormPage {
    public static final String ID = "de.dfki.mycbr.gui.concept.editor.InstancePage";
    private FormToolkit toolkit;
    private ScrolledForm form;
    private Concept c;
    private Instance selectedValue;
    private TableViewer tblLinks;

    public InstancePage(FormEditor editor) {
        super(editor, ID, "Instances");
        this.c = ((ConceptFormEditor)editor).getConcept();
    }

    protected void createFormContent(IManagedForm managedForm) {
        this.toolkit = managedForm.getToolkit();
        this.form = managedForm.getForm();
        this.form.setText("Instances");
        this.createUi();
        this.fillModel();
    }

    private void createUi() {
        GridLayoutFactory.fillDefaults().margins(5, 5).spacing(5, 3).numColumns(3).applyTo(this.form.getBody());
        Label lblLinks = this.toolkit.createLabel(this.form.getBody(), "Instances:");
        this.tblLinks = new TableViewer(this.form.getBody(), 68356);
        this.tblLinks.getTable().setLinesVisible(true);
        this.tblLinks.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        GridDataFactory.fillDefaults().align(4, 128).applyTo((Control)lblLinks);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).hint(300, 200).applyTo((Control)this.tblLinks.getTable());
        Composite cmpButtonGroup = this.toolkit.createComposite(this.form.getBody());
        FillLayout cmpButtonGroupLayout = new FillLayout(512);
        cmpButtonGroup.setLayout((Layout)cmpButtonGroupLayout);
        GridDataFactory.fillDefaults().align(4, 128).grab(false, false).applyTo((Control)cmpButtonGroup);
        Button btnAdd = new Button(cmpButtonGroup, 8);
        btnAdd.setText("Add");
        Button btnRemove = new Button(cmpButtonGroup, 8);
        btnRemove.setText("Remove");
        this.tblLinks.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection ss = (IStructuredSelection)event.getSelection();
                InstancePage.this.selectedValue = (Instance)ss.getFirstElement();
            }
        });
        this.tblLinks.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection ss = (IStructuredSelection)event.getSelection();
                InstancePage.this.selectedValue = (Instance)ss.getFirstElement();
                InstanceEditorInput input = new InstanceEditorInput(InstancePage.this.selectedValue);
                try {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)input, "de.dfki.mycbr.gui.instance.list.InstanceFormEditor");
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            }
        });
        final Shell shell = this.form.getShell();
        btnAdd.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                String newValue;
                IInputValidator validator = new IInputValidator(){

                    public String isValid(String newText) {
                        if (newText.isEmpty()) {
                            return "Enter an instance name";
                        }
                        return null;
                    }
                };
                do {
                    InputDialog inputDialog = new InputDialog(shell, "Add instance", "Enter an instance name", "", validator);
                    inputDialog.open();
                    newValue = inputDialog.getValue();
                    if (newValue == null || newValue.isEmpty()) continue;
                    try {
                        InstancePage.this.c.addInstance(newValue);
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                    InstancePage.this.tblLinks.setInput((Object)InstancePage.this.c.getDirectInstances());
                    try {
                        if (InstancePage.this.c.getProject().getName().endsWith("_UNSAFED")) continue;
                        InstancePage.this.c.getProject().setName(String.valueOf(InstancePage.this.c.getProject().getName()) + "_UNSAFED");
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                } while (newValue != null && !newValue.isEmpty());
            }
        });
        btnRemove.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                if (InstancePage.this.selectedValue != null) {
                    InstancePage.this.c.removeInstance(InstancePage.this.selectedValue.getName());
                    InstancePage.this.tblLinks.setInput((Object)InstancePage.this.c.getDirectInstances());
                    try {
                        if (!InstancePage.this.c.getProject().getName().endsWith("_UNSAFED")) {
                            InstancePage.this.c.getProject().setName(String.valueOf(InstancePage.this.c.getProject().getName()) + "_UNSAFED");
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
    }

    private void fillModel() {
        this.tblLinks.setInput((Object)this.c.getDirectInstances());
    }

    public boolean isDirty() {
        return false;
    }

    public void setFocus() {
        this.form.setFocus();
    }

    public void dispose() {
        if (this.toolkit != null) {
            this.toolkit.dispose();
        }
        super.dispose();
    }
}

