/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.mycbr.gui.function.editor;

import de.dfki.mycbr.core.model.AttributeDesc;
import de.dfki.mycbr.core.model.ConceptDesc;
import de.dfki.mycbr.core.model.SimpleAttDesc;
import de.dfki.mycbr.core.similarity.AmalgamationFct;
import de.dfki.mycbr.core.similarity.ISimFct;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;

public class AmalgamationEditingSupport
extends EditingSupport {
    private CellEditor editor;
    private int column;
    private AmalgamationFct function;
    private List<String> availableFunctions;

    public AmalgamationEditingSupport(ColumnViewer viewer, int column, AmalgamationFct function) {
        super(viewer);
        switch (column) {
            case 1: {
                this.editor = new CheckboxCellEditor(null, 40);
                break;
            }
            case 3: {
                break;
            }
            default: {
                this.editor = new TextCellEditor((Composite)((TableViewer)viewer).getTable());
            }
        }
        this.column = column;
        this.function = function;
    }

    protected boolean canEdit(Object element) {
        return this.column != 0;
    }

    protected CellEditor getCellEditor(Object element) {
        if (this.column == 3) {
            this.availableFunctions = new ArrayList<String>();
            if (element instanceof ConceptDesc) {
                ConceptDesc conceptDesc = (ConceptDesc)element;
                for (AmalgamationFct fct : conceptDesc.getConcept().getAvailableAmalgamFcts()) {
                    this.availableFunctions.add(fct.getName());
                }
            } else {
                SimpleAttDesc simpleAttrDesc = (SimpleAttDesc)element;
                for (ISimFct fct : simpleAttrDesc.getSimFcts()) {
                    this.availableFunctions.add(fct.getName());
                }
            }
            this.editor = new ComboBoxCellEditor((Composite)((TableViewer)this.getViewer()).getTable(), this.availableFunctions.toArray(new String[0]));
        }
        return this.editor;
    }

    protected Object getValue(Object element) {
        AttributeDesc attrDesc = (AttributeDesc)element;
        Object activeFct = this.function.getActiveFct(attrDesc);
        switch (this.column) {
            case 0: {
                return attrDesc.getName();
            }
            case 1: {
                return this.function.isActive(attrDesc);
            }
            case 2: {
                return this.function.getWeight(attrDesc).toString();
            }
            case 3: {
                if (activeFct instanceof AmalgamationFct) {
                    return this.availableFunctions.indexOf(((AmalgamationFct)this.function.getActiveFct(attrDesc)).getName());
                }
                return this.availableFunctions.indexOf(((ISimFct)this.function.getActiveFct(attrDesc)).getName());
            }
        }
        return null;
    }

    protected void setValue(Object element, Object value) {
        AttributeDesc attrDesc = (AttributeDesc)element;
        switch (this.column) {
            case 0: {
                break;
            }
            case 1: {
                this.function.setActive(attrDesc, ((Boolean)value).booleanValue());
                break;
            }
            case 2: {
                this.function.setWeight(attrDesc, (Number)Float.valueOf(String.valueOf(value)));
                break;
            }
            case 3: {
                String newFunc = this.availableFunctions.get((Integer)value);
                if (attrDesc instanceof ConceptDesc) {
                    this.function.setActiveFct(attrDesc, (Object)((ConceptDesc)attrDesc).getConcept().getFct(newFunc));
                    break;
                }
                this.function.setActiveFct(attrDesc, (Object)((SimpleAttDesc)attrDesc).getFct(newFunc));
                break;
            }
        }
        this.getViewer().update(element, null);
    }
}

