/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.mycbr.gui.function.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class MultipleInputDialog
extends Dialog {
    private String title;
    private List<String> message;
    private List<String> value;
    private List<IInputValidator> validator;
    private Button okButton;
    private List<Text> text;
    private List<Text> errorMessageText;
    private List<String> errorMessage;
    private int numberOfInputs;

    public MultipleInputDialog(Shell parentShell, String dialogTitle, List<String> dialogMessage, List<IInputValidator> validator) {
        super(parentShell);
        this.title = dialogTitle;
        this.message = dialogMessage;
        this.numberOfInputs = dialogMessage.size();
        this.value = new ArrayList<String>();
        int i = 0;
        while (i < this.numberOfInputs) {
            this.value.add("");
            ++i;
        }
        this.validator = validator;
        this.text = new ArrayList<Text>();
        this.errorMessageText = new ArrayList<Text>();
        this.errorMessage = new ArrayList<String>();
        i = 0;
        while (i < this.numberOfInputs) {
            this.errorMessage.add("");
            ++i;
        }
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            int i = 0;
            while (i < this.numberOfInputs) {
                this.value.set(i, this.text.get(i).getText());
                ++i;
            }
        } else {
            this.value = null;
        }
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.text.get(0).setFocus();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        int i = 0;
        while (i < this.numberOfInputs) {
            if (this.message.get(i) != null) {
                Label label = new Label(composite, 64);
                label.setText(this.message.get(i));
                GridData data = new GridData(1796);
                data.widthHint = this.convertHorizontalDLUsToPixels(300);
                label.setLayoutData((Object)data);
                label.setFont(parent.getFont());
            }
            Text text = new Text(composite, this.getInputTextStyle());
            text.setLayoutData((Object)new GridData(768));
            text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    MultipleInputDialog.this.validateInput();
                }
            });
            this.text.add(text);
            Text errorMessageText = new Text(composite, 72);
            errorMessageText.setLayoutData((Object)new GridData(768));
            errorMessageText.setBackground(errorMessageText.getDisplay().getSystemColor(22));
            this.errorMessageText.add(errorMessageText);
            this.setErrorMessage(i, this.errorMessage.get(i));
            ++i;
        }
        MultipleInputDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected Label getErrorMessageLabel() {
        return null;
    }

    protected Button getOkButton() {
        return this.okButton;
    }

    protected List<Text> getText() {
        return this.text;
    }

    protected List<IInputValidator> getValidator() {
        return this.validator;
    }

    public List<String> getValue() {
        return this.value;
    }

    protected void validateInput() {
        int i = 0;
        while (i < this.numberOfInputs) {
            String errorMessage = null;
            if (this.validator.get(i) != null) {
                errorMessage = this.validator.get(i).isValid(this.text.get(i).getText());
            }
            this.setErrorMessage(i, errorMessage);
            ++i;
        }
    }

    public void setErrorMessage(int i, String errorMessage) {
        this.errorMessage.set(i, errorMessage);
        if (this.errorMessageText.get(i) != null && !this.errorMessageText.get(i).isDisposed()) {
            this.errorMessageText.get(i).setText(errorMessage == null ? " \n " : errorMessage);
            boolean hasError = errorMessage != null && StringConverter.removeWhiteSpaces((String)errorMessage).length() > 0;
            this.errorMessageText.get(i).setEnabled(hasError);
            this.errorMessageText.get(i).setVisible(hasError);
            this.errorMessageText.get(i).getParent().update();
            Button button = this.getButton(0);
            if (button != null) {
                button.setEnabled(errorMessage == null);
            }
        }
    }

    protected int getInputTextStyle() {
        return 2052;
    }
}

