/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.mycbr.gui.instance.list;

import de.dfki.mycbr.core.casebase.Instance;
import de.dfki.mycbr.core.model.Concept;
import de.dfki.mycbr.gui.instance.list.InstanceEditorInput;
import de.dfki.mycbr.gui.instance.list.InstanceListView;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

public class AddInstanceAction
extends Action
implements ActionFactory.IWorkbenchAction {
    public static final String ID = "de.dfki.mycbr.gui.instance.list.AddInstanceAction";
    private InstanceListView view;

    public AddInstanceAction(InstanceListView view) {
        this.view = view;
        this.setId(ID);
    }

    public void run() {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        Concept c = this.view.getCurrentConcept();
        if (c == null || c.toString().substring(0, 26).equals("de.dfki.mycbr.core.Project")) {
            MessageDialog messageDialog = new MessageDialog(shell, "No concept selected!", null, "Please select the concept you want to add instances to.", 2, new String[]{"Ok"}, 0);
            messageDialog.open();
        } else {
            Instance i = null;
            try {
                i = c.addInstance(this.findCaseName(c));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.view.addInstance(i);
            InstanceEditorInput input = new InstanceEditorInput(i);
            try {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)input, "de.dfki.mycbr.gui.instance.list.InstanceFormEditor");
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
            try {
                if (!c.getProject().getName().endsWith("_UNSAFED")) {
                    c.getProject().setName(String.valueOf(c.getProject().getName()) + "_UNSAFED");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private String findCaseName(Concept c) {
        String name;
        int i = c.getDirectInstances().size();
        do {
            name = String.valueOf(c.getName()) + " #" + i;
            ++i;
        } while (c.getInstance(name) != null);
        return name;
    }

    public void dispose() {
    }
}

