/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.mycbr.gui.instance.list;

import de.dfki.mycbr.core.casebase.Attribute;
import de.dfki.mycbr.core.casebase.Instance;
import de.dfki.mycbr.core.casebase.MultipleAttribute;
import de.dfki.mycbr.core.casebase.SpecialAttribute;
import de.dfki.mycbr.core.model.AttributeDesc;
import de.dfki.mycbr.core.model.Concept;
import de.dfki.mycbr.core.model.ConceptDesc;
import de.dfki.mycbr.core.model.DateDesc;
import de.dfki.mycbr.core.model.FloatDesc;
import de.dfki.mycbr.core.model.IntegerDesc;
import de.dfki.mycbr.core.model.StringDesc;
import de.dfki.mycbr.core.model.SymbolDesc;
import de.dfki.mycbr.gui.instance.list.ConceptDescContentProvider;
import de.dfki.mycbr.gui.instance.list.ConceptDescLabelProvider;
import de.dfki.mycbr.gui.instance.list.InstanceFormEditor;
import de.dfki.mycbr.gui.misc.ListUtil;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class GeneralPage
extends FormPage {
    public static final String ID = "de.dfki.mycbr.gui.instance.list.GeneralPage";
    private Instance i;
    private FormToolkit toolkit;
    private ScrolledForm form;

    public GeneralPage(FormEditor editor) {
        super(editor, ID, "Concept");
        this.i = ((InstanceFormEditor)editor).getInstance();
    }

    protected void createFormContent(IManagedForm managedForm) {
        this.toolkit = managedForm.getToolkit();
        this.form = managedForm.getForm();
        this.form.setText("Instance");
        this.form.setExpandHorizontal(true);
        this.form.setExpandVertical(true);
        this.createUi();
        this.fillModel();
        this.addUpdateOnChangeListeners();
        this.form.reflow(true);
    }

    private void createUi() {
        this.form.setText("Instance");
        final Shell shell = this.form.getShell();
        GridLayoutFactory.fillDefaults().margins(5, 5).spacing(5, 3).numColumns(3).applyTo(this.form.getBody());
        Section sctCase = this.toolkit.createSection(this.form.getBody(), 384);
        sctCase.setText("Instance information");
        GridDataFactory.fillDefaults().span(3, 1).applyTo((Control)sctCase);
        this.toolkit.createLabel(this.form.getBody(), "Name");
        Text txtName = this.toolkit.createText(this.form.getBody(), this.i.getName());
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)txtName);
        txtName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text t = (Text)e.widget;
                if (!t.getText().isEmpty()) {
                    GeneralPage.this.i.setName(t.getText());
                }
                Concept c = GeneralPage.this.i.getConcept();
                try {
                    if (!c.getProject().getName().endsWith("_UNSAFED")) {
                        c.getProject().setName(String.valueOf(c.getProject().getName()) + "_UNSAFED");
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        Section sctAttribute = this.toolkit.createSection(this.form.getBody(), 384);
        sctAttribute.setText("Attributes");
        GridDataFactory.fillDefaults().span(3, 1).applyTo((Control)sctAttribute);
        for (final AttributeDesc attrDesc : ListUtil.sortAttributeDescs(this.i.getConcept().getAllAttributeDescs().values())) {
            Hyperlink lnkRemove;
            Hyperlink lnkAdd;
            Label lbl = this.toolkit.createLabel(this.form.getBody(), attrDesc.getName());
            GridDataFactory.fillDefaults().align(1, 1).applyTo((Control)lbl);
            Composite cmpEditGroup = this.toolkit.createComposite(this.form.getBody());
            GridLayoutFactory.fillDefaults().numColumns(1).applyTo(cmpEditGroup);
            GridDataFactory.fillDefaults().align(4, 1).grab(true, false).applyTo((Control)cmpEditGroup);
            org.eclipse.swt.widgets.List wgtEdit = null;
            Composite cmpButtonGroup = this.toolkit.createComposite(this.form.getBody());
            cmpButtonGroup.setLayout((Layout)new FillLayout(512));
            GridDataFactory.fillDefaults().align(1, 1).applyTo((Control)cmpButtonGroup);
            Composite cmpRestButtonGroup = this.toolkit.createComposite(cmpButtonGroup);
            GridLayoutFactory.fillDefaults().numColumns(1).applyTo(cmpRestButtonGroup);
            Composite cmpSpecialValue = this.toolkit.createComposite(cmpButtonGroup);
            cmpSpecialValue.setLayout((Layout)new FillLayout(256));
            this.toolkit.createLabel(cmpSpecialValue, "Special Value: ");
            final Hyperlink lnkSpecialValue = this.toolkit.createHyperlink(cmpSpecialValue, this.getSpecialValue(attrDesc), 64);
            if (attrDesc instanceof DateDesc || attrDesc instanceof FloatDesc || attrDesc instanceof IntegerDesc || attrDesc instanceof StringDesc) {
                if (attrDesc.isMultiple()) {
                    final org.eclipse.swt.widgets.List list = new org.eclipse.swt.widgets.List(cmpEditGroup, 2564);
                    list.setItems(this.i.getAttForDesc(attrDesc).getValueAsString().split(";"));
                    wgtEdit = list;
                    Hyperlink lnkAdd2 = this.toolkit.createHyperlink(cmpRestButtonGroup, "Add", 64);
                    Hyperlink lnkRemove2 = this.toolkit.createHyperlink(cmpRestButtonGroup, "Remove", 64);
                    lnkAdd2.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                        public void linkActivated(HyperlinkEvent e) {
                            String newValue;
                            IInputValidator validator = new IInputValidator(){

                                public String isValid(String newText) {
                                    if (newText.isEmpty()) {
                                        return "Please enter a value";
                                    }
                                    Attribute a = null;
                                    try {
                                        a = attrDesc.getAttribute((Object)newText);
                                    }
                                    catch (Exception exception) {}
                                    if (a == null || !attrDesc.fitsSingle(a)) {
                                        return "This value is not allowed";
                                    }
                                    return null;
                                }
                            };
                            do {
                                MultipleAttribute multipleAttribute;
                                InputDialog inputDialog = new InputDialog(shell, "Add a value", "Add a value", "", validator);
                                inputDialog.open();
                                newValue = inputDialog.getValue();
                                if (newValue == null || newValue.isEmpty()) continue;
                                Attribute attr = GeneralPage.this.i.getAttForDesc(attrDesc);
                                if (attr instanceof SpecialAttribute) {
                                    multipleAttribute = new MultipleAttribute(attrDesc, new LinkedList());
                                    GeneralPage.this.i.addAttribute(attrDesc, (Attribute)multipleAttribute);
                                    list.removeAll();
                                    lnkSpecialValue.setText("none");
                                } else {
                                    multipleAttribute = (MultipleAttribute)attr;
                                }
                                try {
                                    multipleAttribute.addValue(attrDesc.getAttribute((Object)newValue));
                                    list.add(newValue);
                                }
                                catch (ParseException e1) {
                                    e1.printStackTrace();
                                }
                            } while (newValue != null && !newValue.isEmpty());
                        }
                    });
                    lnkRemove2.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                        public void linkActivated(HyperlinkEvent e) {
                            String value;
                            if (list.getSelection().length > 0 && (value = list.getSelection()[0]) != null) {
                                MultipleAttribute multipleAttribute = (MultipleAttribute)GeneralPage.this.i.getAttForDesc(attrDesc);
                                try {
                                    multipleAttribute.removeValue(attrDesc.getAttribute((Object)value));
                                    list.remove(value);
                                }
                                catch (ParseException e1) {
                                    e1.printStackTrace();
                                }
                            }
                        }
                    });
                    GridDataFactory.fillDefaults().align(16384, 128).minSize(-1, 75).applyTo((Control)list);
                } else {
                    Text txt = this.toolkit.createText(cmpEditGroup, this.i.getAttForDesc(attrDesc).getValueAsString(), 2048);
                    GridDataFactory.fillDefaults().align(4, 1).hint(300, -1).applyTo((Control)txt);
                    wgtEdit = txt;
                    final ControlDecoration ctrlDec = new ControlDecoration((Control)txt, 16512);
                    FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
                    ctrlDec.setDescriptionText("This value is not allowed.");
                    ctrlDec.setImage(fieldDecoration.getImage());
                    ctrlDec.hide();
                    txt.addModifyListener(new ModifyListener(){

                        public void modifyText(ModifyEvent e) {
                            Text t = (Text)e.widget;
                            Attribute attr = null;
                            try {
                                attr = attrDesc.getAttribute((Object)t.getText());
                            }
                            catch (ParseException parseException) {}
                            if (attr != null) {
                                GeneralPage.this.i.addAttribute(attrDesc, attr);
                                lnkSpecialValue.setText("none");
                                ctrlDec.hide();
                                Concept c = GeneralPage.this.i.getConcept();
                                try {
                                    if (!c.getProject().getName().endsWith("_UNSAFED")) {
                                        c.getProject().setName(String.valueOf(c.getProject().getName()) + "_UNSAFED");
                                    }
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                }
                            } else {
                                ctrlDec.show();
                            }
                        }
                    });
                }
            } else if (attrDesc instanceof SymbolDesc) {
                final SymbolDesc symbolDesc = (SymbolDesc)attrDesc;
                if (attrDesc.isMultiple()) {
                    final org.eclipse.swt.widgets.List list = new org.eclipse.swt.widgets.List(cmpEditGroup, 2564);
                    list.setItems(this.i.getAttForDesc(attrDesc).getValueAsString().split(";"));
                    wgtEdit = list;
                    lnkAdd = this.toolkit.createHyperlink(cmpRestButtonGroup, "Add", 64);
                    lnkRemove = this.toolkit.createHyperlink(cmpRestButtonGroup, "Remove", 64);
                    lnkAdd.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                        public void linkActivated(HyperlinkEvent e) {
                            ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, (ILabelProvider)new LabelProvider());
                            ArrayList<String> allowedValues = new ArrayList<String>();
                            List<String> usedValues = Arrays.asList(GeneralPage.this.i.getAttForDesc((AttributeDesc)symbolDesc).getValueAsString().split(";"));
                            for (String value : symbolDesc.getAllowedValues()) {
                                if (usedValues.contains(value)) continue;
                                allowedValues.add(value);
                            }
                            dialog.setElements(allowedValues.toArray());
                            dialog.setTitle("Please choose a value");
                            dialog.open();
                            if (dialog.getResult() != null) {
                                MultipleAttribute multipleAttribute;
                                Attribute attr = GeneralPage.this.i.getAttForDesc((AttributeDesc)symbolDesc);
                                if (attr instanceof SpecialAttribute) {
                                    multipleAttribute = new MultipleAttribute((AttributeDesc)symbolDesc, new LinkedList());
                                    GeneralPage.this.i.addAttribute((AttributeDesc)symbolDesc, (Attribute)multipleAttribute);
                                    list.removeAll();
                                    lnkSpecialValue.setText("none");
                                    Concept c = GeneralPage.this.i.getConcept();
                                    try {
                                        if (!c.getProject().getName().endsWith("_UNSAFED")) {
                                            c.getProject().setName(String.valueOf(c.getProject().getName()) + "_UNSAFED");
                                        }
                                    }
                                    catch (Exception ex) {
                                        ex.printStackTrace();
                                    }
                                } else {
                                    multipleAttribute = (MultipleAttribute)attr;
                                }
                                String symbol = String.valueOf(dialog.getResult()[0]);
                                multipleAttribute.addValue(symbolDesc.getAttribute(symbol));
                                list.add(symbol);
                            }
                        }
                    });
                    lnkRemove.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                        public void linkActivated(HyperlinkEvent e) {
                            String symbol;
                            if (list.getSelection().length > 0 && (symbol = list.getSelection()[0]) != null) {
                                MultipleAttribute multipleAttribute = (MultipleAttribute)GeneralPage.this.i.getAttForDesc((AttributeDesc)symbolDesc);
                                multipleAttribute.removeValue(symbolDesc.getAttribute(symbol));
                                list.remove(symbol);
                            }
                        }
                    });
                    GridDataFactory.fillDefaults().align(4, 128).applyTo((Control)lbl);
                    GridDataFactory.fillDefaults().align(16384, 128).minSize(-1, 100).applyTo((Control)list);
                } else {
                    final Text txt = this.toolkit.createText(cmpEditGroup, this.i.getAttForDesc(attrDesc).getValueAsString(), 2056);
                    GridDataFactory.fillDefaults().align(4, 1).applyTo((Control)txt);
                    wgtEdit = txt;
                    Hyperlink lnkChange = this.toolkit.createHyperlink(cmpRestButtonGroup, "Change", 64);
                    lnkChange.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                        public void linkActivated(HyperlinkEvent e) {
                            ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, (ILabelProvider)new LabelProvider());
                            Set elements = symbolDesc.getAllowedValues();
                            dialog.setElements(elements.toArray());
                            dialog.setTitle("Please choose a value");
                            dialog.open();
                            if (dialog.getResult() != null) {
                                String symbol = String.valueOf(dialog.getResult()[0]);
                                GeneralPage.this.i.addAttribute((AttributeDesc)symbolDesc, symbolDesc.getAttribute(symbol));
                                txt.setText(symbol);
                                lnkSpecialValue.setText("none");
                                Concept c = GeneralPage.this.i.getConcept();
                                try {
                                    if (!c.getProject().getName().endsWith("_UNSAFED")) {
                                        c.getProject().setName(String.valueOf(c.getProject().getName()) + "_UNSAFED");
                                    }
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                }
                            }
                        }
                    });
                }
            } else if (attrDesc instanceof ConceptDesc) {
                final ConceptDesc conceptDesc = (ConceptDesc)attrDesc;
                if (attrDesc.isMultiple()) {
                    final TableViewer tblValues = new TableViewer(cmpEditGroup, 68356);
                    tblValues.getTable().setLinesVisible(true);
                    tblValues.setContentProvider((IContentProvider)new ConceptDescContentProvider());
                    tblValues.setLabelProvider((IBaseLabelProvider)new ConceptDescLabelProvider());
                    tblValues.setInput((Object)this.i.getAttForDesc((AttributeDesc)conceptDesc));
                    wgtEdit = tblValues.getTable();
                    lnkAdd = this.toolkit.createHyperlink(cmpRestButtonGroup, "Add", 64);
                    lnkRemove = this.toolkit.createHyperlink(cmpRestButtonGroup, "Remove", 64);
                    lnkAdd.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                        public void linkActivated(HyperlinkEvent e) {
                            ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, (ILabelProvider)new LabelProvider());
                            HashSet<String> elements = new HashSet<String>();
                            for (Instance i : conceptDesc.getConcept().getAllInstances()) {
                                elements.add(i.getName());
                            }
                            dialog.setElements(elements.toArray());
                            dialog.setTitle("Please choose an instance");
                            dialog.open();
                            if (dialog.getResult() != null) {
                                String conceptName = String.valueOf(dialog.getResult()[0]);
                                Attribute currentAttribute = GeneralPage.this.i.getAttForDesc((AttributeDesc)conceptDesc);
                                try {
                                    Attribute newAttribute = conceptDesc.getAttribute((Object)conceptName);
                                    if (currentAttribute instanceof SpecialAttribute) {
                                        LinkedList<Attribute> attributes = new LinkedList<Attribute>();
                                        attributes.add(newAttribute);
                                        MultipleAttribute multipleAttribute = new MultipleAttribute((AttributeDesc)conceptDesc, attributes);
                                        GeneralPage.this.i.addAttribute((AttributeDesc)conceptDesc, (Attribute)multipleAttribute);
                                        lnkSpecialValue.setText("none");
                                    } else {
                                        MultipleAttribute multipleAttribute = (MultipleAttribute)GeneralPage.this.i.getAttForDesc((AttributeDesc)conceptDesc);
                                        multipleAttribute.addValue(newAttribute);
                                    }
                                    tblValues.setInput((Object)GeneralPage.this.i.getAttForDesc((AttributeDesc)conceptDesc));
                                    Concept c = GeneralPage.this.i.getConcept();
                                    try {
                                        if (!c.getProject().getName().endsWith("_UNSAFED")) {
                                            c.getProject().setName(String.valueOf(c.getProject().getName()) + "_UNSAFED");
                                        }
                                    }
                                    catch (Exception ex) {
                                        ex.printStackTrace();
                                    }
                                }
                                catch (ParseException parseException) {}
                            }
                        }
                    });
                    lnkRemove.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                        public void linkActivated(HyperlinkEvent e) {
                            String symbol = tblValues.getTable().getSelection()[0].getText();
                            if (symbol != null) {
                                MultipleAttribute multipleAttribute = (MultipleAttribute)GeneralPage.this.i.getAttForDesc((AttributeDesc)conceptDesc);
                                try {
                                    multipleAttribute.removeValue(conceptDesc.getAttribute((Object)symbol));
                                }
                                catch (ParseException e1) {
                                    e1.printStackTrace();
                                }
                                tblValues.setInput((Object)GeneralPage.this.i.getAttForDesc((AttributeDesc)conceptDesc));
                                Concept c = GeneralPage.this.i.getConcept();
                                try {
                                    if (!c.getProject().getName().endsWith("_UNSAFED")) {
                                        c.getProject().setName(String.valueOf(c.getProject().getName()) + "_UNSAFED");
                                    }
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                }
                            }
                        }
                    });
                    GridDataFactory.fillDefaults().align(16384, 128).hint(-1, 75).applyTo((Control)tblValues.getTable());
                } else {
                    ComboViewer combo = new ComboViewer(cmpEditGroup, 2056);
                    combo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
                    combo.setLabelProvider((IBaseLabelProvider)new LabelProvider());
                    HashSet<String> elements = new HashSet<String>();
                    for (Instance i : conceptDesc.getConcept().getAllInstances()) {
                        elements.add(i.getName());
                    }
                    combo.setInput(elements);
                    combo.setSelection((ISelection)new StructuredSelection((Object)this.i.getAttForDesc(attrDesc).getValueAsString()));
                    wgtEdit = combo.getCombo();
                    GridDataFactory.fillDefaults().align(4, 128).grab(true, false).span(2, 1).applyTo(combo.getControl());
                    combo.addSelectionChangedListener(new ISelectionChangedListener(){

                        public void selectionChanged(SelectionChangedEvent event) {
                            IStructuredSelection ss = (IStructuredSelection)event.getSelection();
                            String newValue = (String)ss.getFirstElement();
                            try {
                                GeneralPage.this.i.addAttribute(attrDesc, attrDesc.getAttribute((Object)newValue));
                            }
                            catch (ParseException e) {
                                e.printStackTrace();
                            }
                            Concept c = GeneralPage.this.i.getConcept();
                            try {
                                if (!c.getProject().getName().endsWith("_UNSAFED")) {
                                    c.getProject().setName(String.valueOf(c.getProject().getName()) + "_UNSAFED");
                                }
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                    });
                }
            }
            if (cmpRestButtonGroup.getChildren().length == 0) {
                cmpRestButtonGroup.dispose();
            }
            GridDataFactory.fillDefaults().align(4, 1).grab(true, false).applyTo((Control)wgtEdit);
            org.eclipse.swt.widgets.List w = wgtEdit;
            lnkSpecialValue.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter((Control)w, lnkSpecialValue){
                private final /* synthetic */ Control val$w;
                private final /* synthetic */ Hyperlink val$lnkSpecialValue;
                {
                    this.val$w = control;
                    this.val$lnkSpecialValue = hyperlink;
                }

                public void linkActivated(HyperlinkEvent e) {
                    ListDialog ld = new ListDialog(shell);
                    ld.setAddCancelButton(true);
                    ld.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
                    ld.setLabelProvider((ILabelProvider)new LabelProvider());
                    Set elements = GeneralPage.this.i.getConcept().getProject().getSpecialValueDesc().getAllowedValues();
                    elements.remove("_others_");
                    ld.setInput((Object)elements.toArray());
                    ld.setTitle("Select special value:");
                    ld.open();
                    if (ld.getResult() != null) {
                        Attribute specAttr = GeneralPage.this.i.getConcept().getProject().getSpecialAttribute(String.valueOf(ld.getResult()[0]));
                        GeneralPage.this.i.addAttribute(attrDesc, specAttr);
                        GeneralPage.this.setSpecialValueForWidget(this.val$w, specAttr.getValueAsString());
                        this.val$lnkSpecialValue.setText(specAttr.getValueAsString());
                        Concept c = GeneralPage.this.i.getConcept();
                        try {
                            if (!c.getProject().getName().endsWith("_UNSAFED")) {
                                c.getProject().setName(String.valueOf(c.getProject().getName()) + "_UNSAFED");
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }
            });
        }
    }

    private String getSpecialValue(AttributeDesc attrDesc) {
        Attribute a = this.i.getAttForDesc(attrDesc);
        String result = a instanceof SpecialAttribute ? a.getValueAsString() : "none";
        return result;
    }

    private void setSpecialValueForWidget(Control w, String s) {
        if (w instanceof Text) {
            ((Text)w).setText(s);
        } else if (w instanceof org.eclipse.swt.widgets.List) {
            ((org.eclipse.swt.widgets.List)w).removeAll();
            ((org.eclipse.swt.widgets.List)w).add(s);
        }
    }

    private void fillModel() {
    }

    private void addUpdateOnChangeListeners() {
    }

    public boolean isDirty() {
        return false;
    }

    public void setFocus() {
        this.form.setFocus();
    }

    public void dispose() {
        this.toolkit.dispose();
        super.dispose();
    }
}

