/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.impl.ICUData;
import com.ibm.icu.impl.Trie2;
import com.ibm.icu.impl.Trie2Writable;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.lang.UScript;
import com.ibm.icu.text.Normalizer;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.ULocale;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.Reader;
import java.text.ParseException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpoofChecker {
    public static final int SINGLE_SCRIPT_CONFUSABLE = 1;
    public static final int MIXED_SCRIPT_CONFUSABLE = 2;
    public static final int WHOLE_SCRIPT_CONFUSABLE = 4;
    public static final int ANY_CASE = 8;
    public static final int SINGLE_SCRIPT = 16;
    public static final int INVISIBLE = 32;
    public static final int CHAR_LIMIT = 64;
    public static final int ALL_CHECKS = 127;
    static final int MAGIC = 944111087;
    private int fMagic;
    private int fChecks;
    private SpoofData fSpoofData;
    private Set<ULocale> fAllowedLocales;
    private UnicodeSet fAllowedCharsSet;
    static final int SL_TABLE_FLAG = 0x1000000;
    static final int SA_TABLE_FLAG = 0x2000000;
    static final int ML_TABLE_FLAG = 0x4000000;
    static final int MA_TABLE_FLAG = 0x8000000;
    static final int KEY_MULTIPLE_VALUES = 0x10000000;
    static final int KEY_LENGTH_SHIFT = 29;

    private SpoofChecker() {
    }

    public int getChecks() {
        return this.fChecks;
    }

    public Set<ULocale> getAllowedLocales() {
        return this.fAllowedLocales;
    }

    public UnicodeSet getAllowedChars() {
        return this.fAllowedCharsSet;
    }

    public boolean failsChecks(String text, CheckResult checkResult) {
        int length = text.length();
        int result = 0;
        int failPos = Integer.MAX_VALUE;
        int scriptCount = -1;
        if ((this.fChecks & 0x10) != 0 && (scriptCount = this.scriptScan(text, checkResult)) >= 2) {
            result |= 0x10;
        }
        if ((this.fChecks & 0x40) != 0) {
            int i = 0;
            while (i < length) {
                int c = Character.codePointAt(text, i);
                i = Character.offsetByCodePoints(text, i, 1);
                if (this.fAllowedCharsSet.contains(c)) continue;
                result |= 0x40;
                if (i >= failPos) break;
                failPos = i;
                break;
            }
        }
        if ((this.fChecks & 0x26) != 0) {
            String nfdText = Normalizer.normalize(text, Normalizer.NFD, 0);
            if ((this.fChecks & 0x20) != 0) {
                int firstNonspacingMark = 0;
                boolean haveMultipleMarks = false;
                UnicodeSet marksSeenSoFar = new UnicodeSet();
                int i = 0;
                while (i < length) {
                    int c = Character.codePointAt(nfdText, i);
                    i = Character.offsetByCodePoints(nfdText, i, 1);
                    if (Character.getType(c) != 6) {
                        firstNonspacingMark = 0;
                        if (!haveMultipleMarks) continue;
                        marksSeenSoFar.clear();
                        haveMultipleMarks = false;
                        continue;
                    }
                    if (firstNonspacingMark == 0) {
                        firstNonspacingMark = c;
                        continue;
                    }
                    if (!haveMultipleMarks) {
                        marksSeenSoFar.add(firstNonspacingMark);
                        haveMultipleMarks = true;
                    }
                    if (marksSeenSoFar.contains(c)) {
                        result |= 0x20;
                        failPos = i;
                        break;
                    }
                    marksSeenSoFar.add(c);
                }
            }
            if ((this.fChecks & 6) != 0) {
                if (scriptCount == -1) {
                    scriptCount = this.scriptScan(text, null);
                }
                ScriptSet scripts = new ScriptSet();
                this.wholeScriptCheck(nfdText, scripts);
                int confusableScriptCount = scripts.countMembers();
                if ((this.fChecks & 4) != 0 && confusableScriptCount >= 2 && scriptCount == 1) {
                    result |= 4;
                }
                if ((this.fChecks & 2) != 0 && confusableScriptCount >= 1 && scriptCount > 1) {
                    result |= 2;
                }
            }
        }
        if (checkResult != null) {
            checkResult.checks = result;
            if (failPos != Integer.MAX_VALUE) {
                checkResult.position = failPos;
            }
        }
        return result != 0;
    }

    public boolean failsChecks(String text) {
        return this.failsChecks(text, null);
    }

    public int areConfusable(String s1, String s2) {
        boolean possiblyWholeScriptConfusables;
        String s2Skeleton;
        String s1Skeleton;
        if ((this.fChecks & 7) == 0) {
            throw new IllegalArgumentException("No confusable checks are enabled.");
        }
        int flagsForSkeleton = this.fChecks & 8;
        int result = 0;
        int s1ScriptCount = this.scriptScan(s1, null);
        int s2ScriptCount = this.scriptScan(s2, null);
        if ((this.fChecks & 1) != 0 && s1ScriptCount <= 1 && s2ScriptCount <= 1) {
            s1Skeleton = this.getSkeleton(flagsForSkeleton |= 1, s1);
            s2Skeleton = this.getSkeleton(flagsForSkeleton, s2);
            if (s1Skeleton.length() == s2Skeleton.length() && s1Skeleton.equals(s2Skeleton)) {
                result |= 1;
            }
        }
        if (result & true) {
            return result;
        }
        boolean bl = possiblyWholeScriptConfusables = s1ScriptCount <= 1 && s2ScriptCount <= 1 && (this.fChecks & 4) != 0;
        if ((this.fChecks & 2) != 0 || possiblyWholeScriptConfusables) {
            s1Skeleton = this.getSkeleton(flagsForSkeleton &= 0xFFFFFFFE, s1);
            s2Skeleton = this.getSkeleton(flagsForSkeleton, s2);
            if (s1Skeleton.length() == s2Skeleton.length() && s1Skeleton.equals(s2Skeleton)) {
                result |= 2;
                if (possiblyWholeScriptConfusables) {
                    result |= 4;
                }
            }
        }
        return result;
    }

    public String getSkeleton(int type, String s) {
        if ((type & 0xFFFFFFF6) != 0) {
            return null;
        }
        int tableMask = 0;
        switch (type) {
            case 0: {
                tableMask = 0x4000000;
                break;
            }
            case 1: {
                tableMask = 0x1000000;
                break;
            }
            case 8: {
                tableMask = 0x8000000;
                break;
            }
            case 9: {
                tableMask = 0x2000000;
                break;
            }
            default: {
                return null;
            }
        }
        String nfdInput = Normalizer.normalize(s, Normalizer.NFD, 0);
        int normalizedLen = nfdInput.length();
        int inputIndex = 0;
        StringBuilder skelStr = new StringBuilder();
        while (inputIndex < normalizedLen) {
            int c = Character.codePointAt(nfdInput, inputIndex);
            inputIndex = Character.offsetByCodePoints(nfdInput, inputIndex, 1);
            this.confusableLookup(c, tableMask, skelStr);
        }
        String result = skelStr.toString();
        if (!Normalizer.isNormalized(result, Normalizer.NFD, 0)) {
            String normedResult;
            result = normedResult = Normalizer.normalize(result, Normalizer.NFD, 0);
        }
        return result;
    }

    private void confusableLookup(int inChar, int tableMask, StringBuilder dest) {
        int low = 0;
        int mid = 0;
        int limit = this.fSpoofData.fRawData.fCFUKeysSize;
        boolean foundChar = false;
        do {
            int delta;
            int midc;
            if (inChar == (midc = this.fSpoofData.fCFUKeys[mid = low + (delta = (limit - low) / 2)] & 0x1FFFFF)) {
                foundChar = true;
                break;
            }
            if (inChar < midc) {
                limit = mid;
                continue;
            }
            low = mid + 1;
        } while (low < limit);
        if (!foundChar) {
            dest.appendCodePoint(inChar);
            return;
        }
        boolean foundKey = false;
        int keyFlags = this.fSpoofData.fCFUKeys[mid] & 0xFF000000;
        if ((keyFlags & tableMask) == 0) {
            if ((keyFlags & 0x10000000) != 0) {
                int altMid = mid - 1;
                while ((this.fSpoofData.fCFUKeys[altMid] & 0xFFFFFF) == inChar) {
                    keyFlags = this.fSpoofData.fCFUKeys[altMid] & 0xFF000000;
                    if ((keyFlags & tableMask) != 0) {
                        mid = altMid;
                        foundKey = true;
                        break;
                    }
                    --altMid;
                }
                if (!foundKey) {
                    altMid = mid + 1;
                    while ((this.fSpoofData.fCFUKeys[altMid] & 0xFFFFFF) == inChar) {
                        keyFlags = this.fSpoofData.fCFUKeys[altMid] & 0xFF000000;
                        if ((keyFlags & tableMask) != 0) {
                            mid = altMid;
                            foundKey = true;
                            break;
                        }
                        ++altMid;
                    }
                }
            }
            if (!foundKey) {
                dest.appendCodePoint(inChar);
                return;
            }
        }
        int stringLen = SpoofChecker.getKeyLength(keyFlags) + 1;
        int keyTableIndex = mid;
        short value = this.fSpoofData.fCFUValues[keyTableIndex];
        if (stringLen == 1) {
            dest.append((char)value);
            return;
        }
        if (stringLen == 4) {
            int stringLengthsLimit = this.fSpoofData.fRawData.fCFUStringLengthsSize;
            int ix = 0;
            while (ix < stringLengthsLimit) {
                if (this.fSpoofData.fCFUStringLengths[ix].fLastString >= value) {
                    stringLen = this.fSpoofData.fCFUStringLengths[ix].fStrLength;
                    break;
                }
                ++ix;
            }
            assert (ix < stringLengthsLimit);
        }
        assert (value + stringLen <= this.fSpoofData.fRawData.fCFUStringTableLen);
        dest.append(this.fSpoofData.fCFUStrings, (int)value, stringLen);
    }

    void wholeScriptCheck(CharSequence text, ScriptSet result) {
        int inputIdx = 0;
        Trie2 table = (this.fChecks & 8) != 0 ? this.fSpoofData.fAnyCaseTrie : this.fSpoofData.fLowerCaseTrie;
        result.setAll();
        while (inputIdx < text.length()) {
            int c = Character.codePointAt(text, inputIdx);
            inputIdx = Character.offsetByCodePoints(text, inputIdx, 1);
            int index = table.get(c);
            if (index == 0) {
                int cpScript = UScript.getScript(c);
                assert (cpScript > 1);
                result.intersect(cpScript);
                continue;
            }
            if (index == 1) continue;
            result.intersect(this.fSpoofData.fScriptSets[index]);
        }
    }

    int scriptScan(CharSequence text, CheckResult checkResult) {
        int inputIdx = 0;
        int scriptCount = 0;
        int lastScript = -1;
        int sc = -1;
        while (inputIdx < text.length() && scriptCount < 2) {
            int c = Character.codePointAt(text, inputIdx);
            inputIdx = Character.offsetByCodePoints(text, inputIdx, 1);
            sc = UScript.getScript(c);
            if (sc == 0 || sc == 1 || sc == 103) continue;
            if (sc == 22 || sc == 20 || sc == 18) {
                sc = 17;
            }
            if (sc == lastScript) continue;
            ++scriptCount;
            lastScript = sc;
        }
        if (scriptCount == 2 && checkResult != null) {
            checkResult.position = inputIdx;
        }
        return scriptCount;
    }

    static final int getKeyLength(int x) {
        return x >> 29 & 3;
    }

    /* synthetic */ SpoofChecker(SpoofChecker spoofChecker) {
        this();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        int fMagic;
        int fChecks;
        SpoofData fSpoofData;
        UnicodeSet fAllowedCharsSet;
        Set<ULocale> fAllowedLocales;

        public Builder() {
            this.fMagic = 944111087;
            this.fChecks = 127;
            this.fSpoofData = null;
            this.fAllowedCharsSet = new UnicodeSet(0, 0x10FFFF);
            this.fAllowedLocales = new LinkedHashSet<ULocale>();
        }

        public Builder(SpoofChecker src) {
            this.fMagic = src.fMagic;
            this.fChecks = src.fChecks;
            this.fSpoofData = null;
            this.fAllowedCharsSet = src.fAllowedCharsSet.cloneAsThawed();
            this.fAllowedLocales = new LinkedHashSet<ULocale>();
            this.fAllowedLocales.addAll(src.fAllowedLocales);
        }

        public SpoofChecker build() {
            if (this.fSpoofData == null) {
                try {
                    this.fSpoofData = SpoofData.getDefault();
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            if (!SpoofData.validateDataVersion(this.fSpoofData.fRawData)) {
                return null;
            }
            SpoofChecker result = new SpoofChecker(null);
            result.fMagic = this.fMagic;
            result.fChecks = this.fChecks;
            result.fSpoofData = this.fSpoofData;
            result.fAllowedCharsSet = (UnicodeSet)this.fAllowedCharsSet.clone();
            result.fAllowedCharsSet.freeze();
            result.fAllowedLocales = this.fAllowedLocales;
            return result;
        }

        public Builder setData(Reader confusables, Reader confusablesWholeScript) throws ParseException, IOException {
            this.fSpoofData = new SpoofData();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream os = new DataOutputStream(bos);
            ConfusabledataBuilder.buildConfusableData(this.fSpoofData, confusables);
            WSConfusableDataBuilder.buildWSConfusableData(this.fSpoofData, os, confusablesWholeScript);
            return this;
        }

        public Builder setChecks(int checks) {
            if ((checks & 0xFFFFFF80) != 0) {
                throw new IllegalArgumentException("Bad Spoof Checks value.");
            }
            this.fChecks = checks & 0x7F;
            return this;
        }

        public Builder setAllowedLocales(Set<ULocale> locales) {
            this.fAllowedCharsSet.clear();
            for (ULocale locale : locales) {
                this.addScriptChars(locale, this.fAllowedCharsSet);
            }
            this.fAllowedLocales = new LinkedHashSet<ULocale>();
            if (locales.size() == 0) {
                this.fAllowedCharsSet.add(0, 0x10FFFF);
                this.fChecks &= 0xFFFFFFBF;
                return this;
            }
            UnicodeSet tempSet = new UnicodeSet();
            tempSet.applyIntPropertyValue(4106, 0);
            this.fAllowedCharsSet.addAll(tempSet);
            tempSet.applyIntPropertyValue(4106, 1);
            this.fAllowedCharsSet.addAll(tempSet);
            this.fAllowedLocales.addAll(locales);
            this.fChecks |= 0x40;
            return this;
        }

        private void addScriptChars(ULocale locale, UnicodeSet allowedChars) {
            int[] scripts = UScript.getCode(locale);
            UnicodeSet tmpSet = new UnicodeSet();
            int i = 0;
            while (i < scripts.length) {
                tmpSet.applyIntPropertyValue(4106, scripts[i]);
                allowedChars.addAll(tmpSet);
                ++i;
            }
        }

        public Builder setAllowedChars(UnicodeSet chars) {
            this.fAllowedCharsSet = chars.cloneAsThawed();
            this.fAllowedLocales = new LinkedHashSet<ULocale>();
            this.fChecks |= 0x40;
            return this;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class ConfusabledataBuilder {
            private SpoofData fSpoofData;
            private ByteArrayOutputStream bos;
            private DataOutputStream os;
            private Hashtable<Integer, SPUString> fSLTable;
            private Hashtable<Integer, SPUString> fSATable;
            private Hashtable<Integer, SPUString> fMLTable;
            private Hashtable<Integer, SPUString> fMATable;
            private UnicodeSet fKeySet;
            private StringBuffer fStringTable;
            private Vector<Integer> fKeyVec;
            private Vector<Integer> fValueVec;
            private Vector<Integer> fStringLengthsTable;
            private SPUStringPool stringPool;
            private Pattern fParseLine;
            private Pattern fParseHexNum;
            private int fLineNum;

            ConfusabledataBuilder(SpoofData spData, ByteArrayOutputStream bos) {
                this.bos = bos;
                this.os = new DataOutputStream(bos);
                this.fSpoofData = spData;
                this.fSLTable = new Hashtable();
                this.fSATable = new Hashtable();
                this.fMLTable = new Hashtable();
                this.fMATable = new Hashtable();
                this.fKeySet = new UnicodeSet();
                this.fKeyVec = new Vector();
                this.fValueVec = new Vector();
                this.stringPool = new SPUStringPool();
            }

            void build(Reader confusables) throws ParseException, IOException {
                StringBuffer fInput = new StringBuffer();
                WSConfusableDataBuilder.readWholeFileToString(confusables, fInput);
                this.fParseLine = Pattern.compile("(?m)^[ \\t]*([0-9A-Fa-f]+)[ \\t]+;[ \\t]*([0-9A-Fa-f]+(?:[ \\t]+[0-9A-Fa-f]+)*)[ \\t]*;\\s*(?:(SL)|(SA)|(ML)|(MA))[ \\t]*(?:#.*?)?$|^([ \\t]*(?:#.*?)?)$|^(.*?)$");
                this.fParseHexNum = Pattern.compile("\\s*([0-9A-F]+)");
                if (fInput.charAt(0) == '\ufeff') {
                    fInput.setCharAt(0, ' ');
                }
                Matcher matcher = this.fParseLine.matcher(fInput);
                while (matcher.find()) {
                    Hashtable<Integer, SPUString> table;
                    ++this.fLineNum;
                    if (matcher.start(7) >= 0) continue;
                    if (matcher.start(8) >= 0) {
                        throw new ParseException("Confusables, line " + this.fLineNum + ": Unrecognized Line: " + matcher.group(8), matcher.start(8));
                    }
                    int keyChar = Integer.parseInt(matcher.group(1), 16);
                    if (keyChar > 0x10FFFF) {
                        throw new ParseException("Confusables, line " + this.fLineNum + ": Bad code point: " + matcher.group(1), matcher.start(1));
                    }
                    Matcher m = this.fParseHexNum.matcher(matcher.group(2));
                    StringBuilder mapString = new StringBuilder();
                    while (m.find()) {
                        int c = Integer.parseInt(m.group(1), 16);
                        if (keyChar > 0x10FFFF) {
                            throw new ParseException("Confusables, line " + this.fLineNum + ": Bad code point: " + Integer.toString(c, 16), matcher.start(2));
                        }
                        mapString.appendCodePoint(c);
                    }
                    assert (mapString.length() >= 1);
                    SPUString smapString = this.stringPool.addString(mapString.toString());
                    Hashtable<Integer, SPUString> hashtable = matcher.start(3) >= 0 ? this.fSLTable : (matcher.start(4) >= 0 ? this.fSATable : (matcher.start(5) >= 0 ? this.fMLTable : (table = matcher.start(6) >= 0 ? this.fMATable : null)));
                    assert (table != null);
                    table.put(keyChar, smapString);
                    this.fKeySet.add(keyChar);
                }
                this.stringPool.sort();
                this.fStringTable = new StringBuffer();
                this.fStringLengthsTable = new Vector();
                int previousStringLength = 0;
                int previousStringIndex = 0;
                int poolSize = this.stringPool.size();
                int i = 0;
                while (i < poolSize) {
                    SPUString s = this.stringPool.getByIndex(i);
                    int strLen = s.fStr.length();
                    int strIndex = this.fStringTable.length();
                    assert (strLen >= previousStringLength);
                    if (strLen == 1) {
                        s.fStrTableIndex = s.fStr.charAt(0);
                    } else {
                        if (strLen > previousStringLength && previousStringLength >= 4) {
                            this.fStringLengthsTable.addElement(previousStringIndex);
                            this.fStringLengthsTable.addElement(previousStringLength);
                        }
                        s.fStrTableIndex = strIndex;
                        this.fStringTable.append(s.fStr);
                    }
                    previousStringLength = strLen;
                    previousStringIndex = strIndex;
                    ++i;
                }
                if (previousStringLength >= 4) {
                    this.fStringLengthsTable.addElement(previousStringIndex);
                    this.fStringLengthsTable.addElement(previousStringLength);
                }
                int range = 0;
                while (range < this.fKeySet.getRangeCount()) {
                    int keyChar = this.fKeySet.getRangeStart(range);
                    while (keyChar <= this.fKeySet.getRangeEnd(range)) {
                        this.addKeyEntry(keyChar, this.fSLTable, 0x1000000);
                        this.addKeyEntry(keyChar, this.fSATable, 0x2000000);
                        this.addKeyEntry(keyChar, this.fMLTable, 0x4000000);
                        this.addKeyEntry(keyChar, this.fMATable, 0x8000000);
                        ++keyChar;
                    }
                    ++range;
                }
                this.outputData();
            }

            void addKeyEntry(int keyChar, Hashtable<Integer, SPUString> table, int tableFlag) {
                int adjustedMappingLength;
                SPUString targetMapping = table.get(keyChar);
                if (targetMapping == null) {
                    return;
                }
                boolean keyHasMultipleValues = false;
                int i = this.fKeyVec.size() - 1;
                while (i >= 0) {
                    int key = this.fKeyVec.elementAt(i);
                    if ((key & 0xFFFFFF) != keyChar) break;
                    String mapping = this.getMapping(i);
                    if (mapping.equals(targetMapping.fStr)) {
                        this.fKeyVec.setElementAt(key |= tableFlag, i);
                        return;
                    }
                    keyHasMultipleValues = true;
                    --i;
                }
                int newKey = keyChar | tableFlag;
                if (keyHasMultipleValues) {
                    newKey |= 0x10000000;
                }
                if ((adjustedMappingLength = targetMapping.fStr.length() - 1) > 3) {
                    adjustedMappingLength = 3;
                }
                int newData = targetMapping.fStrTableIndex;
                this.fKeyVec.addElement(newKey |= adjustedMappingLength << 29);
                this.fValueVec.addElement(newData);
                if (keyHasMultipleValues) {
                    int previousKeyIndex = this.fKeyVec.size() - 2;
                    int previousKey = this.fKeyVec.elementAt(previousKeyIndex);
                    this.fKeyVec.setElementAt(previousKey |= 0x10000000, previousKeyIndex);
                }
            }

            String getMapping(int index) {
                int key = this.fKeyVec.elementAt(index);
                int value = this.fValueVec.elementAt(index);
                int length = SpoofChecker.getKeyLength(key);
                switch (length) {
                    case 0: {
                        char[] cs = new char[]{(char)value};
                        return new String(cs);
                    }
                    case 1: 
                    case 2: {
                        return this.fStringTable.substring(value, value + length + 1);
                    }
                    case 3: {
                        length = 0;
                        int i = 0;
                        while (i < this.fStringLengthsTable.size()) {
                            int lastIndexWithLen = this.fStringLengthsTable.elementAt(i);
                            if (value <= lastIndexWithLen) {
                                length = this.fStringLengthsTable.elementAt(i + 1);
                                break;
                            }
                            i += 2;
                        }
                        assert (length >= 3);
                        return this.fStringTable.substring(value, value + length);
                    }
                }
                assert (false);
                return "";
            }

            void outputData() throws IOException {
                SpoofDataHeader rawData = this.fSpoofData.fRawData;
                int numKeys = this.fKeyVec.size();
                int previousKey = 0;
                rawData.output(this.os);
                rawData.fCFUKeys = this.os.size();
                assert (rawData.fCFUKeys == 128);
                rawData.fCFUKeysSize = numKeys;
                int i = 0;
                while (i < numKeys) {
                    int key = this.fKeyVec.elementAt(i);
                    assert ((key & 0xFFFFFF) >= (previousKey & 0xFFFFFF));
                    assert ((key & 0xFF000000) != 0);
                    this.os.writeInt(key);
                    previousKey = key;
                    ++i;
                }
                int numValues = this.fValueVec.size();
                assert (numKeys == numValues);
                rawData.fCFUStringIndex = this.os.size();
                rawData.fCFUStringIndexSize = numValues;
                i = 0;
                while (i < numValues) {
                    int value = this.fValueVec.elementAt(i);
                    assert (value < 65535);
                    this.os.writeShort((short)value);
                    ++i;
                }
                int stringsLength = this.fStringTable.length();
                String strings = this.fStringTable.toString();
                rawData.fCFUStringTable = this.os.size();
                rawData.fCFUStringTableLen = stringsLength;
                i = 0;
                while (i < stringsLength) {
                    this.os.writeChar(strings.charAt(i));
                    ++i;
                }
                int lengthTableLength = this.fStringLengthsTable.size();
                int previousLength = 0;
                rawData.fCFUStringLengthsSize = lengthTableLength / 2;
                rawData.fCFUStringLengths = this.os.size();
                i = 0;
                while (i < lengthTableLength) {
                    int offset = this.fStringLengthsTable.elementAt(i);
                    int length = this.fStringLengthsTable.elementAt(i + 1);
                    assert (offset < stringsLength);
                    assert (length < 40);
                    assert (length > previousLength);
                    this.os.writeShort((short)offset);
                    this.os.writeShort((short)length);
                    previousLength = length;
                    i += 2;
                }
                this.os.flush();
                DataInputStream is = new DataInputStream(new ByteArrayInputStream(this.bos.toByteArray()));
                is.mark(Integer.MAX_VALUE);
                this.fSpoofData.initPtrs(is);
            }

            public static void buildConfusableData(SpoofData spData, Reader confusables) throws IOException, ParseException {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ConfusabledataBuilder builder = new ConfusabledataBuilder(spData, bos);
                builder.build(confusables);
            }

            private static class SPUString {
                String fStr;
                int fStrTableIndex;

                SPUString(String s) {
                    this.fStr = s;
                    this.fStrTableIndex = 0;
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            private static class SPUStringComparator
            implements Comparator<SPUString> {
                private SPUStringComparator() {
                }

                @Override
                public int compare(SPUString sL, SPUString sR) {
                    int lenR;
                    int lenL = sL.fStr.length();
                    if (lenL < (lenR = sR.fStr.length())) {
                        return -1;
                    }
                    if (lenL > lenR) {
                        return 1;
                    }
                    return sL.fStr.compareTo(sR.fStr);
                }
            }

            private static class SPUStringPool {
                private Vector<SPUString> fVec = new Vector();
                private Hashtable<String, SPUString> fHash = new Hashtable();

                public int size() {
                    return this.fVec.size();
                }

                public SPUString getByIndex(int index) {
                    SPUString retString = this.fVec.elementAt(index);
                    return retString;
                }

                public SPUString addString(String src) {
                    SPUString hashedString = this.fHash.get(src);
                    if (hashedString == null) {
                        hashedString = new SPUString(src);
                        this.fHash.put(src, hashedString);
                        this.fVec.addElement(hashedString);
                    }
                    return hashedString;
                }

                public void sort() {
                    Collections.sort(this.fVec, new SPUStringComparator());
                }
            }
        }

        private static class WSConfusableDataBuilder {
            static String parseExp = "(?m)^([ \\t]*(?:#.*?)?)$|^(?:\\s*([0-9A-F]{4,})(?:..([0-9A-F]{4,}))?\\s*;\\s*([A-Za-z]+)\\s*;\\s*([A-Za-z]+)\\s*;\\s*(?:(A)|(L))[ \\t]*(?:#.*?)?)$|^(.*?)$";

            private WSConfusableDataBuilder() {
            }

            static void readWholeFileToString(Reader reader, StringBuffer buffer) throws IOException {
                String line;
                LineNumberReader lnr = new LineNumberReader(reader);
                while ((line = lnr.readLine()) != null) {
                    buffer.append(line);
                    buffer.append('\n');
                }
            }

            static void buildWSConfusableData(SpoofData fSpoofData, DataOutputStream os, Reader confusablesWS) throws ParseException, IOException {
                Pattern parseRegexp = null;
                StringBuffer input = new StringBuffer();
                int lineNum = 0;
                Vector<BuilderScriptSet> scriptSets = null;
                int rtScriptSetsCount = 2;
                Trie2Writable anyCaseTrie = new Trie2Writable(0, 0);
                Trie2Writable lowerCaseTrie = new Trie2Writable(0, 0);
                scriptSets = new Vector<BuilderScriptSet>();
                scriptSets.addElement(null);
                scriptSets.addElement(null);
                WSConfusableDataBuilder.readWholeFileToString(confusablesWS, input);
                parseRegexp = Pattern.compile(parseExp);
                if (input.charAt(0) == '\ufeff') {
                    input.setCharAt(0, ' ');
                }
                Matcher matcher = parseRegexp.matcher(input);
                while (matcher.find()) {
                    ++lineNum;
                    if (matcher.start(1) >= 0) continue;
                    if (matcher.start(8) >= 0) {
                        throw new ParseException("ConfusablesWholeScript, line " + lineNum + ": Unrecognized input: " + matcher.group(), matcher.start());
                    }
                    int startCodePoint = Integer.parseInt(matcher.group(2), 16);
                    if (startCodePoint > 0x10FFFF) {
                        throw new ParseException("ConfusablesWholeScript, line " + lineNum + ": out of range code point: " + matcher.group(2), matcher.start(2));
                    }
                    int endCodePoint = startCodePoint;
                    if (matcher.start(3) >= 0) {
                        endCodePoint = Integer.parseInt(matcher.group(3), 16);
                    }
                    if (endCodePoint > 0x10FFFF) {
                        throw new ParseException("ConfusablesWholeScript, line " + lineNum + ": out of range code point: " + matcher.group(3), matcher.start(3));
                    }
                    String srcScriptName = matcher.group(4);
                    String targScriptName = matcher.group(5);
                    int srcScript = UCharacter.getPropertyValueEnum(4106, srcScriptName);
                    int targScript = UCharacter.getPropertyValueEnum(4106, targScriptName);
                    if (srcScript == -1) {
                        throw new ParseException("ConfusablesWholeScript, line " + lineNum + ": Invalid script code t: " + matcher.group(4), matcher.start(4));
                    }
                    if (targScript == -1) {
                        throw new ParseException("ConfusablesWholeScript, line " + lineNum + ": Invalid script code t: " + matcher.group(5), matcher.start(5));
                    }
                    Trie2Writable table = anyCaseTrie;
                    if (matcher.start(7) >= 0) {
                        table = lowerCaseTrie;
                    }
                    int cp = startCodePoint;
                    while (cp <= endCodePoint) {
                        int setIndex = table.get(cp);
                        BuilderScriptSet bsset = null;
                        if (setIndex > 0) {
                            assert (setIndex < scriptSets.size());
                            bsset = (BuilderScriptSet)scriptSets.elementAt(setIndex);
                        } else {
                            bsset = new BuilderScriptSet();
                            bsset.codePoint = cp;
                            bsset.trie = table;
                            bsset.sset = new ScriptSet();
                            bsset.index = setIndex = scriptSets.size();
                            bsset.rindex = 0;
                            scriptSets.addElement(bsset);
                            table.set(cp, setIndex);
                        }
                        bsset.sset.Union(targScript);
                        bsset.sset.Union(srcScript);
                        int cpScript = UScript.getScript(cp);
                        if (cpScript != srcScript) {
                            throw new ParseException("ConfusablesWholeScript, line " + lineNum + ": Mismatch between source script and code point " + Integer.toString(cp, 16), matcher.start(5));
                        }
                        ++cp;
                    }
                }
                rtScriptSetsCount = 2;
                int outeri = 2;
                while (outeri < scriptSets.size()) {
                    BuilderScriptSet outerSet = (BuilderScriptSet)scriptSets.elementAt(outeri);
                    if (outerSet.index == outeri) {
                        outerSet.rindex = rtScriptSetsCount++;
                        int inneri = outeri + 1;
                        while (inneri < scriptSets.size()) {
                            BuilderScriptSet innerSet = (BuilderScriptSet)scriptSets.elementAt(inneri);
                            if (outerSet.sset.equals(innerSet.sset) && outerSet.sset != innerSet.sset) {
                                innerSet.sset = outerSet.sset;
                                innerSet.index = outeri;
                                innerSet.rindex = outerSet.rindex;
                            }
                            ++inneri;
                        }
                    }
                    ++outeri;
                }
                int i = 2;
                while (i < scriptSets.size()) {
                    BuilderScriptSet bSet = (BuilderScriptSet)scriptSets.elementAt(i);
                    if (bSet.rindex != i) {
                        bSet.trie.set(bSet.codePoint, bSet.rindex);
                    }
                    ++i;
                }
                UnicodeSet ignoreSet = new UnicodeSet();
                ignoreSet.applyIntPropertyValue(4106, 0);
                UnicodeSet inheritedSet = new UnicodeSet();
                inheritedSet.applyIntPropertyValue(4106, 1);
                ignoreSet.addAll(inheritedSet);
                int rn = 0;
                while (rn < ignoreSet.getRangeCount()) {
                    int rangeStart = ignoreSet.getRangeStart(rn);
                    int rangeEnd = ignoreSet.getRangeEnd(rn);
                    anyCaseTrie.setRange(rangeStart, rangeEnd, 1, true);
                    lowerCaseTrie.setRange(rangeStart, rangeEnd, 1, true);
                    ++rn;
                }
                anyCaseTrie.toTrie2_16().serialize(os);
                lowerCaseTrie.toTrie2_16().serialize(os);
                fSpoofData.fRawData.fScriptSetsLength = rtScriptSetsCount;
                int rindex = 2;
                int i2 = 2;
                while (i2 < scriptSets.size()) {
                    BuilderScriptSet bSet = (BuilderScriptSet)scriptSets.elementAt(i2);
                    if (bSet.rindex >= rindex) {
                        assert (rindex == bSet.rindex);
                        bSet.sset.output(os);
                        ++rindex;
                    }
                    ++i2;
                }
            }

            private static class BuilderScriptSet {
                int codePoint = -1;
                Trie2Writable trie = null;
                ScriptSet sset = null;
                int index = 0;
                int rindex = 0;

                BuilderScriptSet() {
                }
            }
        }
    }

    public static class CheckResult {
        public int checks = 0;
        public int position = 0;
    }

    private static class ScriptSet {
        private int[] bits = new int[6];

        public ScriptSet() {
        }

        public ScriptSet(DataInputStream dis) throws IOException {
            int j = 0;
            while (j < this.bits.length) {
                this.bits[j] = dis.readInt();
                ++j;
            }
        }

        public void output(DataOutputStream os) throws IOException {
            int i = 0;
            while (i < this.bits.length) {
                os.writeInt(this.bits[i]);
                ++i;
            }
        }

        public boolean equals(ScriptSet other) {
            int i = 0;
            while (i < this.bits.length) {
                if (this.bits[i] != other.bits[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        public void Union(int script) {
            int index = script / 32;
            int bit = 1 << (script & 0x1F);
            assert (index < this.bits.length * 4 * 4);
            int n = index;
            this.bits[n] = this.bits[n] | bit;
        }

        public void Union(ScriptSet other) {
            int i = 0;
            while (i < this.bits.length) {
                int n = i;
                this.bits[n] = this.bits[n] | other.bits[i];
                ++i;
            }
        }

        public void intersect(ScriptSet other) {
            int i = 0;
            while (i < this.bits.length) {
                int n = i;
                this.bits[n] = this.bits[n] & other.bits[i];
                ++i;
            }
        }

        public void intersect(int script) {
            int index = script / 32;
            int bit = 1 << (script & 0x1F);
            assert (index < this.bits.length * 4 * 4);
            int i = 0;
            while (i < index) {
                this.bits[i] = 0;
                ++i;
            }
            int n = index;
            this.bits[n] = this.bits[n] & bit;
            i = index + 1;
            while (i < this.bits.length) {
                this.bits[i] = 0;
                ++i;
            }
        }

        public void setAll() {
            int i = 0;
            while (i < this.bits.length) {
                this.bits[i] = -1;
                ++i;
            }
        }

        public void resetAll() {
            int i = 0;
            while (i < this.bits.length) {
                this.bits[i] = 0;
                ++i;
            }
        }

        public int countMembers() {
            int count = 0;
            int i = 0;
            while (i < this.bits.length) {
                int x = this.bits[i];
                while (x > 0) {
                    ++count;
                    x &= x - 1;
                }
                ++i;
            }
            return count;
        }
    }

    private static class SpoofData {
        SpoofDataHeader fRawData;
        int[] fCFUKeys;
        short[] fCFUValues;
        SpoofStringLengthsElement[] fCFUStringLengths;
        char[] fCFUStrings;
        Trie2 fAnyCaseTrie;
        Trie2 fLowerCaseTrie;
        ScriptSet[] fScriptSets;

        public static SpoofData getDefault() throws IOException {
            InputStream is = ICUData.getRequiredStream("data/icudt50b/confusables.cfu");
            SpoofData This = new SpoofData(is);
            return This;
        }

        public SpoofData() {
            this.fRawData = new SpoofDataHeader();
            this.fRawData.fMagic = 944111087;
            this.fRawData.fFormatVersion[0] = 1;
            this.fRawData.fFormatVersion[1] = 0;
            this.fRawData.fFormatVersion[2] = 0;
            this.fRawData.fFormatVersion[3] = 0;
        }

        public SpoofData(InputStream is) throws IOException {
            DataInputStream dis = new DataInputStream(new BufferedInputStream(is));
            dis.skip(128L);
            assert (dis.markSupported());
            dis.mark(Integer.MAX_VALUE);
            this.fRawData = new SpoofDataHeader(dis);
            this.initPtrs(dis);
        }

        static boolean validateDataVersion(SpoofDataHeader rawData) {
            return rawData != null && rawData.fMagic == 944111087 && rawData.fFormatVersion[0] <= 1 && rawData.fFormatVersion[1] <= 0;
        }

        void initPtrs(DataInputStream dis) throws IOException {
            int i;
            this.fCFUKeys = null;
            this.fCFUValues = null;
            this.fCFUStringLengths = null;
            this.fCFUStrings = null;
            dis.reset();
            dis.skip(this.fRawData.fCFUKeys);
            if (this.fRawData.fCFUKeys != 0) {
                this.fCFUKeys = new int[this.fRawData.fCFUKeysSize];
                i = 0;
                while (i < this.fRawData.fCFUKeysSize) {
                    this.fCFUKeys[i] = dis.readInt();
                    ++i;
                }
            }
            dis.reset();
            dis.skip(this.fRawData.fCFUStringIndex);
            if (this.fRawData.fCFUStringIndex != 0) {
                this.fCFUValues = new short[this.fRawData.fCFUStringIndexSize];
                i = 0;
                while (i < this.fRawData.fCFUStringIndexSize) {
                    this.fCFUValues[i] = dis.readShort();
                    ++i;
                }
            }
            dis.reset();
            dis.skip(this.fRawData.fCFUStringTable);
            if (this.fRawData.fCFUStringTable != 0) {
                this.fCFUStrings = new char[this.fRawData.fCFUStringTableLen];
                i = 0;
                while (i < this.fRawData.fCFUStringTableLen) {
                    this.fCFUStrings[i] = dis.readChar();
                    ++i;
                }
            }
            dis.reset();
            dis.skip(this.fRawData.fCFUStringLengths);
            if (this.fRawData.fCFUStringLengths != 0) {
                this.fCFUStringLengths = new SpoofStringLengthsElement[this.fRawData.fCFUStringLengthsSize];
                i = 0;
                while (i < this.fRawData.fCFUStringLengthsSize) {
                    this.fCFUStringLengths[i] = new SpoofStringLengthsElement();
                    this.fCFUStringLengths[i].fLastString = dis.readShort();
                    this.fCFUStringLengths[i].fStrLength = dis.readShort();
                    ++i;
                }
            }
            dis.reset();
            dis.skip(this.fRawData.fAnyCaseTrie);
            if (this.fAnyCaseTrie == null && this.fRawData.fAnyCaseTrie != 0) {
                this.fAnyCaseTrie = Trie2.createFromSerialized(dis);
            }
            dis.reset();
            dis.skip(this.fRawData.fLowerCaseTrie);
            if (this.fLowerCaseTrie == null && this.fRawData.fLowerCaseTrie != 0) {
                this.fLowerCaseTrie = Trie2.createFromSerialized(dis);
            }
            dis.reset();
            dis.skip(this.fRawData.fScriptSets);
            if (this.fRawData.fScriptSets != 0) {
                this.fScriptSets = new ScriptSet[this.fRawData.fScriptSetsLength];
                i = 0;
                while (i < this.fRawData.fScriptSetsLength) {
                    this.fScriptSets[i] = new ScriptSet(dis);
                    ++i;
                }
            }
        }

        private static class SpoofStringLengthsElement {
            short fLastString;
            short fStrLength;

            private SpoofStringLengthsElement() {
            }
        }
    }

    private static class SpoofDataHeader {
        int fMagic;
        byte[] fFormatVersion = new byte[4];
        int fLength;
        int fCFUKeys;
        int fCFUKeysSize;
        int fCFUStringIndex;
        int fCFUStringIndexSize;
        int fCFUStringTable;
        int fCFUStringTableLen;
        int fCFUStringLengths;
        int fCFUStringLengthsSize;
        int fAnyCaseTrie;
        int fAnyCaseTrieLength;
        int fLowerCaseTrie;
        int fLowerCaseTrieLength;
        int fScriptSets;
        int fScriptSetsLength;
        int[] unused = new int[15];

        public SpoofDataHeader() {
        }

        public SpoofDataHeader(DataInputStream dis) throws IOException {
            this.fMagic = dis.readInt();
            int i = 0;
            while (i < this.fFormatVersion.length) {
                this.fFormatVersion[i] = dis.readByte();
                ++i;
            }
            this.fLength = dis.readInt();
            this.fCFUKeys = dis.readInt();
            this.fCFUKeysSize = dis.readInt();
            this.fCFUStringIndex = dis.readInt();
            this.fCFUStringIndexSize = dis.readInt();
            this.fCFUStringTable = dis.readInt();
            this.fCFUStringTableLen = dis.readInt();
            this.fCFUStringLengths = dis.readInt();
            this.fCFUStringLengthsSize = dis.readInt();
            this.fAnyCaseTrie = dis.readInt();
            this.fAnyCaseTrieLength = dis.readInt();
            this.fLowerCaseTrie = dis.readInt();
            this.fLowerCaseTrieLength = dis.readInt();
            this.fScriptSets = dis.readInt();
            this.fScriptSetsLength = dis.readInt();
            i = 0;
            while (i < this.unused.length) {
                this.unused[i] = dis.readInt();
                ++i;
            }
        }

        public void output(DataOutputStream os) throws IOException {
            os.writeInt(this.fMagic);
            int i = 0;
            while (i < this.fFormatVersion.length) {
                os.writeByte(this.fFormatVersion[i]);
                ++i;
            }
            os.writeInt(this.fLength);
            os.writeInt(this.fCFUKeys);
            os.writeInt(this.fCFUKeysSize);
            os.writeInt(this.fCFUStringIndex);
            os.writeInt(this.fCFUStringIndexSize);
            os.writeInt(this.fCFUStringTable);
            os.writeInt(this.fCFUStringTableLen);
            os.writeInt(this.fCFUStringLengths);
            os.writeInt(this.fCFUStringLengthsSize);
            os.writeInt(this.fAnyCaseTrie);
            os.writeInt(this.fAnyCaseTrieLength);
            os.writeInt(this.fLowerCaseTrie);
            os.writeInt(this.fLowerCaseTrieLength);
            os.writeInt(this.fScriptSets);
            os.writeInt(this.fScriptSetsLength);
            i = 0;
            while (i < this.unused.length) {
                os.writeInt(this.unused[i]);
                ++i;
            }
        }
    }
}

