/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.swt.properties.custom;

import org.eclipse.e4.ui.css.core.dom.properties.ICSSPropertyHandler;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.swt.properties.AbstractCSSPropertySWTHandler;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.w3c.dom.css.CSSValue;

public class CSSPropertyAlignmentSWTHandler
extends AbstractCSSPropertySWTHandler {
    public static final ICSSPropertyHandler INSTANCE = new CSSPropertyAlignmentSWTHandler();

    public void applyCSSProperty(Control control, String property, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        if (control instanceof Button) {
            Button button = (Button)control;
            String stringValue = value.getCssText().toLowerCase();
            if ("left".equals(stringValue)) {
                button.setAlignment(16384);
            } else if ("lead".equals(stringValue)) {
                button.setAlignment(16384);
            } else if ("right".equals(stringValue)) {
                button.setAlignment(131072);
            } else if ("trail".equals(stringValue)) {
                button.setAlignment(131072);
            } else if ("center".equals(stringValue)) {
                button.setAlignment(0x1000000);
            } else if ("up".equals(stringValue)) {
                button.setAlignment(128);
            } else if ("down".equals(stringValue)) {
                button.setAlignment(1024);
            } else {
                "inherit".equals(stringValue);
            }
        } else if (control instanceof Label) {
            Label label = (Label)control;
            String stringValue = value.getCssText().toLowerCase();
            if ("left".equals(stringValue)) {
                label.setAlignment(16384);
            } else if ("lead".equals(stringValue)) {
                label.setAlignment(16384);
            } else if ("right".equals(stringValue)) {
                label.setAlignment(131072);
            } else if ("trail".equals(stringValue)) {
                label.setAlignment(131072);
            } else if ("center".equals(stringValue)) {
                label.setAlignment(0x1000000);
            } else {
                "inherit".equals(stringValue);
            }
        }
    }

    public String retrieveCSSProperty(Control control, String property, String pseudo, CSSEngine engine) throws Exception {
        if (control instanceof Button) {
            Button button = (Button)control;
            switch (button.getAlignment()) {
                case 131072: {
                    return "right";
                }
                case 16384: {
                    return "left";
                }
                case 0x1000000: {
                    return "center";
                }
                case 128: {
                    return "up";
                }
                case 1024: {
                    return "down";
                }
            }
        } else if (control instanceof Label) {
            Label label = (Label)control;
            switch (label.getAlignment()) {
                case 131072: {
                    return "right";
                }
                case 16384: {
                    return "left";
                }
                case 0x1000000: {
                    return "center";
                }
            }
        }
        return null;
    }
}

