/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.mycbr.gui.casebase.list;

import de.dfki.mycbr.core.ICaseBase;
import de.dfki.mycbr.gui.casebase.list.CasebaseListView;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.dialogs.ListDialog;

public class ChangeCaseBaseAction
extends Action
implements ActionFactory.IWorkbenchAction {
    public static final String ID = "de.dfki.mycbr.gui.casebase.list.ChangeCaseBaseAction";
    private CasebaseListView view;

    public ChangeCaseBaseAction(CasebaseListView view) {
        this.view = view;
        this.setId(ID);
    }

    public void run() {
        final Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        if (this.view.getCurrentProject() == null) {
            MessageDialog messageDialog = new MessageDialog(shell, "No project selected!", null, "Please select the project you want to change the case base for.", 2, new String[]{"Ok"}, 0);
            messageDialog.open();
        } else {
            ListDialog ld = new ListDialog(shell){

                protected void createButtonsForButtonBar(Composite parent) {
                    this.createButton(parent, 7, "Delete", false);
                    super.createButtonsForButtonBar(parent);
                }

                protected void buttonPressed(int buttonId) {
                    if (buttonId == 7) {
                        if (this.getTableViewer().getTable().getItemCount() == 1) {
                            new MessageDialog(shell, "Cannot delete last casebase.", null, "It is not possible to delete the last case base.", 4, new String[]{"Ok"}, 0).open();
                        } else {
                            IStructuredSelection selection = (IStructuredSelection)this.getTableViewer().getSelection();
                            ICaseBase caseBase = (ICaseBase)selection.getFirstElement();
                            ChangeCaseBaseAction.this.view.getCurrentProject().deleteCaseBase(caseBase.getName());
                            this.getTableViewer().remove((Object)caseBase);
                            try {
                                if (!ChangeCaseBaseAction.this.view.getCurrentProject().getName().endsWith("_UNSAFED")) {
                                    ChangeCaseBaseAction.this.view.getCurrentProject().setName(String.valueOf(ChangeCaseBaseAction.this.view.getCurrentProject().getName()) + "_UNSAFED");
                                }
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                    } else {
                        super.buttonPressed(buttonId);
                    }
                }
            };
            ld.setAddCancelButton(true);
            ld.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
            ld.setLabelProvider((ILabelProvider)new LabelProvider(){

                public String getText(Object obj) {
                    return ((ICaseBase)obj).getName();
                }
            });
            ld.setInput((Object)this.view.getCurrentProject().getCaseBases().values().toArray());
            ld.setTitle("Select the casebase to load:");
            ld.open();
            if (ld.getResult() != null) {
                ICaseBase caseBase = (ICaseBase)ld.getResult()[0];
                this.view.refresh(caseBase.getName());
            }
        }
    }

    public void dispose() {
    }
}

