/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.mycbr.gui.concept.editor;

import de.dfki.mycbr.core.Project;
import de.dfki.mycbr.core.model.Concept;
import de.dfki.mycbr.gui.concept.editor.ConceptFormEditor;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.handlers.IHandlerService;

public class GeneralPage
extends FormPage {
    public static final String ID = "de.dfki.mycbr.gui.concept.editor.GeneralPage";
    private Concept concept;
    private FormToolkit toolkit;
    private ScrolledForm form;
    private Text txtName;
    private ControlDecoration cdName;
    private boolean isProject;
    private Text txtAuthor;

    public GeneralPage(FormEditor editor) {
        super(editor, ID, "Concept");
        this.concept = ((ConceptFormEditor)editor).getConcept();
        if (this.concept instanceof Project) {
            this.isProject = true;
            this.setPartName("Project");
        } else {
            this.isProject = false;
        }
    }

    protected void createFormContent(IManagedForm managedForm) {
        this.toolkit = managedForm.getToolkit();
        this.form = managedForm.getForm();
        this.form.setExpandHorizontal(true);
        this.form.setExpandVertical(true);
        if (this.isProject) {
            this.form.setText("Project");
        } else {
            this.form.setText("Concept");
        }
        this.createUi();
        this.fillModel();
        this.addUpdateOnChangeListeners();
        this.form.reflow(true);
    }

    private void createUi() {
        GridLayoutFactory.fillDefaults().margins(5, 5).spacing(5, 3).numColumns(2).applyTo(this.form.getBody());
        this.toolkit.createLabel(this.form.getBody(), "Name:");
        this.txtName = this.toolkit.createText(this.form.getBody(), "", 2048);
        this.cdName = new ControlDecoration((Control)this.txtName, 16512);
        FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
        this.cdName.setDescriptionText("There is another concept with that name.");
        this.cdName.setImage(fieldDecoration.getImage());
        this.cdName.hide();
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.txtName);
        if (this.isProject) {
            this.toolkit.createLabel(this.form.getBody(), "Author:");
            this.txtAuthor = this.toolkit.createText(this.form.getBody(), "");
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.txtAuthor);
        }
    }

    private void fillModel() {
        this.txtName.setText(this.concept.getName());
        if (this.isProject) {
            this.txtAuthor.setText(((Project)this.concept).getAuthor());
        }
    }

    private void addUpdateOnChangeListeners() {
        this.txtName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GeneralPage.this.cdName.hide();
                if (!GeneralPage.this.concept.getName().equals(GeneralPage.this.txtName.getText())) {
                    try {
                        GeneralPage.this.concept.setName(GeneralPage.this.txtName.getText());
                        GeneralPage.this.setPartName(GeneralPage.this.concept.getName());
                        IHandlerService handlerService = (IHandlerService)GeneralPage.this.getSite().getService(IHandlerService.class);
                        try {
                            handlerService.executeCommand("de.dfki.mycbr.gui.project.list.ProjectListRefreshHandler", null);
                        }
                        catch (Exception exception) {
                            throw new RuntimeException("de.dfki.mycbr.gui.project.list.ProjectListRefreshHandler not found");
                        }
                    }
                    catch (Exception exception) {
                        GeneralPage.this.cdName.show();
                    }
                    try {
                        if (!GeneralPage.this.concept.getProject().getName().endsWith("_UNSAFED")) {
                            GeneralPage.this.concept.getProject().setName(String.valueOf(GeneralPage.this.concept.getProject().getName()) + "_UNSAFED");
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        if (this.isProject) {
            this.txtAuthor.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ((Project)GeneralPage.this.concept).setAuthor(GeneralPage.this.txtAuthor.getText());
                    try {
                        if (!GeneralPage.this.concept.getProject().getName().endsWith("_UNSAFED")) {
                            GeneralPage.this.concept.getProject().setName(String.valueOf(GeneralPage.this.concept.getProject().getName()) + "_UNSAFED");
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
        }
    }

    public boolean isDirty() {
        return false;
    }

    public void setFocus() {
        this.form.setFocus();
    }

    public void dispose() {
        this.toolkit.dispose();
        super.dispose();
    }
}

