/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.mycbr.gui.csvimporter.wizard;

import de.dfki.mycbr.core.model.Concept;
import de.dfki.mycbr.gui.csvimporter.wizard.FilePage;
import de.dfki.mycbr.gui.csvimporter.wizard.SettingsPage;
import de.dfki.mycbr.io.CSVImporter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class CSVImporterWizard
extends Wizard {
    private Concept concept;

    public CSVImporterWizard(Concept concept) {
        this.setNeedsProgressMonitor(true);
        this.concept = concept;
    }

    public void addPages() {
        this.addPage((IWizardPage)new FilePage(this.concept));
        this.addPage((IWizardPage)new SettingsPage(this.concept));
    }

    public boolean performFinish() {
        FilePage filePage = (FilePage)this.getPage("File");
        SettingsPage settingsPage = (SettingsPage)this.getPage("Settings");
        CSVImporter importer = filePage.getImporter();
        importer.readData();
        importer.checkData();
        importer.setCreateMissingDesc(settingsPage.getCreateMissingDesc());
        importer.setChangeDescOnMissingValues(settingsPage.getCreateMissingValues());
        importer.setSpecialAttForMissingValues(settingsPage.getSpecialAtt());
        if (settingsPage.getCasebase() != null) {
            importer.setCaseBase(this.concept.getProject().getCB(settingsPage.getCasebase()));
        }
        importer.addMissingDescriptions();
        importer.addMissingValues();
        importer.doImport();
        return true;
    }
}

