/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.mycbr.gui.ie.lod.wizard;

import de.dfki.mycbr.gui.ie.TaxonomyExtractor;
import de.dfki.mycbr.gui.misc.GenericTreeNode;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TreeItem;

public class CategoriesPage
extends WizardPage {
    public static final String PAGE_NAME = "Categories";
    private TreeViewer trvCategories;
    private TaxonomyExtractor taxExctractor;

    public CategoriesPage(TaxonomyExtractor taxExctractor) {
        super(PAGE_NAME, "Categories page", null);
        this.setDescription("Please check the categories you would like to import into the attribute description.");
        this.taxExctractor = taxExctractor;
    }

    public void createControl(Composite container) {
        Composite parent = new Composite(container, 0);
        Label lblCategories = new Label(parent, 0);
        lblCategories.setText("Choose the categories you want to include:");
        this.trvCategories = new TreeViewer(parent, 2848);
        this.trvCategories.getTree().setLinesVisible(true);
        this.trvCategories.setContentProvider((IContentProvider)new CategoriesContentProvider());
        this.trvCategories.setInput(this.taxExctractor.collectCategories());
        this.trvCategories.getTree().addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 32) {
                    TreeItem item = (TreeItem)event.item;
                    boolean checked = item.getChecked();
                    CategoriesPage.this.checkItems(item, checked);
                    CategoriesPage.this.checkPath(item.getParentItem(), checked, true);
                }
            }
        });
        this.trvCategories.expandAll();
        GridLayoutFactory.fillDefaults().margins(5, 5).spacing(5, 3).numColumns(3).applyTo(parent);
        GridDataFactory.fillDefaults().align(4, 128).span(3, 1).applyTo((Control)lblCategories);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, true).span(3, 1).applyTo((Control)this.trvCategories.getTree());
        this.setControl((Control)parent);
    }

    void checkPath(TreeItem item, boolean checked, boolean grayed) {
        if (item == null) {
            return;
        }
        if (grayed) {
            checked = true;
        } else {
            int index = 0;
            TreeItem[] items = item.getItems();
            while (index < items.length) {
                TreeItem child = items[index];
                if (child.getGrayed() || checked != child.getChecked()) {
                    grayed = true;
                    checked = true;
                    break;
                }
                ++index;
            }
        }
        item.setChecked(checked);
        item.setGrayed(grayed);
        if (checked) {
            this.taxExctractor.addWantedCategory(item.getText());
        } else {
            this.taxExctractor.removeWantedCategory(item.getText());
        }
        this.checkPath(item.getParentItem(), checked, grayed);
    }

    void checkItems(TreeItem item, boolean checked) {
        item.setGrayed(false);
        item.setChecked(checked);
        if (checked) {
            this.taxExctractor.addWantedCategory(item.getText());
        } else {
            this.taxExctractor.removeWantedCategory(item.getText());
        }
        TreeItem[] items = item.getItems();
        int i = 0;
        while (i < items.length) {
            this.checkItems(items[i], checked);
            ++i;
        }
    }

    public class CategoriesContentProvider
    implements ITreeContentProvider {
        public Object[] getChildren(Object parent) {
            GenericTreeNode node = (GenericTreeNode)parent;
            return node.getChildren().toArray();
        }

        public Object getParent(Object element) {
            GenericTreeNode node = (GenericTreeNode)element;
            return node.getParent();
        }

        public boolean hasChildren(Object element) {
            GenericTreeNode node = (GenericTreeNode)element;
            return node.hasChildren();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            GenericTreeNode node = (GenericTreeNode)inputElement;
            return node.getChildren().toArray();
        }
    }
}

