/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.mycbr.gui.misc;

import de.dfki.mycbr.core.Project;
import de.dfki.mycbr.core.model.AttributeDesc;
import de.dfki.mycbr.core.model.Concept;
import de.dfki.mycbr.gui.Properties;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class MyCbrInterface {
    private List<Project> projects = new ArrayList<Project>();
    private List<String> projectPaths = new ArrayList<String>();

    private MyCbrInterface() {
    }

    public static MyCbrInterface getInstance() {
        return MyCbrInterfaceHolder.INSTANCE;
    }

    public List<Project> getProjects() {
        return this.projects;
    }

    public Project load(String filename) {
        if (this.isAlreadyOpen(filename)) {
            return null;
        }
        try {
            Project project = new Project(filename);
            this.projects.add(project);
            this.projectPaths.add(filename);
            if (!Properties.getInstance().hasRecentProject(filename)) {
                Properties.getInstance().addRecentProject(filename);
            }
            return project;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean isAlreadyOpen(String filename) {
        for (String prjPath : this.projectPaths) {
            if (!prjPath.equals(filename)) continue;
            return true;
        }
        return false;
    }

    public boolean projectExists(String name) {
        for (Project prj : this.projects) {
            if (!prj.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public Project create(String filename) {
        if (filename.endsWith(".zip") || filename.endsWith(".prj")) {
            filename = filename.substring(0, filename.lastIndexOf(46));
        }
        File file = new File(filename);
        try {
            Project project = new Project();
            project.setName(file.getName());
            project.setPath(String.valueOf(file.getParent()) + "/");
            project.save();
            this.projects.add(project);
            this.projectPaths.add(filename);
            return project;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void close(Project project) {
        int index = this.projects.indexOf(project);
        this.projects.remove(index);
        this.projectPaths.remove(index);
    }

    public boolean isOpened(Project project) {
        return this.projects.contains(project);
    }

    public boolean conceptExists(Concept concept) {
        for (Project prj : this.projects) {
            if (!prj.getAllSubConcepts().containsValue(concept)) continue;
            return true;
        }
        return false;
    }

    public boolean attributeDescExists(AttributeDesc attrDesc) {
        for (Project prj : this.projects) {
            if (!prj.getAllAttributeDescs().containsValue(attrDesc)) continue;
            return true;
        }
        return false;
    }

    /* synthetic */ MyCbrInterface(MyCbrInterface myCbrInterface) {
        this();
    }

    private static class MyCbrInterfaceHolder {
        private static final MyCbrInterface INSTANCE = new MyCbrInterface(null);

        private MyCbrInterfaceHolder() {
        }
    }
}

