/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.mycbr.gui.project.list;

import de.dfki.mycbr.core.ICaseBase;
import de.dfki.mycbr.core.Project;
import de.dfki.mycbr.core.model.AttributeDesc;
import de.dfki.mycbr.core.model.BooleanDesc;
import de.dfki.mycbr.core.model.Concept;
import de.dfki.mycbr.core.model.ConceptDesc;
import de.dfki.mycbr.core.model.DateDesc;
import de.dfki.mycbr.core.model.DoubleDesc;
import de.dfki.mycbr.core.model.FloatDesc;
import de.dfki.mycbr.core.model.IntegerDesc;
import de.dfki.mycbr.core.model.IntervalDesc;
import de.dfki.mycbr.core.model.StringDesc;
import de.dfki.mycbr.core.model.SymbolDesc;
import de.dfki.mycbr.gui.misc.ListUtil;
import de.dfki.mycbr.gui.misc.MyCbrInterface;
import de.dfki.mycbr.gui.misc.OverlayImageIcon;
import de.dfki.mycbr.gui.plugin.Activator;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;

public class ProjectListView
extends ViewPart {
    public static final String ID = "de.dfki.mycbr.gui.project.list.ProjectListView";
    private TreeViewer treeViewer;

    public void createPartControl(Composite parent) {
        this.treeViewer = new TreeViewer(parent, 772);
        this.treeViewer.setContentProvider((IContentProvider)new ConceptTreeContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new ConceptTreeLabelProvider());
        this.treeViewer.setInput(MyCbrInterface.getInstance().getProjects());
        this.getSite().setSelectionProvider((ISelectionProvider)this.treeViewer);
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection ss = (IStructuredSelection)event.getSelection();
                Object o = ss.getFirstElement();
                IHandlerService handlerService = (IHandlerService)ProjectListView.this.getSite().getService(IHandlerService.class);
                if (o instanceof Concept) {
                    handlerService = (IHandlerService)ProjectListView.this.getSite().getService(IHandlerService.class);
                    try {
                        handlerService.executeCommand("de.dfki.mycbr.gui.concept.editor.CallConceptEditor", null);
                    }
                    catch (Exception exception) {
                        throw new RuntimeException("de.dfki.mycbr.gui.concept.editor.CallConceptEditor not found");
                    }
                }
                if (o instanceof AttributeDesc) {
                    handlerService = (IHandlerService)ProjectListView.this.getSite().getService(IHandlerService.class);
                    try {
                        handlerService.executeCommand("de.dfki.mycbr.gui.attribute.editor.CallAttributeEditor", null);
                    }
                    catch (Exception exception) {
                        throw new RuntimeException("de.dfki.mycbr.gui.attribute.editor.CallAttributeEditor not found");
                    }
                }
            }
        });
        MenuManager menuManager = new MenuManager();
        menuManager.add((IContributionItem)new Separator("additions"));
        this.treeViewer.getTree().setMenu(menuManager.createContextMenu((Control)this.treeViewer.getTree()));
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.treeViewer);
        this.dragAndDrop();
    }

    private void dragAndDrop() {
        Transfer[] transfers = new Transfer[]{TextTransfer.getInstance()};
        this.treeViewer.addDragSupport(2, transfers, new DragSourceListener(){

            public void dragFinished(DragSourceEvent event) {
            }

            public void dragSetData(DragSourceEvent event) {
                IStructuredSelection selection = (IStructuredSelection)ProjectListView.this.treeViewer.getSelection();
                Object obj = selection.getFirstElement();
                String s = null;
                if (obj instanceof AttributeDesc) {
                    AttributeDesc desc = (AttributeDesc)obj;
                    s = desc.getName();
                }
                event.data = s;
            }

            public void dragStart(DragSourceEvent event) {
            }
        });
        this.treeViewer.addDropSupport(2, transfers, (DropTargetListener)new ViewerDropAdapter((Viewer)this.treeViewer){

            public boolean performDrop(Object data) {
                Concept targetConcept = null;
                if (this.getCurrentTarget() instanceof Concept) {
                    targetConcept = (Concept)this.getCurrentTarget();
                }
                if (targetConcept == null) {
                    return false;
                }
                String dropStr = (String)data;
                AttributeDesc dropAttribute = this.findAttributeDesc(dropStr);
                if (dropAttribute == null) {
                    return false;
                }
                try {
                    dropAttribute.setOwner(targetConcept);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    if (!targetConcept.getProject().getName().endsWith("_UNSAFED")) {
                        targetConcept.getProject().setName(String.valueOf(targetConcept.getProject().getName()) + "_UNSAFED");
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                ProjectListView.this.treeViewer.refresh();
                return true;
            }

            private AttributeDesc findAttributeDesc(String name) {
                for (Project p : MyCbrInterface.getInstance().getProjects()) {
                    for (Concept c : p.getAllSubConcepts().values()) {
                        for (AttributeDesc a : c.getAllAttributeDescs().values()) {
                            if (!a.getName().equals(name)) continue;
                            return a;
                        }
                    }
                }
                return null;
            }

            public boolean validateDrop(Object target, int operation, TransferData transferType) {
                return true;
            }
        });
    }

    public void setFocus() {
        this.treeViewer.getControl().setFocus();
    }

    public void refresh() {
        this.treeViewer.refresh();
        this.treeViewer.setSelection(this.treeViewer.getSelection());
    }

    class ConceptTreeContentProvider
    implements ITreeContentProvider {
        ConceptTreeContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof Project) {
                Project project = (Project)parentElement;
                Object[] res = project.getSubConcepts().values().toArray();
                return res;
            }
            if (parentElement instanceof Concept) {
                Concept concept = (Concept)parentElement;
                ArrayList<Object> children = new ArrayList<Object>();
                children.addAll(ListUtil.sortConcepts(concept.getAllSubConcepts().values()));
                children.addAll(ListUtil.sortAttributeDescs(concept.getAttributeDescs().values()));
                return children.toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof Concept) {
                Concept concept = (Concept)element;
                return concept.getSuperConcept();
            }
            if (element instanceof AttributeDesc) {
                AttributeDesc attribute = (AttributeDesc)element;
                return attribute.getOwner();
            }
            if (element instanceof ICaseBase) {
                return ((ICaseBase)element).getProject();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof Project) {
                return true;
            }
            if (element instanceof Concept) {
                Concept concept = (Concept)element;
                return !concept.getAllSubConcepts().isEmpty() || !concept.getAttributeDescs().isEmpty();
            }
            return false;
        }

        public Object[] getElements(Object inputElement) {
            Collection projects = (Collection)inputElement;
            return projects.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class ConceptTreeLabelProvider
    extends LabelProvider {
        ConceptTreeLabelProvider() {
        }

        public String getText(Object obj) {
            String columnText = null;
            if (obj instanceof Project) {
                Project project = (Project)obj;
                columnText = project.getName();
            } else if (obj instanceof Concept) {
                Concept concept = (Concept)obj;
                columnText = concept.getName();
            } else if (obj instanceof AttributeDesc) {
                AttributeDesc attribute = (AttributeDesc)obj;
                columnText = attribute.getName();
            } else if (obj instanceof ICaseBase) {
                ICaseBase cb = (ICaseBase)obj;
                columnText = cb.getName();
            }
            return columnText;
        }

        public Image getImage(Object obj) {
            if (obj instanceof Project || obj instanceof ICaseBase) {
                return Activator.getDefault().getImageRegistry().get("projectIcon");
            }
            if (obj instanceof Concept) {
                return Activator.getDefault().getImageRegistry().get("conceptIcon");
            }
            if (obj instanceof AttributeDesc) {
                Image image = Activator.getDefault().getImageRegistry().get("attributeIcon");
                AttributeDesc attrDesc = (AttributeDesc)obj;
                if (attrDesc instanceof BooleanDesc) {
                    image = new OverlayImageIcon(image, Activator.getDefault().getImageRegistry().get("attrBooleanDecorator")).createImage();
                } else if (attrDesc instanceof SymbolDesc) {
                    image = new OverlayImageIcon(image, Activator.getDefault().getImageRegistry().get("attrSymbolDecorator")).createImage();
                } else if (attrDesc instanceof IntegerDesc) {
                    image = new OverlayImageIcon(image, Activator.getDefault().getImageRegistry().get("attrIntegerDecorator")).createImage();
                } else if (attrDesc instanceof FloatDesc) {
                    image = new OverlayImageIcon(image, Activator.getDefault().getImageRegistry().get("attrFloatDecorator")).createImage();
                } else if (attrDesc instanceof DoubleDesc) {
                    image = new OverlayImageIcon(image, Activator.getDefault().getImageRegistry().get("attrDoubleDecorator")).createImage();
                } else if (attrDesc instanceof StringDesc) {
                    image = new OverlayImageIcon(image, Activator.getDefault().getImageRegistry().get("attrStringDecorator")).createImage();
                } else if (attrDesc instanceof IntervalDesc) {
                    image = new OverlayImageIcon(image, Activator.getDefault().getImageRegistry().get("attrIntervalDecorator")).createImage();
                } else if (attrDesc instanceof ConceptDesc) {
                    image = new OverlayImageIcon(image, Activator.getDefault().getImageRegistry().get("attrConceptDecorator")).createImage();
                } else if (attrDesc instanceof DateDesc) {
                    image = new OverlayImageIcon(image, Activator.getDefault().getImageRegistry().get("attrDateDecorator")).createImage();
                }
                return image;
            }
            return null;
        }
    }
}

