/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.mycbr.gui.retrieval.editor;

import de.dfki.mycbr.core.DefaultCaseBase;
import de.dfki.mycbr.core.ICaseBase;
import de.dfki.mycbr.core.casebase.Attribute;
import de.dfki.mycbr.core.casebase.Instance;
import de.dfki.mycbr.core.casebase.MultipleAttribute;
import de.dfki.mycbr.core.casebase.SpecialAttribute;
import de.dfki.mycbr.core.model.AttributeDesc;
import de.dfki.mycbr.core.model.Concept;
import de.dfki.mycbr.core.model.ConceptDesc;
import de.dfki.mycbr.core.model.DateDesc;
import de.dfki.mycbr.core.model.FloatDesc;
import de.dfki.mycbr.core.model.IntegerDesc;
import de.dfki.mycbr.core.model.StringDesc;
import de.dfki.mycbr.core.model.SymbolDesc;
import de.dfki.mycbr.core.retrieval.Retrieval;
import de.dfki.mycbr.core.retrieval.SequentialRetrieval;
import de.dfki.mycbr.core.similarity.AmalgamationFct;
import de.dfki.mycbr.core.similarity.DoubleFct;
import de.dfki.mycbr.core.similarity.FloatFct;
import de.dfki.mycbr.core.similarity.IntegerFct;
import de.dfki.mycbr.core.similarity.Similarity;
import de.dfki.mycbr.core.similarity.SymbolFct;
import de.dfki.mycbr.gui.casebase.list.CasebaseListView;
import de.dfki.mycbr.gui.instance.list.ConceptDescContentProvider;
import de.dfki.mycbr.gui.instance.list.ConceptDescLabelProvider;
import de.dfki.mycbr.gui.misc.ListUtil;
import de.dfki.mycbr.gui.retrieval.editor.RetrievalEditorInput;
import de.dfki.mycbr.util.Pair;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.part.EditorPart;

public class RetrievalEditor
extends EditorPart {
    public static final String ID = "de.dfki.mycbr.gui.retrieval.editor.RetrievalEditor";
    private Concept concept;
    private Instance q;
    private List<Pair<Instance, Similarity>> results;
    private SequentialRetrieval sr;
    private ICaseBase cb;
    private ControlDecoration noCB;
    private TableViewer tblResults;
    private TableViewer tblComparison;
    private int comparisonColumns = 4;
    private int comparisonOffset = 0;
    private FormToolkit toolkit;
    private ScrolledForm form;
    private Combo caseBaseBtn;
    private Map.Entry pairs;
    private String attrName;
    private String attrValue;
    private Attribute attV;
    private AttributeDesc attK;
    private Double sim;
    private SymbolFct symSimfct;
    private IntegerFct intSimfct;
    private DoubleFct doubSimfct;
    private FloatFct floatSimfct;

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.concept = ((RetrievalEditorInput)input).getConcept();
        this.setPartName("Retrieval: " + this.concept.getName());
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        CasebaseListView view = (CasebaseListView)page.findView("de.dfki.mycbr.gui.casebase.list.CasebaseListView");
        if (view == null) {
            if (this.concept.getProject().getCaseBases().values().iterator().hasNext()) {
                this.cb = (ICaseBase)this.concept.getProject().getCaseBases().values().iterator().next();
            }
        } else {
            this.cb = view.getCurrentCaseBase();
        }
        Instance givenCase = ((RetrievalEditorInput)input).getCase();
        Retrieval r = new Retrieval(this.concept, this.cb);
        if (givenCase != null) {
            try {
                this.q = this.concept.copyInstance(givenCase, String.valueOf(givenCase.getName()) + "_query");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.q = r.getQueryInstance();
        }
        this.sr = new SequentialRetrieval(this.concept.getProject(), r);
        this.results = new ArrayList<Pair<Instance, Similarity>>();
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(final Composite parent) {
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.form = this.toolkit.createScrolledForm(parent);
        this.form.setText("Retrieval");
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(this.form.getBody());
        final Shell shell = this.form.getShell();
        this.toolkit.createLabel(this.form.getBody(), "Case base:");
        this.caseBaseBtn = new Combo(this.form.getBody(), 2048);
        String[] items = new String[this.concept.getProject().getCaseBases().size()];
        this.caseBaseBtn.setItems(this.concept.getProject().getCaseBases().keySet().toArray(items));
        this.caseBaseBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String s = RetrievalEditor.this.caseBaseBtn.getItem(RetrievalEditor.this.caseBaseBtn.getSelectionIndex());
                RetrievalEditor.this.cb = RetrievalEditor.this.concept.getProject().getCB(s);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Section sctCase = this.toolkit.createSection(this.form.getBody(), 384);
        sctCase.setText("Query");
        GridDataFactory.fillDefaults().span(3, 1).align(4, 1).grab(true, false).applyTo((Control)sctCase);
        GridLayoutFactory.fillDefaults().margins(5, 5).spacing(5, 3).numColumns(3).applyTo(this.form.getBody());
        Composite cmpRetrieval = new Composite(this.form.getBody(), 0);
        cmpRetrieval.setBackground(Display.getDefault().getSystemColor(1));
        GridLayoutFactory.fillDefaults().margins(5, 5).spacing(5, 3).numColumns(3).applyTo(cmpRetrieval);
        for (final AttributeDesc attrDesc : ListUtil.sortAttributeDescs(this.concept.getAllAttributeDescs().values())) {
            Hyperlink lnkRemove;
            Hyperlink lnkAdd;
            if (!this.concept.getActiveAmalgamFct().isActive(attrDesc).booleanValue()) continue;
            Label lbl = this.toolkit.createLabel(cmpRetrieval, attrDesc.getName());
            Composite cmpEditGroup = this.toolkit.createComposite(cmpRetrieval);
            GridLayoutFactory.fillDefaults().numColumns(1).applyTo(cmpEditGroup);
            GridDataFactory.fillDefaults().align(4, 1).grab(true, false).applyTo((Control)cmpEditGroup);
            org.eclipse.swt.widgets.List wgtEdit = null;
            Composite cmpButtonGroup = this.toolkit.createComposite(cmpRetrieval);
            cmpButtonGroup.setLayout((Layout)new FillLayout(512));
            GridDataFactory.fillDefaults().align(1, 1).applyTo((Control)cmpButtonGroup);
            Composite cmpRestButtonGroup = this.toolkit.createComposite(cmpButtonGroup);
            GridLayoutFactory.fillDefaults().numColumns(1).applyTo(cmpRestButtonGroup);
            Composite cmpSpecialValue = this.toolkit.createComposite(cmpButtonGroup);
            cmpSpecialValue.setLayout((Layout)new FillLayout(256));
            this.toolkit.createLabel(cmpSpecialValue, "Special Value: ");
            final Hyperlink lnkSpecialValue = this.toolkit.createHyperlink(cmpSpecialValue, this.getSpecialValue(attrDesc), 64);
            if (attrDesc instanceof DateDesc || attrDesc instanceof FloatDesc || attrDesc instanceof IntegerDesc || attrDesc instanceof StringDesc) {
                if (attrDesc.isMultiple()) {
                    final org.eclipse.swt.widgets.List list = new org.eclipse.swt.widgets.List(cmpEditGroup, 2564);
                    list.setItems(this.q.getAttForDesc(attrDesc).getValueAsString().split(";"));
                    wgtEdit = list;
                    Hyperlink lnkAdd2 = this.toolkit.createHyperlink(cmpRestButtonGroup, "Add", 64);
                    Hyperlink lnkRemove2 = this.toolkit.createHyperlink(cmpRestButtonGroup, "Remove", 64);
                    lnkAdd2.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                        public void linkActivated(HyperlinkEvent e) {
                            String newValue;
                            IInputValidator validator = new IInputValidator(){

                                public String isValid(String newText) {
                                    if (newText.isEmpty()) {
                                        return "Please enter a value";
                                    }
                                    Attribute a = null;
                                    try {
                                        a = attrDesc.getAttribute((Object)newText);
                                    }
                                    catch (Exception exception) {}
                                    if (a == null || !attrDesc.fitsSingle(a)) {
                                        return "This value is not allowed";
                                    }
                                    return null;
                                }
                            };
                            do {
                                MultipleAttribute multipleAttribute;
                                InputDialog inputDialog = new InputDialog(shell, "Add a value", "Add a value", "", validator);
                                inputDialog.open();
                                newValue = inputDialog.getValue();
                                if (newValue == null || newValue.isEmpty()) continue;
                                Attribute attr = RetrievalEditor.this.q.getAttForDesc(attrDesc);
                                if (attr instanceof SpecialAttribute) {
                                    multipleAttribute = new MultipleAttribute(attrDesc, new LinkedList());
                                    RetrievalEditor.this.q.addAttribute(attrDesc, (Attribute)multipleAttribute);
                                    list.removeAll();
                                    lnkSpecialValue.setText("none");
                                } else {
                                    multipleAttribute = (MultipleAttribute)attr;
                                }
                                try {
                                    multipleAttribute.addValue(attrDesc.getAttribute((Object)newValue));
                                    list.add(newValue);
                                }
                                catch (ParseException e1) {
                                    e1.printStackTrace();
                                }
                            } while (newValue != null && !newValue.isEmpty());
                        }
                    });
                    lnkRemove2.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                        public void linkActivated(HyperlinkEvent e) {
                            String value;
                            if (list.getSelection().length > 0 && (value = list.getSelection()[0]) != null) {
                                MultipleAttribute multipleAttribute = (MultipleAttribute)RetrievalEditor.this.q.getAttForDesc(attrDesc);
                                try {
                                    multipleAttribute.removeValue(attrDesc.getAttribute((Object)value));
                                    list.remove(value);
                                }
                                catch (ParseException e1) {
                                    e1.printStackTrace();
                                }
                            }
                        }
                    });
                    GridDataFactory.fillDefaults().align(16384, 128).hint(-1, 75).applyTo((Control)list);
                } else {
                    Text txt = this.toolkit.createText(cmpEditGroup, this.q.getAttForDesc(attrDesc).getValueAsString(), 2048);
                    GridDataFactory.fillDefaults().align(4, 1).applyTo((Control)txt);
                    wgtEdit = txt;
                    final ControlDecoration ctrlDec = new ControlDecoration((Control)txt, 16512);
                    FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
                    ctrlDec.setDescriptionText("This value is not allowed.");
                    ctrlDec.setImage(fieldDecoration.getImage());
                    ctrlDec.hide();
                    txt.addModifyListener(new ModifyListener(){

                        public void modifyText(ModifyEvent e) {
                            Text t = (Text)e.widget;
                            Attribute attr = null;
                            try {
                                if (!t.getText().isEmpty()) {
                                    attr = attrDesc.getAttribute((Object)t.getText());
                                }
                            }
                            catch (ParseException parseException) {}
                            if (attr != null) {
                                RetrievalEditor.this.q.addAttribute(attrDesc, attr);
                                lnkSpecialValue.setText("none");
                                ctrlDec.hide();
                            } else {
                                ctrlDec.show();
                            }
                        }
                    });
                }
            } else if (attrDesc instanceof SymbolDesc) {
                final SymbolDesc symbolDesc = (SymbolDesc)attrDesc;
                if (attrDesc.isMultiple()) {
                    final org.eclipse.swt.widgets.List list = new org.eclipse.swt.widgets.List(cmpEditGroup, 2564);
                    list.setItems(this.q.getAttForDesc(attrDesc).getValueAsString().split(";"));
                    wgtEdit = list;
                    lnkAdd = this.toolkit.createHyperlink(cmpRestButtonGroup, "Add", 64);
                    lnkRemove = this.toolkit.createHyperlink(cmpRestButtonGroup, "Remove", 64);
                    lnkAdd.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                        public void linkActivated(HyperlinkEvent e) {
                            ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, (ILabelProvider)new LabelProvider());
                            Set elements = symbolDesc.getAllowedValues();
                            elements.removeAll(Arrays.asList(RetrievalEditor.this.q.getAttForDesc((AttributeDesc)symbolDesc).getValueAsString().split(";")));
                            dialog.setElements(elements.toArray());
                            dialog.setTitle("Please choose a value");
                            dialog.open();
                            if (dialog.getResult() != null) {
                                MultipleAttribute multipleAttribute;
                                Attribute attr = RetrievalEditor.this.q.getAttForDesc((AttributeDesc)symbolDesc);
                                if (attr instanceof SpecialAttribute) {
                                    multipleAttribute = new MultipleAttribute((AttributeDesc)symbolDesc, new LinkedList());
                                    RetrievalEditor.this.q.addAttribute((AttributeDesc)symbolDesc, (Attribute)multipleAttribute);
                                    list.removeAll();
                                    lnkSpecialValue.setText("none");
                                } else {
                                    multipleAttribute = (MultipleAttribute)attr;
                                }
                                String symbol = String.valueOf(dialog.getResult()[0]);
                                multipleAttribute.addValue(symbolDesc.getAttribute(symbol));
                                list.add(symbol);
                            }
                        }
                    });
                    lnkRemove.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                        public void linkActivated(HyperlinkEvent e) {
                            String symbol;
                            if (list.getSelection().length > 0 && (symbol = list.getSelection()[0]) != null) {
                                MultipleAttribute multipleAttribute = (MultipleAttribute)RetrievalEditor.this.q.getAttForDesc((AttributeDesc)symbolDesc);
                                multipleAttribute.removeValue(symbolDesc.getAttribute(symbol));
                                list.remove(symbol);
                            }
                        }
                    });
                    GridDataFactory.fillDefaults().align(4, 128).applyTo((Control)lbl);
                    GridDataFactory.fillDefaults().align(16384, 128).hint(-1, 75).applyTo((Control)list);
                } else {
                    final Text txt = this.toolkit.createText(cmpEditGroup, this.q.getAttForDesc(attrDesc).getValueAsString(), 2056);
                    GridDataFactory.fillDefaults().align(4, 1).applyTo((Control)txt);
                    wgtEdit = txt;
                    Hyperlink lnkChange = this.toolkit.createHyperlink(cmpRestButtonGroup, "Change", 64);
                    lnkChange.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                        public void linkActivated(HyperlinkEvent e) {
                            ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, (ILabelProvider)new LabelProvider());
                            Set elements = symbolDesc.getAllowedValues();
                            dialog.setElements(elements.toArray());
                            dialog.setTitle("Please choose a value");
                            dialog.open();
                            if (dialog.getResult() != null) {
                                String symbol = String.valueOf(dialog.getResult()[0]);
                                RetrievalEditor.this.q.addAttribute((AttributeDesc)symbolDesc, symbolDesc.getAttribute(symbol));
                                txt.setText(symbol);
                                lnkSpecialValue.setText("none");
                            }
                        }
                    });
                }
            } else if (attrDesc instanceof ConceptDesc) {
                final ConceptDesc conceptDesc = (ConceptDesc)attrDesc;
                if (attrDesc.isMultiple()) {
                    final TableViewer tblValues = new TableViewer(cmpEditGroup, 68356);
                    tblValues.getTable().setLinesVisible(true);
                    tblValues.setContentProvider((IContentProvider)new ConceptDescContentProvider());
                    tblValues.setLabelProvider((IBaseLabelProvider)new ConceptDescLabelProvider());
                    tblValues.setInput((Object)this.q.getAttForDesc((AttributeDesc)conceptDesc));
                    wgtEdit = tblValues.getTable();
                    lnkAdd = this.toolkit.createHyperlink(cmpRestButtonGroup, "Add", 64);
                    lnkRemove = this.toolkit.createHyperlink(cmpRestButtonGroup, "Remove", 64);
                    lnkAdd.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                        public void linkActivated(HyperlinkEvent e) {
                            ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, (ILabelProvider)new LabelProvider());
                            HashSet<String> elements = new HashSet<String>();
                            for (Instance i : conceptDesc.getConcept().getAllInstances()) {
                                elements.add(i.getName());
                            }
                            dialog.setElements(elements.toArray());
                            dialog.setTitle("Please choose an instance");
                            dialog.open();
                            if (dialog.getResult() != null) {
                                String conceptName = String.valueOf(dialog.getResult()[0]);
                                Attribute currentAttribute = RetrievalEditor.this.q.getAttForDesc((AttributeDesc)conceptDesc);
                                try {
                                    Attribute newAttribute = conceptDesc.getAttribute((Object)conceptName);
                                    if (currentAttribute instanceof SpecialAttribute) {
                                        LinkedList<Attribute> attributes = new LinkedList<Attribute>();
                                        attributes.add(newAttribute);
                                        MultipleAttribute multipleAttribute = new MultipleAttribute((AttributeDesc)conceptDesc, attributes);
                                        RetrievalEditor.this.q.addAttribute((AttributeDesc)conceptDesc, (Attribute)multipleAttribute);
                                        lnkSpecialValue.setText("none");
                                    } else {
                                        MultipleAttribute multipleAttribute = (MultipleAttribute)RetrievalEditor.this.q.getAttForDesc((AttributeDesc)conceptDesc);
                                        multipleAttribute.addValue(newAttribute);
                                    }
                                    tblValues.setInput((Object)RetrievalEditor.this.q.getAttForDesc((AttributeDesc)conceptDesc));
                                }
                                catch (ParseException parseException) {}
                            }
                        }
                    });
                    lnkRemove.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                        public void linkActivated(HyperlinkEvent e) {
                            String symbol = tblValues.getTable().getSelection()[0].getText();
                            if (symbol != null) {
                                MultipleAttribute multipleAttribute = (MultipleAttribute)RetrievalEditor.this.q.getAttForDesc((AttributeDesc)conceptDesc);
                                try {
                                    multipleAttribute.removeValue(conceptDesc.getAttribute((Object)symbol));
                                }
                                catch (ParseException e1) {
                                    e1.printStackTrace();
                                }
                                tblValues.setInput((Object)RetrievalEditor.this.q.getAttForDesc((AttributeDesc)conceptDesc));
                            }
                        }
                    });
                    GridDataFactory.fillDefaults().align(16384, 128).hint(-1, 75).applyTo((Control)tblValues.getTable());
                } else {
                    ComboViewer combo = new ComboViewer(cmpEditGroup, 2056);
                    combo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
                    combo.setLabelProvider((IBaseLabelProvider)new LabelProvider());
                    HashSet<String> elements = new HashSet<String>();
                    for (Instance i : conceptDesc.getConcept().getAllInstances()) {
                        elements.add(i.getName());
                    }
                    combo.setInput(elements);
                    combo.setSelection((ISelection)new StructuredSelection((Object)this.q.getAttForDesc(attrDesc).getValueAsString()));
                    wgtEdit = combo.getCombo();
                    GridDataFactory.fillDefaults().align(4, 128).grab(true, false).span(2, 1).applyTo(combo.getControl());
                    combo.addSelectionChangedListener(new ISelectionChangedListener(){

                        public void selectionChanged(SelectionChangedEvent event) {
                            IStructuredSelection ss = (IStructuredSelection)event.getSelection();
                            String newValue = (String)ss.getFirstElement();
                            try {
                                RetrievalEditor.this.q.addAttribute(attrDesc, attrDesc.getAttribute((Object)newValue));
                            }
                            catch (ParseException e) {
                                e.printStackTrace();
                            }
                        }
                    });
                }
            }
            if (cmpRestButtonGroup.getChildren().length == 0) {
                cmpRestButtonGroup.dispose();
            }
            GridDataFactory.fillDefaults().align(4, 1).grab(true, false).applyTo((Control)wgtEdit);
            org.eclipse.swt.widgets.List w = wgtEdit;
            lnkSpecialValue.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter((Control)w, lnkSpecialValue){
                private final /* synthetic */ Control val$w;
                private final /* synthetic */ Hyperlink val$lnkSpecialValue;
                {
                    this.val$w = control;
                    this.val$lnkSpecialValue = hyperlink;
                }

                public void linkActivated(HyperlinkEvent e) {
                    ListDialog ld = new ListDialog(shell);
                    ld.setAddCancelButton(true);
                    ld.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
                    ld.setLabelProvider((ILabelProvider)new LabelProvider());
                    Set elements = RetrievalEditor.this.q.getConcept().getProject().getSpecialValueDesc().getAllowedValues();
                    elements.remove("_others_");
                    ld.setInput((Object)elements.toArray());
                    ld.setTitle("Select special value:");
                    ld.open();
                    if (ld.getResult() != null) {
                        Attribute specAttr = RetrievalEditor.this.q.getConcept().getProject().getSpecialAttribute(String.valueOf(ld.getResult()[0]));
                        RetrievalEditor.this.q.addAttribute(attrDesc, specAttr);
                        RetrievalEditor.this.setSpecialValueForWidget(this.val$w, specAttr.getValueAsString());
                        this.val$lnkSpecialValue.setText(specAttr.getValueAsString());
                    }
                }
            });
        }
        Button btnStartRetrieval = new Button(cmpRetrieval, 8);
        btnStartRetrieval.setText("Start retrieval");
        Button btnSaveRetrieval = new Button(cmpRetrieval, 8);
        btnSaveRetrieval.setText("Save results");
        FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
        this.noCB = new ControlDecoration((Control)this.caseBaseBtn, 131200);
        this.noCB.setDescriptionText("Please select a case base");
        this.noCB.setImage(fieldDecoration.getImage());
        this.caseBaseBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                if (RetrievalEditor.this.cb != null) {
                    RetrievalEditor.this.noCB.hide();
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        });
        btnStartRetrieval.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                if (RetrievalEditor.this.cb == null) {
                    return;
                }
                try {
                    ArrayList<String> retrieval = new ArrayList<String>();
                    retrieval.add(RetrievalEditor.this.q.getAttributes().toString());
                    RetrievalEditor.this.results = RetrievalEditor.this.sr.retrieveSorted((ICaseBase)((DefaultCaseBase)RetrievalEditor.this.cb), RetrievalEditor.this.q);
                    RetrievalEditor.this.tblResults.setInput((Object)RetrievalEditor.this.results.toArray());
                    RetrievalEditor.this.updateComparisonTable();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        btnSaveRetrieval.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                if (RetrievalEditor.this.cb == null) {
                    return;
                }
                try {
                    FileDialog fd = new FileDialog(parent.getShell(), 8192);
                    fd.setText("Save");
                    fd.setFilterPath("C:/");
                    String[] filterExt = new String[]{"*.csv"};
                    fd.setFilterExtensions(filterExt);
                    String projectPath = fd.open();
                    if (projectPath != null) {
                        Pair result;
                        FileWriter fw = new FileWriter(projectPath);
                        PrintWriter pw = new PrintWriter(fw);
                        pw.print(" ");
                        pw.print(";");
                        int i = 1;
                        while (i <= RetrievalEditor.this.comparisonColumns) {
                            if (i - 1 + RetrievalEditor.this.comparisonOffset < RetrievalEditor.this.results.size()) {
                                result = (Pair)RetrievalEditor.this.results.get(i - 1 + RetrievalEditor.this.comparisonOffset);
                                pw.print(((Instance)result.getFirst()).getName());
                                pw.print(";");
                            }
                            ++i;
                        }
                        pw.println(" ");
                        pw.print("Similarity");
                        pw.print(";");
                        int c = 1;
                        while (c <= RetrievalEditor.this.comparisonColumns) {
                            if (c - 1 + RetrievalEditor.this.comparisonOffset < RetrievalEditor.this.results.size()) {
                                result = (Pair)RetrievalEditor.this.results.get(c - 1 + RetrievalEditor.this.comparisonOffset);
                                pw.print(String.valueOf(((Similarity)result.getSecond()).getRoundedValue()));
                                pw.print(";");
                            }
                            ++c;
                        }
                        pw.println(" ");
                        int numberOfAttr = RetrievalEditor.this.concept.getAllAttributeDescs().values().size();
                        List<AttributeDesc> sortedAttrDesc = ListUtil.sortAttributeDescs(RetrievalEditor.this.concept.getAllAttributeDescs().values());
                        int i2 = 0;
                        while (i2 < numberOfAttr) {
                            pw.print(sortedAttrDesc.get(i2).getName());
                            pw.print(";");
                            int c2 = 1;
                            while (c2 <= RetrievalEditor.this.comparisonColumns) {
                                if (c2 - 1 + RetrievalEditor.this.comparisonOffset < RetrievalEditor.this.results.size()) {
                                    Pair result2 = (Pair)RetrievalEditor.this.results.get(c2 - 1 + RetrievalEditor.this.comparisonOffset);
                                    pw.print(((Instance)result2.getFirst()).getAttForDesc(sortedAttrDesc.get(i2)).getValueAsString());
                                    pw.print(";");
                                }
                                ++c2;
                            }
                            pw.println(" ");
                            ++i2;
                        }
                        pw.flush();
                        pw.close();
                        fw.close();
                    }
                }
                catch (Exception exception) {
                    MessageBox messageDialog = new MessageBox(RetrievalEditor.this.form.getShell(), 1);
                    messageDialog.setText("Export failed");
                    messageDialog.setMessage("The process cannot access the file because it is being used by another process.");
                    messageDialog.open();
                }
            }
        });
        GridDataFactory.fillDefaults().span(3, 1).applyTo((Control)btnStartRetrieval);
        GridDataFactory.fillDefaults().span(3, 1).applyTo((Control)btnSaveRetrieval);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).span(2, 1).applyTo((Control)cmpRetrieval);
        this.tblResults = new TableViewer(this.form.getBody(), 68356);
        this.tblResults.getTable().setLinesVisible(true);
        this.tblResults.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tblResults.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object obj) {
                String columnText = "";
                Pair result = (Pair)obj;
                columnText = String.valueOf(((Instance)result.getFirst()).getName()) + " - " + ((Similarity)result.getSecond()).getRoundedValue();
                return columnText;
            }
        });
        this.tblResults.getTable().addListener(13, new Listener(){

            public void handleEvent(Event e) {
                RetrievalEditor.this.comparisonOffset = RetrievalEditor.this.tblResults.getTable().getSelectionIndex();
                RetrievalEditor.this.updateComparisonTable();
            }
        });
        GridDataFactory.fillDefaults().grab(true, true).span(1, 1).applyTo((Control)this.tblResults.getTable());
        this.tblComparison = new TableViewer(this.form.getBody(), 68356);
        this.tblComparison.getTable().setLinesVisible(true);
        this.tblComparison.getTable().setHeaderVisible(true);
        this.resizeComparisonTable();
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).hint(-1, 300).applyTo((Control)this.tblComparison.getTable());
        this.form.reflow(true);
    }

    private String getSpecialValue(AttributeDesc attrDesc) {
        Attribute a = this.q.getAttForDesc(attrDesc);
        String result = a instanceof SpecialAttribute ? a.getValueAsString() : "none";
        return result;
    }

    private void setSpecialValueForWidget(Control w, String s) {
        if (w instanceof Text) {
            ((Text)w).setText(s);
        } else if (w instanceof org.eclipse.swt.widgets.List) {
            ((org.eclipse.swt.widgets.List)w).removeAll();
            ((org.eclipse.swt.widgets.List)w).add(s);
        }
    }

    private void updateComparisonTable() {
        this.tblComparison.getTable().removeAll();
        int i = 1;
        while (i <= this.comparisonColumns) {
            if (i - 1 + this.comparisonOffset < this.results.size()) {
                Pair<Instance, Similarity> result = this.results.get(i - 1 + this.comparisonOffset);
                TableColumn newColumn = this.tblComparison.getTable().getColumn(i);
                newColumn.setText(((Instance)result.getFirst()).getName());
            } else {
                this.tblComparison.getTable().getColumn(i).setText("");
            }
            ++i;
        }
        TableItem simRow = new TableItem(this.tblComparison.getTable(), 0);
        simRow.setText(0, "Similarity");
        int c = 1;
        while (c <= this.comparisonColumns) {
            if (c - 1 + this.comparisonOffset < this.results.size()) {
                Pair<Instance, Similarity> result = this.results.get(c - 1 + this.comparisonOffset);
                simRow.setText(c, String.valueOf(((Similarity)result.getSecond()).getRoundedValue()));
            }
            ++c;
        }
        int numberOfAttr = this.concept.getAllAttributeDescs().values().size();
        List<AttributeDesc> sortedAttrDesc = ListUtil.sortAttributeDescs(this.concept.getAllAttributeDescs().values());
        int i2 = 0;
        while (i2 < numberOfAttr) {
            TableItem newRow = new TableItem(this.tblComparison.getTable(), 0);
            newRow.setText(0, sortedAttrDesc.get(i2).getName());
            this.attrName = sortedAttrDesc.get(i2).getName();
            int c2 = 1;
            while (c2 <= this.comparisonColumns) {
                if (c2 - 1 + this.comparisonOffset < this.results.size()) {
                    Pair<Instance, Similarity> result = this.results.get(c2 - 1 + this.comparisonOffset);
                    newRow.setText(c2, ((Instance)result.getFirst()).getAttForDesc(sortedAttrDesc.get(i2)).getValueAsString());
                    this.attrValue = ((Instance)result.getFirst()).getAttForDesc(sortedAttrDesc.get(i2)).getValueAsString();
                    for (Map.Entry this.pairs : this.q.getAttributes().entrySet()) {
                        this.attV = (Attribute)this.pairs.getValue();
                        this.attK = (AttributeDesc)this.pairs.getKey();
                        AttributeDesc desc = this.concept.getAttributeDesc(this.attrName);
                        if (!this.attrName.trim().equals(this.attK.toString().trim())) continue;
                        if (((AmalgamationFct)this.concept.getAvailableAmalgamFcts().get(0)).getActiveFct(desc).toString().contains("Symbol")) {
                            try {
                                this.symSimfct = (SymbolFct)((AmalgamationFct)this.concept.getAvailableAmalgamFcts().get(0)).getActiveFct(desc);
                                this.sim = this.symSimfct.calculateSimilarity(this.attrValue.trim(), this.attV.getValueAsString().trim()).getValue();
                            }
                            catch (Exception exception) {}
                        } else if (((AmalgamationFct)this.concept.getAvailableAmalgamFcts().get(0)).getActiveFct(desc).toString().contains("Integer")) {
                            try {
                                this.intSimfct = (IntegerFct)((AmalgamationFct)this.concept.getAvailableAmalgamFcts().get(0)).getActiveFct(desc);
                                this.sim = this.intSimfct.calculateSimilarity(((Instance)result.getFirst()).getAttForDesc(sortedAttrDesc.get(i2)), this.attV).getValue();
                            }
                            catch (Exception exception) {}
                        } else if (((AmalgamationFct)this.concept.getAvailableAmalgamFcts().get(0)).getActiveFct(desc).toString().contains("Double")) {
                            try {
                                this.doubSimfct = (DoubleFct)((AmalgamationFct)this.concept.getAvailableAmalgamFcts().get(0)).getActiveFct(desc);
                                this.sim = this.doubSimfct.calculateSimilarity(((Instance)result.getFirst()).getAttForDesc(sortedAttrDesc.get(i2)), this.attV).getValue();
                            }
                            catch (Exception exception) {}
                        } else if (((AmalgamationFct)this.concept.getAvailableAmalgamFcts().get(0)).getActiveFct(desc).toString().contains("Float")) {
                            try {
                                this.floatSimfct = (FloatFct)((AmalgamationFct)this.concept.getAvailableAmalgamFcts().get(0)).getActiveFct(desc);
                                this.sim = this.floatSimfct.calculateSimilarity(((Instance)result.getFirst()).getAttForDesc(sortedAttrDesc.get(i2)), this.attV).getValue();
                            }
                            catch (Exception exception) {}
                        }
                        int colorRedComponent = 128 + (127 - (int)(127.0 * this.sim));
                        int colorGreenBlueComponent = 170 + (85 - (int)(85.0 * this.sim));
                        newRow.setBackground(c2, new Color((Device)Display.getDefault(), colorRedComponent, colorGreenBlueComponent, colorGreenBlueComponent));
                    }
                }
                ++c2;
            }
            this.tblComparison.getTable().update();
            ++i2;
        }
    }

    private void resizeComparisonTable() {
        TableColumn[] tableColumnArray = this.tblComparison.getTable().getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn c = tableColumnArray[n2];
            c.dispose();
            ++n2;
        }
        int i = 0;
        while (i <= this.comparisonColumns) {
            TableViewerColumn newColumn = new TableViewerColumn(this.tblComparison, 0x1000000);
            newColumn.getColumn().setWidth(100);
            newColumn.getColumn().setMoveable(false);
            ++i;
        }
    }

    public void setFocus() {
    }
}

