/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.mycbr.gui.attribute.editor;

import de.dfki.mycbr.core.model.AttributeDesc;
import de.dfki.mycbr.gui.attribute.editor.AttributeFormEditor;
import de.dfki.mycbr.gui.attribute.editor.type.AttributeTypeEditor;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.handlers.IHandlerService;

public class GeneralPage
extends FormPage {
    public static final String ID = "de.dfki.mycbr.gui.attribute.editor.GeneralPage";
    Composite parent;
    final StackLayout stackLayout = new StackLayout();
    private AttributeDesc attribute;
    private Text txtName;
    private Text txtType;
    private Button btnMultiple;
    private List<String> attributeTypes;
    private AttributeTypeEditor typeEditor;
    private ControlDecoration cdNameEmpty;
    private ControlDecoration cdNameTaken;

    public GeneralPage(FormEditor editor) {
        super(editor, ID, "Attribute");
        this.attribute = ((AttributeFormEditor)editor).getAttribute();
    }

    protected void createFormContent(IManagedForm managedForm) {
        managedForm.getForm().setText("Attribute");
        this.initAttributeTypes();
        this.findCurrentType();
        this.parent = managedForm.getForm().getBody();
        this.parent.setLayout((Layout)this.stackLayout);
        this.refreshLayout();
    }

    private void initAttributeTypes() {
        this.attributeTypes = new ArrayList<String>();
        this.attributeTypes.add("Boolean");
        this.attributeTypes.add("Concept");
        this.attributeTypes.add("Date");
        this.attributeTypes.add("Double");
        this.attributeTypes.add("Float");
        this.attributeTypes.add("Integer");
        this.attributeTypes.add("Interval");
        this.attributeTypes.add("String");
        this.attributeTypes.add("Symbol");
    }

    private void findCurrentType() {
        this.typeEditor = null;
        for (String attrType : this.attributeTypes) {
            if (!this.attribute.getClass().getSimpleName().equals(String.valueOf(attrType) + "Desc")) continue;
            try {
                Class<?> editorClass = Class.forName("de.dfki.mycbr.gui.attribute.editor.type." + attrType + "AttributeEditor");
                this.typeEditor = (AttributeTypeEditor)editorClass.newInstance();
                this.typeEditor.init(this.attribute);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            break;
        }
    }

    private void refreshLayout() {
        Composite composite = this.buildBaseComposite(this.parent);
        if (this.typeEditor != null) {
            this.typeEditor.buildComposite(composite);
        } else {
            Status status = new Status(2, "My Plug-in ID", 0, "The type of this attribute is not supported at the moment. You can only edit the common fields.", null);
            ErrorDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"myCBR Warning", (String)"Warning", (IStatus)status);
        }
        this.stackLayout.topControl = composite;
        this.fillModel();
        this.addDirtyOnChangeListeners();
        this.parent.layout();
    }

    private Composite buildBaseComposite(Composite parent) {
        Composite baseComposite = new Composite(parent, 0);
        baseComposite.setBackground(Display.getDefault().getSystemColor(1));
        Label lblName = new Label(baseComposite, 0);
        lblName.setText("Name");
        this.txtName = new Text(baseComposite, 2048);
        FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
        this.cdNameEmpty = new ControlDecoration((Control)this.txtName, 16512);
        this.cdNameEmpty.setDescriptionText("You have to enter a name.");
        this.cdNameEmpty.setImage(fieldDecoration.getImage());
        this.cdNameEmpty.hide();
        this.cdNameTaken = new ControlDecoration((Control)this.txtName, 16512);
        this.cdNameTaken.setDescriptionText("There is another attribute description with that name.");
        this.cdNameTaken.setImage(fieldDecoration.getImage());
        this.cdNameTaken.hide();
        Label lblType = new Label(baseComposite, 0);
        lblType.setText("Type");
        this.txtType = new Text(baseComposite, 2056);
        this.txtType.setText(this.typeEditor.getName());
        Label lblMultiple = new Label(baseComposite, 0);
        lblMultiple.setText("Multiple");
        this.btnMultiple = new Button(baseComposite, 32);
        Label shadow_sep_h = new Label(baseComposite, 266);
        GridLayoutFactory.fillDefaults().margins(5, 5).spacing(5, 3).numColumns(3).applyTo(baseComposite);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).span(2, 1).applyTo((Control)this.txtName);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).span(2, 1).applyTo((Control)this.txtType);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).span(2, 1).applyTo((Control)this.btnMultiple);
        GridDataFactory.fillDefaults().span(3, 1).applyTo((Control)shadow_sep_h);
        return baseComposite;
    }

    private void fillModel() {
        this.txtName.setText(this.attribute.getName());
        this.btnMultiple.setSelection(this.attribute.isMultiple());
        if (this.typeEditor != null) {
            this.typeEditor.fillModel();
        }
    }

    private void addDirtyOnChangeListeners() {
        this.txtName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                try {
                    if (!GeneralPage.this.txtName.getText().isEmpty()) {
                        GeneralPage.this.attribute.setName(GeneralPage.this.txtName.getText());
                        GeneralPage.this.cdNameEmpty.hide();
                        GeneralPage.this.cdNameTaken.hide();
                    } else {
                        GeneralPage.this.cdNameEmpty.show();
                    }
                }
                catch (Exception exception) {
                    GeneralPage.this.cdNameTaken.show();
                }
                IHandlerService handlerService = (IHandlerService)GeneralPage.this.getSite().getService(IHandlerService.class);
                try {
                    handlerService.executeCommand("de.dfki.mycbr.gui.project.list.ProjectListRefreshHandler", null);
                }
                catch (Exception exception) {
                    throw new RuntimeException("de.dfki.mycbr.gui.project.list.ProjectListRefreshHandler not found");
                }
                GeneralPage.this.setPartName(GeneralPage.this.txtName.getText());
                try {
                    if (!GeneralPage.this.attribute.getOwner().getProject().getName().endsWith("_UNSAFED")) {
                        GeneralPage.this.attribute.getOwner().getProject().setName(String.valueOf(GeneralPage.this.attribute.getOwner().getProject().getName()) + "_UNSAFED");
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.btnMultiple.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeneralPage.this.attribute.setMultiple(GeneralPage.this.btnMultiple.getSelection());
            }
        });
    }

    public void setFocus() {
        this.txtName.setFocus();
    }
}

