/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.mycbr.gui.attribute.editor.type;

import de.dfki.mycbr.core.model.AttributeDesc;
import de.dfki.mycbr.core.model.DateDesc;
import de.dfki.mycbr.gui.attribute.editor.type.AttributeTypeEditor;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class DateAttributeEditor
extends AttributeTypeEditor {
    private Text txtMin;
    private Text txtMax;
    private Text txtFormat;
    private ControlDecoration cdMin;
    private ControlDecoration cdMax;
    private DateDesc attribute;

    @Override
    public void init(AttributeDesc attribute) {
        this.attribute = (DateDesc)attribute;
    }

    @Override
    public void fillModel() {
        this.txtMin.setText(this.attribute.getFormat().format(this.attribute.getMinDate()));
        this.txtMax.setText(this.attribute.getFormat().format(this.attribute.getMaxDate()));
        this.txtFormat.setText(this.attribute.getFormat().toPattern());
    }

    @Override
    public void buildComposite(Composite base) {
        FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
        Label lblMin = new Label(base, 0);
        lblMin.setText("Minimum");
        this.txtMin = new Text(base, 2048);
        this.cdMin = new ControlDecoration((Control)this.txtMin, 16512);
        this.cdMin.setImage(fieldDecoration.getImage());
        this.cdMin.hide();
        Label lblMax = new Label(base, 0);
        lblMax.setText("Maximum");
        this.txtMax = new Text(base, 2048);
        this.cdMax = new ControlDecoration((Control)this.txtMax, 16512);
        this.cdMax.setImage(fieldDecoration.getImage());
        this.cdMax.hide();
        Label lblFormat = new Label(base, 0);
        lblFormat.setText("Format");
        this.txtFormat = new Text(base, 2048);
        this.txtFormat.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String newFormat = DateAttributeEditor.this.txtFormat.getText();
                SimpleDateFormat format = DateAttributeEditor.this.attribute.getFormat();
                if (!format.toPattern().equals(newFormat)) {
                    format.applyPattern(newFormat);
                    DateAttributeEditor.this.fillModel();
                }
            }
        });
        this.txtMin.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Date newDate = DateAttributeEditor.this.parseDate(DateAttributeEditor.this.txtMin.getText());
                if (newDate == null) {
                    DateAttributeEditor.this.cdMin.setDescriptionText("This date could not be parsed.");
                    DateAttributeEditor.this.cdMin.show();
                } else if (newDate.compareTo(DateAttributeEditor.this.attribute.getMaxDate()) > 0) {
                    DateAttributeEditor.this.cdMin.setDescriptionText("The min-value must be lower than the max value.");
                    DateAttributeEditor.this.cdMin.show();
                } else {
                    DateAttributeEditor.this.attribute.setMinDate(newDate);
                    DateAttributeEditor.this.cdMin.hide();
                    try {
                        if (!DateAttributeEditor.this.attribute.getOwner().getProject().getName().endsWith("_UNSAFED")) {
                            DateAttributeEditor.this.attribute.getOwner().getProject().setName(String.valueOf(DateAttributeEditor.this.attribute.getOwner().getProject().getName()) + "_UNSAFED");
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        this.txtMax.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Date newDate = DateAttributeEditor.this.parseDate(DateAttributeEditor.this.txtMax.getText());
                if (newDate == null) {
                    DateAttributeEditor.this.cdMax.setDescriptionText("This date could not be parsed.");
                    DateAttributeEditor.this.cdMax.show();
                } else if (newDate.compareTo(DateAttributeEditor.this.attribute.getMinDate()) < 0) {
                    DateAttributeEditor.this.cdMax.setDescriptionText("The max-value must be higher than the min value.");
                    DateAttributeEditor.this.cdMax.show();
                } else {
                    DateAttributeEditor.this.attribute.setMaxDate(newDate);
                    DateAttributeEditor.this.cdMax.hide();
                    try {
                        if (!DateAttributeEditor.this.attribute.getOwner().getProject().getName().endsWith("_UNSAFED")) {
                            DateAttributeEditor.this.attribute.getOwner().getProject().setName(String.valueOf(DateAttributeEditor.this.attribute.getOwner().getProject().getName()) + "_UNSAFED");
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).span(2, 1).applyTo((Control)this.txtMin);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).span(2, 1).applyTo((Control)this.txtMax);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).span(2, 1).applyTo((Control)this.txtFormat);
    }

    private Date parseDate(String s) {
        try {
            return this.attribute.getFormat().parse(s);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    @Override
    public String getName() {
        return "Date";
    }

    @Override
    public void save() {
    }

    @Override
    public String getClassName() {
        return this.attribute.getClass().getSimpleName();
    }
}

