/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.mycbr.gui.attribute.editor.type;

import de.dfki.mycbr.core.model.AttributeDesc;
import de.dfki.mycbr.core.model.IntegerDesc;
import de.dfki.mycbr.gui.attribute.editor.type.AttributeTypeEditor;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class IntegerAttributeEditor
extends AttributeTypeEditor {
    private Text txtMin;
    private Text txtMax;
    private IntegerDesc attribute;
    private ControlDecoration cdTooLow;
    private ControlDecoration cdTooHigh;

    @Override
    public void init(AttributeDesc attribute) {
        this.attribute = (IntegerDesc)attribute;
    }

    @Override
    public void fillModel() {
        this.txtMin.setText(this.attribute.getMin().toString());
        this.txtMax.setText(this.attribute.getMax().toString());
    }

    @Override
    public void buildComposite(Composite base) {
        Label lblMin = new Label(base, 0);
        lblMin.setText("Minimum");
        this.txtMin = new Text(base, 2048);
        this.cdTooHigh = new ControlDecoration((Control)this.txtMin, 16512);
        FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
        this.cdTooHigh.setDescriptionText("The min-value must be lower than the max value.");
        this.cdTooHigh.setImage(fieldDecoration.getImage());
        this.cdTooHigh.hide();
        Label lblMax = new Label(base, 0);
        lblMax.setText("Maximum");
        this.txtMax = new Text(base, 2048);
        this.cdTooLow = new ControlDecoration((Control)this.txtMax, 16512);
        this.cdTooLow.setDescriptionText("The max-value must be higher than the min value.");
        this.cdTooLow.setImage(fieldDecoration.getImage());
        this.cdTooLow.hide();
        this.fillModel();
        this.txtMin.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Integer newValue = IntegerAttributeEditor.this.parseInt(IntegerAttributeEditor.this.txtMin.getText());
                if (newValue > IntegerAttributeEditor.this.attribute.getMax()) {
                    IntegerAttributeEditor.this.cdTooHigh.show();
                } else {
                    IntegerAttributeEditor.this.attribute.setMin(newValue.intValue());
                    IntegerAttributeEditor.this.cdTooHigh.hide();
                    try {
                        if (!IntegerAttributeEditor.this.attribute.getOwner().getProject().getName().endsWith("_UNSAFED")) {
                            IntegerAttributeEditor.this.attribute.getOwner().getProject().setName(String.valueOf(IntegerAttributeEditor.this.attribute.getOwner().getProject().getName()) + "_UNSAFED");
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        this.txtMax.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Integer newValue = IntegerAttributeEditor.this.parseInt(IntegerAttributeEditor.this.txtMax.getText());
                if (newValue < IntegerAttributeEditor.this.attribute.getMin()) {
                    IntegerAttributeEditor.this.cdTooLow.show();
                } else {
                    IntegerAttributeEditor.this.attribute.setMax(newValue.intValue());
                    IntegerAttributeEditor.this.cdTooLow.hide();
                    try {
                        if (!IntegerAttributeEditor.this.attribute.getOwner().getProject().getName().endsWith("_UNSAFED")) {
                            IntegerAttributeEditor.this.attribute.getOwner().getProject().setName(String.valueOf(IntegerAttributeEditor.this.attribute.getOwner().getProject().getName()) + "_UNSAFED");
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).span(2, 1).applyTo((Control)this.txtMin);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).span(2, 1).applyTo((Control)this.txtMax);
    }

    private Integer parseInt(String str) {
        Integer result = null;
        try {
            result = Integer.parseInt(str);
        }
        catch (NumberFormatException numberFormatException) {}
        return result;
    }

    @Override
    public String getName() {
        return "Integer";
    }

    @Override
    public void save() {
    }

    @Override
    public String getClassName() {
        return this.attribute.getClass().getSimpleName();
    }
}

