/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.mycbr.gui.attribute.editor.type;

import de.dfki.mycbr.core.casebase.SymbolAttribute;
import de.dfki.mycbr.core.model.AttributeDesc;
import de.dfki.mycbr.core.model.SymbolDesc;
import de.dfki.mycbr.core.similarity.ISimFct;
import de.dfki.mycbr.core.similarity.Similarity;
import de.dfki.mycbr.core.similarity.TaxonomyFct;
import de.dfki.mycbr.core.similarity.TaxonomyNode;
import de.dfki.mycbr.gui.attribute.editor.type.AttributeTypeEditor;
import de.dfki.mycbr.gui.misc.ListUtil;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;

public class SymbolAttributeEditor
extends AttributeTypeEditor {
    private SymbolDesc attrDesc;
    private String[] selectedValues;
    private TableViewer tblAllowedValues;

    @Override
    public void init(AttributeDesc attrDesc) {
        this.attrDesc = (SymbolDesc)attrDesc;
    }

    @Override
    public void buildComposite(Composite base) {
        Label lblAllowedValues = new Label(base, 0);
        lblAllowedValues.setText("Allowed Values");
        this.tblAllowedValues = new TableViewer(base, 68354);
        this.tblAllowedValues.getTable().setLinesVisible(true);
        this.tblAllowedValues.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        Composite cmpButtonGroup = new Composite(base, 0);
        FillLayout cmpButtonGroupLayout = new FillLayout(512);
        cmpButtonGroup.setLayout((Layout)cmpButtonGroupLayout);
        Button btnAdd = new Button(cmpButtonGroup, 8);
        btnAdd.setText("Add");
        Button btnRename = new Button(cmpButtonGroup, 8);
        btnRename.setText("Rename");
        Button btnRemove = new Button(cmpButtonGroup, 8);
        btnRemove.setText("Remove");
        this.tblAllowedValues.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection ss = (IStructuredSelection)event.getSelection();
                Object[] ary = ss.toArray();
                SymbolAttributeEditor.this.selectedValues = new String[ary.length];
                int i = 0;
                Object[] objectArray = ary;
                int n = ary.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    ((SymbolAttributeEditor)SymbolAttributeEditor.this).selectedValues[i] = (String)o;
                    ++i;
                    ++n2;
                }
            }
        });
        final Shell shell = base.getShell();
        btnAdd.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                String newValue;
                IInputValidator validator = new IInputValidator(){

                    public String isValid(String newText) {
                        if (newText.isEmpty()) {
                            return "You must enter a name";
                        }
                        if (SymbolAttributeEditor.this.attrDesc.isAllowedValue(newText)) {
                            return "An allowed value with this name already exists";
                        }
                        return null;
                    }
                };
                int count = 0;
                do {
                    if (count > 0) {
                        new Thread(new Runnable(){

                            @Override
                            public void run() {
                                Display display = new Display();
                                Shell dialog = new Shell(display);
                                dialog.setText("Symbol added");
                                dialog.setSize(270, 100);
                                Monitor primary = display.getPrimaryMonitor();
                                Rectangle bounds = primary.getBounds();
                                Rectangle rect = dialog.getBounds();
                                int x = bounds.x + (bounds.width - rect.width) / 2;
                                int y = bounds.y + (bounds.height - rect.height) / 2;
                                dialog.setLocation(x, y);
                                Label label = new Label((Composite)dialog, 0);
                                label.setText("You have successfully added a new symbol!");
                                label.setBounds(20, 20, 300, 20);
                                dialog.open();
                                try {
                                    Thread.sleep(2000L);
                                    dialog.close();
                                }
                                catch (InterruptedException e1) {
                                    e1.printStackTrace();
                                }
                                try {
                                    if (!SymbolAttributeEditor.this.attrDesc.getOwner().getProject().getName().endsWith("_UNSAFED")) {
                                        SymbolAttributeEditor.this.attrDesc.getOwner().getProject().setName(String.valueOf(SymbolAttributeEditor.this.attrDesc.getOwner().getProject().getName()) + "_UNSAFED");
                                    }
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                }
                            }
                        }).start();
                    }
                    ++count;
                    InputDialog inputDialog = new InputDialog(shell, "Add allowed value", "Please enter a name", "", validator);
                    inputDialog.open();
                    newValue = inputDialog.getValue();
                    if (newValue == null || newValue.isEmpty()) continue;
                    SymbolAttribute symAttr = SymbolAttributeEditor.this.attrDesc.addSymbol(newValue);
                    for (ISimFct simFct : SymbolAttributeEditor.this.attrDesc.getSimFcts()) {
                        if (!(simFct instanceof TaxonomyFct)) continue;
                        TaxonomyFct taxFct = (TaxonomyFct)simFct;
                        taxFct.setParent((TaxonomyNode)symAttr, taxFct.getTopSymbol());
                        taxFct.setNodeSimilarity((TaxonomyNode)symAttr, Similarity.get((Double)0.0));
                    }
                    SymbolAttributeEditor.this.tblAllowedValues.setInput(ListUtil.sortSymbolAttributes(SymbolAttributeEditor.this.attrDesc.getAllowedValues()));
                } while (newValue != null && !newValue.isEmpty());
            }
        });
        btnRename.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                if (SymbolAttributeEditor.this.selectedValues != null && SymbolAttributeEditor.this.selectedValues.length > 0) {
                    IInputValidator validator = new IInputValidator(){

                        public String isValid(String newText) {
                            if (newText.isEmpty()) {
                                return "You must enter a name";
                            }
                            if (SymbolAttributeEditor.this.attrDesc.isAllowedValue(newText) && !SymbolAttributeEditor.this.selectedValues[0].equals(newText)) {
                                return "An allowed value with this name already exists";
                            }
                            return null;
                        }
                    };
                    InputDialog inputDialog = new InputDialog(shell, "Rename allowed value", "Please enter a name", SymbolAttributeEditor.this.selectedValues[0], validator);
                    String oldValue = inputDialog.getValue();
                    inputDialog.open();
                    String newValue = inputDialog.getValue();
                    if (newValue != null) {
                        ((SymbolAttribute)SymbolAttributeEditor.this.attrDesc.getAttribute(oldValue)).setValue(newValue);
                        SymbolAttributeEditor.this.tblAllowedValues.setInput(ListUtil.sortSymbolAttributes(SymbolAttributeEditor.this.attrDesc.getAllowedValues()));
                        try {
                            if (!SymbolAttributeEditor.this.attrDesc.getOwner().getProject().getName().endsWith("_UNSAFED")) {
                                SymbolAttributeEditor.this.attrDesc.getOwner().getProject().setName(String.valueOf(SymbolAttributeEditor.this.attrDesc.getOwner().getProject().getName()) + "_UNSAFED");
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }
            }
        });
        btnRemove.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                if (SymbolAttributeEditor.this.selectedValues != null && SymbolAttributeEditor.this.selectedValues.length > 0) {
                    String[] stringArray = SymbolAttributeEditor.this.selectedValues;
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String s = stringArray[n2];
                        SymbolAttributeEditor.this.attrDesc.removeSymbol(s);
                        ++n2;
                    }
                    try {
                        if (!SymbolAttributeEditor.this.attrDesc.getOwner().getProject().getName().endsWith("_UNSAFED")) {
                            SymbolAttributeEditor.this.attrDesc.getOwner().getProject().setName(String.valueOf(SymbolAttributeEditor.this.attrDesc.getOwner().getProject().getName()) + "_UNSAFED");
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                SymbolAttributeEditor.this.tblAllowedValues.setInput(ListUtil.sortSymbolAttributes(SymbolAttributeEditor.this.attrDesc.getAllowedValues()));
            }
        });
        GridDataFactory.fillDefaults().align(4, 128).applyTo((Control)lblAllowedValues);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).hint(300, 200).applyTo((Control)this.tblAllowedValues.getTable());
        GridDataFactory.fillDefaults().align(4, 128).grab(false, false).applyTo((Control)cmpButtonGroup);
    }

    @Override
    public void fillModel() {
        this.tblAllowedValues.setInput(ListUtil.sortSymbolAttributes(this.attrDesc.getAllowedValues()));
    }

    @Override
    public String getClassName() {
        return this.attrDesc.getClass().getSimpleName();
    }

    @Override
    public String getName() {
        return "Symbol";
    }

    @Override
    public void save() {
    }
}

