/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.mycbr.gui.attribute.wizard;

import de.dfki.mycbr.core.model.Concept;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class ConceptDescPage
extends WizardPage {
    public static final String PAGE_NAME = "Concept";
    private Concept concept;
    private Text txtName;
    private ComboViewer cvConcept;
    private Button btnMultiple;

    public ConceptDescPage(Concept concept) {
        super(PAGE_NAME, "Create a concept description", null);
        this.setDescription("Specify the name and concept of the new concept description.");
        this.concept = concept;
    }

    public void createControl(Composite parent) {
        Label lblName = new Label(parent, 0);
        lblName.setText("Name");
        this.txtName = new Text(parent, 2048);
        this.txtName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ConceptDescPage.this.handleErrors();
            }
        });
        Label lblType = new Label(parent, 0);
        lblType.setText(PAGE_NAME);
        this.cvConcept = new ComboViewer(parent, 8);
        this.cvConcept.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.cvConcept.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.cvConcept.setInput(this.concept.getProject().getAllSubConcepts().keySet());
        this.cvConcept.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ConceptDescPage.this.handleErrors();
            }
        });
        Label lblMultiple = new Label(parent, 0);
        lblMultiple.setText("Multiple");
        this.btnMultiple = new Button(parent, 32);
        GridLayoutFactory.fillDefaults().margins(5, 5).spacing(5, 3).numColumns(3).applyTo(parent);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).span(2, 1).applyTo((Control)this.txtName);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).span(2, 1).applyTo((Control)this.cvConcept.getCombo());
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).span(2, 1).applyTo((Control)this.btnMultiple);
        this.setControl((Control)this.txtName);
        this.handleErrors();
    }

    private void handleErrors() {
        String s;
        String errorMessage = null;
        if (this.getConcept() == null) {
            errorMessage = "You have to choose a concept.";
        }
        if ((s = this.txtName.getText()).isEmpty()) {
            errorMessage = "The attribute description's name cannot be empty.";
        } else if (this.concept.hasDirectAttributeDesc(s)) {
            errorMessage = "There is another attribute description with that name.";
        }
        this.setPageComplete(errorMessage == null);
        this.setErrorMessage(errorMessage);
    }

    public String getAttrName() {
        return this.txtName.getText();
    }

    public String getConcept() {
        return (String)((IStructuredSelection)this.cvConcept.getSelection()).getFirstElement();
    }

    public boolean getMultiple() {
        return this.btnMultiple.getSelection();
    }
}

