/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.mycbr.gui.casebase.list;

import de.dfki.mycbr.core.Project;
import de.dfki.mycbr.gui.casebase.list.CasebaseListView;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

public class AddCaseBaseAction
extends Action
implements ActionFactory.IWorkbenchAction {
    public static final String ID = "de.dfki.mycbr.gui.casebase.list.AddCaseBaseAction";
    private CasebaseListView view;

    public AddCaseBaseAction(CasebaseListView view) {
        this.view = view;
        this.setId(ID);
    }

    public void run() {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        if (this.view.getCurrentProject() == null) {
            MessageDialog.openWarning((Shell)shell, (String)"No project selected!", (String)"Select the project you want to add the case base to.");
        } else {
            final Project prj = this.view.getCurrentProject();
            IInputValidator validator = new IInputValidator(){

                public String isValid(String newText) {
                    if (newText.isEmpty()) {
                        return "Enter the case base's name";
                    }
                    if (prj.hasCB(newText)) {
                        return "There is another case base with that name";
                    }
                    return null;
                }
            };
            InputDialog inputDialog = new InputDialog(shell, "Enter the case base's name", "Enter the case base's name", "", validator);
            inputDialog.open();
            String casebaseName = inputDialog.getValue();
            if (casebaseName != null && !casebaseName.isEmpty()) {
                try {
                    prj.createDefaultCB(casebaseName);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.view.refresh(casebaseName);
                try {
                    if (!prj.getName().endsWith("_UNSAFED")) {
                        prj.setName(String.valueOf(prj.getName()) + "_UNSAFED");
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public void dispose() {
    }
}

