/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.mycbr.gui.commands;

import de.dfki.mycbr.core.Project;
import de.dfki.mycbr.gui.Properties;
import de.dfki.mycbr.gui.misc.MyCbrInterface;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.handlers.IHandlerService;
import org.osgi.service.prefs.BackingStoreException;

public class OpenHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEclipsePreferences preferences = new ConfigurationScope().getNode("de.dfki.mycbr.gui");
        String previousFile = preferences.get("openPath", "");
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        FileDialog dialog = new FileDialog(window.getShell(), 4096);
        dialog.setFilterExtensions(new String[]{"*.prj", "*.zip", "*.XML", "*.*"});
        dialog.setFilterNames(new String[]{"myCBR project Files (*.prj)", "zip Files (*.zip)", "myCBR 2.6.x Files (*_CBR_SMF.XML)", "*.*"});
        dialog.setFilterPath(previousFile);
        String fileSelected = dialog.open();
        if (fileSelected != null) {
            Properties.getInstance().addRecentProject(fileSelected);
            String projectName = fileSelected.substring(fileSelected.lastIndexOf(System.getProperty("file.separator")) + 1, fileSelected.lastIndexOf(46));
            if (MyCbrInterface.getInstance().isAlreadyOpen(fileSelected)) {
                MessageDialog messageDialog = new MessageDialog(window.getShell(), "Project already opened!", null, "This project is already opened in the workspace.", 2, new String[]{"Ok"}, 0);
                messageDialog.open();
                return null;
            }
            if (MyCbrInterface.getInstance().projectExists(projectName)) {
                MessageDialog messageDialog = new MessageDialog(window.getShell(), "Project with this name already opened!", null, "A project with the same name is already open. It is currently not supported open several projects with the same name.", 4, new String[]{"Ok"}, 0);
                messageDialog.open();
                return null;
            }
            final Project project = MyCbrInterface.getInstance().load(fileSelected);
            System.out.println(project.hashCode());
            if (project != null) {
                IHandlerService handlerService = (IHandlerService)window.getService(IHandlerService.class);
                try {
                    handlerService.executeCommand("de.dfki.mycbr.gui.project.list.ProjectListRefreshHandler", null);
                }
                catch (Exception exception) {
                    throw new RuntimeException("de.dfki.mycbr.gui.project.list.ProjectListRefreshHandler not found");
                }
                if (!fileSelected.endsWith(".XML")) {
                    Job job = new Job("Loading cases..."){

                        protected IStatus run(IProgressMonitor monitor) {
                            monitor.beginTask("Loading cases...", project.getTotalNumberOfCases());
                            int lastNumberOfCases = 0;
                            while (project.isImporting()) {
                                if (monitor.isCanceled()) {
                                    return Status.CANCEL_STATUS;
                                }
                                int currentNumberOfCases = project.getCurrentNumberOfCases();
                                monitor.worked(project.getCurrentNumberOfCases() - lastNumberOfCases);
                                lastNumberOfCases = currentNumberOfCases;
                                try {
                                    Thread.sleep(1000L);
                                }
                                catch (InterruptedException e) {
                                    e.printStackTrace();
                                }
                            }
                            monitor.done();
                            return Status.OK_STATUS;
                        }
                    };
                    job.setUser(true);
                    job.schedule();
                }
                preferences.put("openPath", fileSelected);
                try {
                    preferences.flush();
                }
                catch (BackingStoreException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }
}

