/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.mycbr.gui.csvimporter.wizard;

import de.dfki.mycbr.core.model.Concept;
import java.util.Set;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ListDialog;

public class SettingsPage
extends WizardPage {
    public static final String PAGE_NAME = "Settings";
    private Text txtSpecValue;
    private Button btnMissingValues;
    private Button btnMissingDescs;
    private Button btnSpecValue;
    private Combo cboCasebase;
    private Concept concept;

    public SettingsPage(Concept concept) {
        super(PAGE_NAME, "Settings page", null);
        this.concept = concept;
    }

    public void createControl(Composite container) {
        Composite parent = new Composite(container, 0);
        this.btnMissingDescs = new Button(parent, 32);
        this.btnMissingDescs.setText("Add missing descriptions");
        this.btnMissingValues = new Button(parent, 32);
        this.btnMissingValues.setText("Add missing values");
        this.btnMissingValues.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SettingsPage.this.btnSpecValue.setEnabled(!SettingsPage.this.btnMissingValues.getSelection());
            }
        });
        Label lblSpecValue = new Label(parent, 0);
        lblSpecValue.setText("Special attribute for missing values");
        this.txtSpecValue = new Text(parent, 2056);
        final Shell shell = parent.getShell();
        this.btnSpecValue = new Button(parent, 8);
        this.btnSpecValue.setText("Choose...");
        this.btnSpecValue.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ListDialog ld = new ListDialog(shell);
                ld.setAddCancelButton(true);
                ld.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
                ld.setLabelProvider((ILabelProvider)new LabelProvider());
                Set elements = SettingsPage.this.concept.getProject().getSpecialValueDesc().getAllowedValues();
                elements.remove("_others_");
                ld.setInput((Object)elements.toArray());
                ld.setTitle("Select special value:");
                ld.open();
                if (ld.getResult() != null) {
                    SettingsPage.this.txtSpecValue.setText(String.valueOf(ld.getResult()[0]));
                }
            }
        });
        Label lblCasebase = new Label(parent, 0);
        lblCasebase.setText("Target casebase");
        this.cboCasebase = new Combo(parent, 8);
        this.cboCasebase.add("CB_csvImport");
        for (String cbName : this.concept.getProject().getCaseBases().keySet()) {
            this.cboCasebase.add(cbName);
        }
        this.cboCasebase.select(0);
        GridLayoutFactory.fillDefaults().margins(5, 5).spacing(5, 3).numColumns(3).applyTo(parent);
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)this.btnMissingValues);
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)this.btnMissingDescs);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.txtSpecValue);
        this.setControl((Control)parent);
    }

    public boolean getCreateMissingDesc() {
        return this.btnMissingDescs.getSelection();
    }

    public boolean getCreateMissingValues() {
        return this.btnMissingValues.getSelection();
    }

    public String getSpecialAtt() {
        return this.txtSpecValue.getText();
    }

    public String getCasebase() {
        if (this.cboCasebase.getSelectionIndex() > 0) {
            return this.cboCasebase.getText();
        }
        return null;
    }
}

