/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.mycbr.gui.function.editor;

import de.dfki.mycbr.core.similarity.DoubleFct;
import de.dfki.mycbr.core.similarity.config.DistanceConfig;
import de.dfki.mycbr.core.similarity.config.NumberConfig;
import de.dfki.mycbr.gui.function.editor.DoubleEditorInput;
import de.dfki.mycbr.gui.function.editor.SetSimilarityWizard;
import de.dfki.mycbr.gui.function.editor.function2d.DoubleFunction2D;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.function.Function2D;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.data.xy.XYDataset;
import org.jfree.experimental.chart.swt.ChartComposite;

public class DoubleEditor
extends EditorPart {
    public static final String ID = "de.dfki.mycbr.gui.function.editor.DoubleEditor";
    private DoubleFct function;
    private Button[] btnSymmetry;
    private Button[] btnDistanceFct;
    private Composite cmpModeGroup;
    private Button[] btnModeLeft;
    private Button[] btnModeRight;
    private Text[] txtModeLeft;
    private Text[] txtModeRight;
    private ChartComposite cmpChart;
    private double functionParameterL;
    private double functionParameterR;
    private NumberConfig functionTypeL;
    private NumberConfig functionTypeR;

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.function = ((DoubleEditorInput)input).getFunction();
        this.setPartName(this.function.getName());
        this.functionTypeL = this.function.getFunctionTypeL();
        this.functionTypeR = this.function.getFunctionTypeR();
        this.functionParameterL = this.function.getFunctionParameterL();
        this.functionParameterR = this.function.getFunctionParameterR();
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        this.createUi(parent);
        this.addDirtyOnChangeListeners();
    }

    private void createUi(Composite parent) {
        Label lblSymmetry = new Label(parent, 0);
        lblSymmetry.setText("Symmetry");
        Composite cmpSymmetryGroup = new Composite(parent, 0);
        cmpSymmetryGroup.setLayout((Layout)new FillLayout(256));
        this.btnSymmetry = new Button[2];
        this.btnSymmetry[0] = new Button(cmpSymmetryGroup, 16);
        this.btnSymmetry[0].setText("symmetric");
        this.btnSymmetry[1] = new Button(cmpSymmetryGroup, 16);
        this.btnSymmetry[1].setText("asymmetric");
        this.btnSymmetry[0].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DoubleEditor.this.setSymmetric();
                DoubleEditor.this.redrawChart();
            }
        });
        this.btnSymmetry[1].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DoubleEditor.this.setAsymmetric();
                DoubleEditor.this.redrawChart();
            }
        });
        Label lblDistanceFct = new Label(parent, 0);
        lblDistanceFct.setText("Distance Function");
        Composite cmpDistanceGroup = new Composite(parent, 0);
        cmpDistanceGroup.setLayout((Layout)new FillLayout(256));
        this.btnDistanceFct = new Button[2];
        this.btnDistanceFct[0] = new Button(cmpDistanceGroup, 16);
        this.btnDistanceFct[0].setText("difference");
        this.btnDistanceFct[1] = new Button(cmpDistanceGroup, 16);
        this.btnDistanceFct[1].setText("quotient");
        this.btnDistanceFct[0].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DoubleEditor.this.function.setDistanceFct(DistanceConfig.DIFFERENCE);
                DoubleEditor.this.redrawChart();
            }
        });
        this.btnDistanceFct[1].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DoubleEditor.this.function.setDistanceFct(DistanceConfig.QUOTIENT);
                DoubleEditor.this.redrawChart();
            }
        });
        this.createModeButtons(parent);
        this.fillModel();
        this.createModeButtonCallbacks();
        Composite cmpLabel = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).margins(100, 0).applyTo(cmpLabel);
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).align(4, 4).applyTo((Control)cmpLabel);
        Label l1 = new Label(cmpLabel, 2048);
        l1.setText("case < query");
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).align(16384, 128).applyTo((Control)l1);
        Label l2 = new Label(cmpLabel, 2048);
        GridDataFactory.fillDefaults().span(1, 1).align(131072, 128).applyTo((Control)l2);
        l2.setText("case > query");
        this.cmpChart = new ChartComposite(parent, 0);
        this.redrawChart();
        final Shell shell = parent.getShell();
        if (this.function.getDesc().isMultiple()) {
            Button btnSetSimilarity = new Button(parent, 8);
            btnSetSimilarity.setText("Configure set similarity");
            btnSetSimilarity.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SetSimilarityWizard wizard = new SetSimilarityWizard(DoubleEditor.this.function.getMultipleConfig());
                    WizardDialog wizardDialog = new WizardDialog(shell, (IWizard)wizard){

                        public void updateButtons() {
                            super.updateButtons();
                            this.getButton(1).setEnabled(false);
                        }
                    };
                    wizardDialog.create();
                    wizardDialog.open();
                }
            });
        }
        GridLayoutFactory.fillDefaults().margins(5, 5).spacing(5, 3).numColumns(3).applyTo(parent);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).span(3, 1).applyTo((Control)this.cmpModeGroup);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).span(3, 1).applyTo((Control)this.cmpChart);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)cmpSymmetryGroup);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)cmpDistanceGroup);
    }

    private void createModeButtons(Composite parent) {
        Text t;
        this.btnModeLeft = new Button[4];
        this.txtModeLeft = new Text[4];
        this.btnModeRight = new Button[4];
        this.txtModeRight = new Text[4];
        this.cmpModeGroup = new Composite(parent, 0);
        GridLayout cmpModeLayout = new GridLayout(2, true);
        this.cmpModeGroup.setLayout((Layout)cmpModeLayout);
        Composite cmpLeftModeGroup = new Composite(this.cmpModeGroup, 0);
        GridLayout cmpLeftModeLayout = new GridLayout(2, true);
        cmpLeftModeGroup.setLayout((Layout)cmpLeftModeLayout);
        this.btnModeLeft[0] = new Button(cmpLeftModeGroup, 16);
        this.btnModeLeft[0].setText("Constant");
        this.txtModeLeft[0] = new Text(cmpLeftModeGroup, 2048);
        this.btnModeLeft[1] = new Button(cmpLeftModeGroup, 16);
        this.btnModeLeft[1].setText("Step at");
        this.txtModeLeft[1] = new Text(cmpLeftModeGroup, 2048);
        this.btnModeLeft[2] = new Button(cmpLeftModeGroup, 16);
        this.btnModeLeft[2].setText("Polynomial with");
        this.txtModeLeft[2] = new Text(cmpLeftModeGroup, 2048);
        this.btnModeLeft[3] = new Button(cmpLeftModeGroup, 16);
        this.btnModeLeft[3].setText("Smooth-Step at");
        this.txtModeLeft[3] = new Text(cmpLeftModeGroup, 2048);
        Composite cmpRightModeGroup = new Composite(this.cmpModeGroup, 0);
        GridLayout cmpRightModeLayout = new GridLayout(2, true);
        cmpRightModeGroup.setLayout((Layout)cmpRightModeLayout);
        this.btnModeRight[0] = new Button(cmpRightModeGroup, 16);
        this.btnModeRight[0].setText("Constant");
        this.txtModeRight[0] = new Text(cmpRightModeGroup, 2048);
        this.btnModeRight[1] = new Button(cmpRightModeGroup, 16);
        this.btnModeRight[1].setText("Step at");
        this.txtModeRight[1] = new Text(cmpRightModeGroup, 2048);
        this.btnModeRight[2] = new Button(cmpRightModeGroup, 16);
        this.btnModeRight[2].setText("Polynomial with");
        this.txtModeRight[2] = new Text(cmpRightModeGroup, 2048);
        this.btnModeRight[3] = new Button(cmpRightModeGroup, 16);
        this.btnModeRight[3].setText("Smooth-Step at");
        this.txtModeRight[3] = new Text(cmpRightModeGroup, 2048);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        Text[] textArray = this.txtModeLeft;
        int n = this.txtModeLeft.length;
        int n2 = 0;
        while (n2 < n) {
            t = textArray[n2];
            t.setLayoutData((Object)gridData);
            t.setEnabled(false);
            ++n2;
        }
        textArray = this.txtModeRight;
        n = this.txtModeRight.length;
        n2 = 0;
        while (n2 < n) {
            t = textArray[n2];
            t.setLayoutData((Object)gridData);
            t.setEnabled(false);
            ++n2;
        }
    }

    private void createModeButtonCallbacks() {
        this.btnModeLeft[0].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.widget).getSelection()) {
                    DoubleEditor.this.enableLeftTextBox(0);
                    DoubleEditor.this.functionTypeL = NumberConfig.CONSTANT;
                    DoubleEditor.this.functionParameterL = Double.valueOf(DoubleEditor.this.txtModeLeft[0].getText());
                    DoubleEditor.this.function.setFunctionTypeL(DoubleEditor.this.functionTypeL);
                    DoubleEditor.this.function.setFunctionParameterL(DoubleEditor.this.functionParameterL);
                    DoubleEditor.this.redrawChart();
                }
            }
        });
        this.btnModeLeft[1].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.widget).getSelection()) {
                    DoubleEditor.this.enableLeftTextBox(1);
                    DoubleEditor.this.functionTypeL = NumberConfig.STEP_AT;
                    DoubleEditor.this.functionParameterL = Double.valueOf(DoubleEditor.this.txtModeLeft[1].getText());
                    DoubleEditor.this.function.setFunctionTypeL(DoubleEditor.this.functionTypeL);
                    DoubleEditor.this.function.setFunctionParameterL(DoubleEditor.this.functionParameterL);
                    DoubleEditor.this.redrawChart();
                }
            }
        });
        this.btnModeLeft[2].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.widget).getSelection()) {
                    DoubleEditor.this.enableLeftTextBox(2);
                    DoubleEditor.this.functionTypeL = NumberConfig.POLYNOMIAL_WITH;
                    DoubleEditor.this.functionParameterL = Double.valueOf(DoubleEditor.this.txtModeLeft[2].getText());
                    DoubleEditor.this.function.setFunctionTypeL(DoubleEditor.this.functionTypeL);
                    DoubleEditor.this.function.setFunctionParameterL(DoubleEditor.this.functionParameterL);
                    DoubleEditor.this.redrawChart();
                }
            }
        });
        this.btnModeLeft[3].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.widget).getSelection()) {
                    DoubleEditor.this.enableLeftTextBox(3);
                    DoubleEditor.this.functionTypeL = NumberConfig.SMOOTH_STEP_AT;
                    DoubleEditor.this.functionParameterL = Double.valueOf(DoubleEditor.this.txtModeLeft[3].getText());
                    DoubleEditor.this.function.setFunctionTypeL(DoubleEditor.this.functionTypeL);
                    DoubleEditor.this.function.setFunctionParameterL(DoubleEditor.this.functionParameterL);
                    DoubleEditor.this.redrawChart();
                }
            }
        });
        this.btnModeRight[0].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.widget).getSelection()) {
                    DoubleEditor.this.enableRightTextBox(0);
                    DoubleEditor.this.functionTypeR = NumberConfig.CONSTANT;
                    DoubleEditor.this.functionParameterR = Double.valueOf(DoubleEditor.this.txtModeRight[0].getText());
                    DoubleEditor.this.function.setFunctionTypeR(DoubleEditor.this.functionTypeR);
                    DoubleEditor.this.function.setFunctionParameterR(DoubleEditor.this.functionParameterR);
                    DoubleEditor.this.redrawChart();
                }
            }
        });
        this.btnModeRight[1].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.widget).getSelection()) {
                    DoubleEditor.this.enableRightTextBox(1);
                    DoubleEditor.this.functionTypeR = NumberConfig.STEP_AT;
                    DoubleEditor.this.functionParameterR = Double.valueOf(DoubleEditor.this.txtModeRight[1].getText());
                    DoubleEditor.this.function.setFunctionTypeR(DoubleEditor.this.functionTypeR);
                    DoubleEditor.this.function.setFunctionParameterR(DoubleEditor.this.functionParameterR);
                    DoubleEditor.this.redrawChart();
                }
            }
        });
        this.btnModeRight[2].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.widget).getSelection()) {
                    DoubleEditor.this.enableRightTextBox(2);
                    DoubleEditor.this.functionTypeR = NumberConfig.POLYNOMIAL_WITH;
                    DoubleEditor.this.functionParameterR = Double.valueOf(DoubleEditor.this.txtModeRight[2].getText());
                    DoubleEditor.this.function.setFunctionTypeR(DoubleEditor.this.functionTypeR);
                    DoubleEditor.this.function.setFunctionParameterR(DoubleEditor.this.functionParameterR);
                    DoubleEditor.this.redrawChart();
                }
            }
        });
        this.btnModeRight[3].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.widget).getSelection()) {
                    DoubleEditor.this.enableRightTextBox(3);
                    DoubleEditor.this.functionTypeR = NumberConfig.SMOOTH_STEP_AT;
                    DoubleEditor.this.functionParameterR = Double.valueOf(DoubleEditor.this.txtModeRight[3].getText());
                    DoubleEditor.this.function.setFunctionTypeR(DoubleEditor.this.functionTypeR);
                    DoubleEditor.this.function.setFunctionParameterR(DoubleEditor.this.functionParameterR);
                    DoubleEditor.this.redrawChart();
                }
            }
        });
        ModifyListener modifyListenerLeft = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DoubleEditor.this.functionParameterL = Double.valueOf(((Text)e.widget).getText());
                DoubleEditor.this.function.setFunctionParameterL(DoubleEditor.this.functionParameterL);
                DoubleEditor.this.redrawChart();
            }
        };
        Text[] textArray = this.txtModeLeft;
        int n = this.txtModeLeft.length;
        int n2 = 0;
        while (n2 < n) {
            Text t = textArray[n2];
            t.addModifyListener(modifyListenerLeft);
            ++n2;
        }
        ModifyListener modifyListenerRight = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DoubleEditor.this.functionParameterR = Double.valueOf(((Text)e.widget).getText());
                DoubleEditor.this.function.setFunctionParameterR(DoubleEditor.this.functionParameterR);
                DoubleEditor.this.redrawChart();
            }
        };
        Text[] textArray2 = this.txtModeRight;
        int n3 = this.txtModeRight.length;
        n = 0;
        while (n < n3) {
            Text t = textArray2[n];
            t.addModifyListener(modifyListenerRight);
            ++n;
        }
    }

    private void enableLeftTextBox(int i) {
        Text[] textArray = this.txtModeLeft;
        int n = this.txtModeLeft.length;
        int n2 = 0;
        while (n2 < n) {
            Text t = textArray[n2];
            t.setEnabled(false);
            ++n2;
        }
        this.txtModeLeft[i].setEnabled(true);
    }

    private void enableRightTextBox(int i) {
        Text[] textArray = this.txtModeRight;
        int n = this.txtModeRight.length;
        int n2 = 0;
        while (n2 < n) {
            Text t = textArray[n2];
            t.setEnabled(false);
            ++n2;
        }
        this.txtModeRight[i].setEnabled(true);
    }

    private void fillModel() {
        if (this.function.isSymmetric()) {
            this.btnSymmetry[0].setSelection(true);
            this.setSymmetric();
        } else {
            this.btnSymmetry[1].setSelection(true);
            this.setAsymmetric();
        }
        if (this.function.getDistanceFct() == DistanceConfig.DIFFERENCE) {
            this.btnDistanceFct[0].setSelection(true);
        } else {
            this.btnDistanceFct[1].setSelection(true);
        }
        this.fillTextWithSensibleDefaults();
        switch (this.functionTypeL) {
            case CONSTANT: {
                this.txtModeLeft[0].setEnabled(true);
                this.btnModeLeft[0].setSelection(true);
                this.txtModeLeft[0].setText(String.valueOf(this.function.getFunctionParameterL()));
                break;
            }
            case STEP_AT: {
                this.txtModeLeft[1].setEnabled(true);
                this.btnModeLeft[1].setSelection(true);
                this.txtModeLeft[1].setText(String.valueOf(this.function.getFunctionParameterL()));
                break;
            }
            case POLYNOMIAL_WITH: {
                this.txtModeLeft[2].setEnabled(true);
                this.btnModeLeft[2].setSelection(true);
                this.txtModeLeft[2].setText(String.valueOf(this.function.getFunctionParameterL()));
                break;
            }
            case SMOOTH_STEP_AT: {
                this.txtModeLeft[3].setEnabled(true);
                this.btnModeLeft[3].setSelection(true);
                this.txtModeLeft[3].setText(String.valueOf(this.function.getFunctionParameterL()));
            }
        }
        switch (this.functionTypeR) {
            case CONSTANT: {
                this.txtModeRight[0].setText(String.valueOf(this.function.getFunctionParameterR()));
                break;
            }
            case STEP_AT: {
                this.txtModeRight[1].setText(String.valueOf(this.function.getFunctionParameterR()));
                break;
            }
            case POLYNOMIAL_WITH: {
                this.txtModeRight[2].setText(String.valueOf(this.function.getFunctionParameterR()));
                break;
            }
            case SMOOTH_STEP_AT: {
                this.txtModeRight[3].setText(String.valueOf(this.function.getFunctionParameterR()));
            }
        }
    }

    private void fillTextWithSensibleDefaults() {
        Double halfDifference = this.function.getDiff() / 2.0;
        this.txtModeLeft[0].setText("0.5");
        this.txtModeRight[0].setText("0.5");
        this.txtModeLeft[1].setText(halfDifference.toString());
        this.txtModeRight[1].setText(halfDifference.toString());
        this.txtModeLeft[2].setText("1.0");
        this.txtModeRight[2].setText("1.0");
        this.txtModeLeft[3].setText(halfDifference.toString());
        this.txtModeRight[3].setText(halfDifference.toString());
    }

    private void setSymmetric() {
        this.function.setSymmetric(true);
        Button[] buttonArray = this.btnModeRight;
        int n = this.btnModeRight.length;
        int n2 = 0;
        while (n2 < n) {
            Button b = buttonArray[n2];
            b.setEnabled(false);
            ++n2;
        }
        buttonArray = this.txtModeRight;
        n = this.txtModeRight.length;
        n2 = 0;
        while (n2 < n) {
            Button t = buttonArray[n2];
            t.setEnabled(false);
            ++n2;
        }
    }

    private void setAsymmetric() {
        this.function.setSymmetric(false);
        switch (this.functionTypeR) {
            case CONSTANT: {
                this.txtModeRight[0].setEnabled(true);
                this.btnModeRight[0].setSelection(true);
                break;
            }
            case STEP_AT: {
                this.txtModeRight[1].setEnabled(true);
                this.btnModeRight[1].setSelection(true);
                break;
            }
            case POLYNOMIAL_WITH: {
                this.txtModeRight[2].setEnabled(true);
                this.btnModeRight[2].setSelection(true);
                break;
            }
            case SMOOTH_STEP_AT: {
                this.txtModeRight[3].setEnabled(true);
                this.btnModeRight[3].setSelection(true);
            }
        }
        Button[] buttonArray = this.btnModeRight;
        int n = this.btnModeRight.length;
        int n2 = 0;
        while (n2 < n) {
            Button b = buttonArray[n2];
            b.setEnabled(true);
            ++n2;
        }
    }

    private void redrawChart() {
        XYDataset dataset = this.function.getDistanceFct() == DistanceConfig.QUOTIENT ? DatasetUtilities.sampleFunction2D((Function2D)new DoubleFunction2D(this.function), (double)0.0, (double)(this.function.getMax() / this.function.getMin()), (int)100, (Comparable)((Object)"Function")) : DatasetUtilities.sampleFunction2D((Function2D)new DoubleFunction2D(this.function), (double)(-this.function.getDiff()), (double)this.function.getDiff(), (int)100, (Comparable)((Object)"Function"));
        JFreeChart chart = ChartFactory.createXYLineChart((String)"", (String)"", (String)"", (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        XYPlot plot = chart.getXYPlot();
        NumberAxis axis = (NumberAxis)plot.getRangeAxis();
        axis.setRange(-0.01, 1.0);
        plot.setOutlineVisible(false);
        ValueMarker yAxisMarker = this.function.getDistanceFct() == DistanceConfig.QUOTIENT ? new ValueMarker(1.0) : new ValueMarker(0.0);
        yAxisMarker.setPaint((Paint)Color.black);
        yAxisMarker.setStroke((Stroke)new BasicStroke(2.0f, 0, 2));
        chart.getXYPlot().addDomainMarker((Marker)yAxisMarker);
        this.cmpChart.setChart(chart);
        chart.fireChartChanged();
        try {
            if (!this.function.getProject().getName().endsWith("_UNSAFED")) {
                this.function.getProject().setName(String.valueOf(this.function.getProject().getName()) + "_UNSAFED");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void addDirtyOnChangeListeners() {
    }

    public void setFocus() {
    }
}

