/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.mycbr.gui.function.editor;

import de.dfki.mycbr.core.similarity.config.MultipleConfig;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class MultipleConfigPage
extends WizardPage {
    public static final String PAGE_NAME = "MultipleConfig";
    private MultipleConfig config;
    private Button[] btnNumberValues;
    private Button[] btnSingleType;
    private Button[] btnMultipleType;
    private Button[] btnReuse;
    private Button[] btnSim;
    private Composite cmpMultiple;
    private Composite cmpSingleType;

    public MultipleConfigPage(MultipleConfig config) {
        super(PAGE_NAME, "Configure set similarity", null);
        this.setDescription("Please provide settings for handling multiple attributes.");
        this.config = config;
    }

    public void createControl(Composite parent) {
        this.btnNumberValues = new Button[2];
        this.btnNumberValues[0] = new Button(parent, 16);
        this.btnNumberValues[0].setText("Calculate by multiple");
        this.btnNumberValues[1] = new Button(parent, 16);
        this.btnNumberValues[1].setText("Select one similarity");
        this.cmpMultiple = new Composite(parent, 0);
        this.cmpMultiple.setLayout((Layout)new RowLayout(512));
        Composite cmpMultipleType = new Composite(this.cmpMultiple, 0);
        cmpMultipleType.setLayout((Layout)new RowLayout(512));
        this.btnMultipleType = new Button[3];
        this.btnMultipleType[0] = new Button(cmpMultipleType, 16);
        this.btnMultipleType[0].setText("Find best partners for all query items");
        this.btnMultipleType[1] = new Button(cmpMultipleType, 16);
        this.btnMultipleType[1].setText("Find best partners for all case items");
        this.btnMultipleType[2] = new Button(cmpMultipleType, 16);
        this.btnMultipleType[2].setText("Do both");
        Composite cmpReuse = new Composite(this.cmpMultiple, 0);
        cmpReuse.setLayout((Layout)new RowLayout(512));
        this.btnReuse = new Button[3];
        this.btnReuse[0] = new Button(cmpReuse, 16);
        this.btnReuse[0].setText("Reuse items");
        this.btnReuse[1] = new Button(cmpReuse, 16);
        this.btnReuse[1].setText("Set similarity to zero");
        this.btnReuse[2] = new Button(cmpReuse, 16);
        this.btnReuse[2].setText("Ignore");
        Composite cmpSim = new Composite(this.cmpMultiple, 0);
        cmpSim.setLayout((Layout)new RowLayout(512));
        this.btnSim = new Button[3];
        this.btnSim[0] = new Button(cmpSim, 16);
        this.btnSim[0].setText("Average");
        this.btnSim[1] = new Button(cmpSim, 16);
        this.btnSim[1].setText("Maximum");
        this.btnSim[2] = new Button(cmpSim, 16);
        this.btnSim[2].setText("Minimum");
        this.cmpSingleType = new Composite(parent, 0);
        this.cmpSingleType.setLayout((Layout)new RowLayout(512));
        this.btnSingleType = new Button[2];
        this.btnSingleType[0] = new Button(this.cmpSingleType, 16);
        this.btnSingleType[0].setText("Find best match");
        this.btnSingleType[1] = new Button(this.cmpSingleType, 16);
        this.btnSingleType[1].setText("Find worst match");
        GridLayoutFactory.fillDefaults().margins(5, 5).spacing(5, 3).numColumns(2).applyTo(parent);
        GridDataFactory.fillDefaults().applyTo((Control)this.cmpMultiple);
        GridDataFactory.fillDefaults().applyTo((Control)this.cmpSingleType);
        this.addButtonListeners();
        this.fillModel();
        this.setControl((Control)parent);
    }

    private void addButtonListeners() {
        this.btnNumberValues[0].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MultipleConfigPage.this.clearSingle();
                MultipleConfigPage.this.config.setMainType(MultipleConfig.MainType.PARTNER_QUERY);
                MultipleConfigPage.this.fillModel();
            }
        });
        this.btnNumberValues[1].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MultipleConfigPage.this.clearMultiple();
                MultipleConfigPage.this.config.setMainType(MultipleConfig.MainType.BEST_MATCH);
                MultipleConfigPage.this.fillModel();
            }
        });
        this.btnSingleType[0].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MultipleConfigPage.this.config.setMainType(MultipleConfig.MainType.BEST_MATCH);
            }
        });
        this.btnSingleType[1].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MultipleConfigPage.this.config.setMainType(MultipleConfig.MainType.WORST_MATCH);
            }
        });
        this.btnMultipleType[0].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MultipleConfigPage.this.config.setMainType(MultipleConfig.MainType.PARTNER_QUERY);
            }
        });
        this.btnMultipleType[1].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MultipleConfigPage.this.config.setMainType(MultipleConfig.MainType.PARTNER_CASE);
            }
        });
        this.btnMultipleType[2].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MultipleConfigPage.this.config.setMainType(MultipleConfig.MainType.PARTNER_MAX);
            }
        });
        this.btnReuse[0].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MultipleConfigPage.this.config.setReuse(MultipleConfig.Reuse.REUSE);
            }
        });
        this.btnReuse[1].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MultipleConfigPage.this.config.setReuse(MultipleConfig.Reuse.ZERO_SIM);
            }
        });
        this.btnReuse[2].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MultipleConfigPage.this.config.setReuse(MultipleConfig.Reuse.IGNORE);
            }
        });
        this.btnSim[0].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MultipleConfigPage.this.config.setType(MultipleConfig.Type.AVG);
            }
        });
        this.btnSim[1].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MultipleConfigPage.this.config.setType(MultipleConfig.Type.MAX);
            }
        });
        this.btnSim[2].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MultipleConfigPage.this.config.setType(MultipleConfig.Type.MIN);
            }
        });
    }

    private void fillModel() {
        if (this.config.getMainType() == MultipleConfig.MainType.BEST_MATCH || this.config.getMainType() == MultipleConfig.MainType.WORST_MATCH) {
            this.enableSingle();
            this.disableMultiple();
            this.btnNumberValues[0].setSelection(false);
            this.btnNumberValues[1].setSelection(true);
            if (this.config.getMainType() == MultipleConfig.MainType.BEST_MATCH) {
                this.btnSingleType[0].setSelection(true);
            } else {
                this.btnSingleType[1].setSelection(true);
            }
        } else {
            this.enableMultiple();
            this.disableSingle();
            this.btnNumberValues[0].setSelection(true);
            this.btnNumberValues[1].setSelection(false);
            if (this.config.getMainType() == MultipleConfig.MainType.PARTNER_QUERY) {
                this.btnMultipleType[0].setSelection(true);
            } else if (this.config.getMainType() == MultipleConfig.MainType.PARTNER_CASE) {
                this.btnMultipleType[1].setSelection(true);
            } else {
                this.btnMultipleType[2].setSelection(true);
            }
            if (this.config.getReuse() == MultipleConfig.Reuse.REUSE) {
                this.btnReuse[0].setSelection(true);
            } else if (this.config.getReuse() == MultipleConfig.Reuse.ZERO_SIM) {
                this.btnReuse[1].setSelection(true);
            } else {
                this.btnReuse[2].setSelection(true);
            }
            if (this.config.getType() == MultipleConfig.Type.AVG) {
                this.btnSim[0].setSelection(true);
            } else if (this.config.getType() == MultipleConfig.Type.MAX) {
                this.btnSim[1].setSelection(true);
            } else {
                this.btnSim[2].setSelection(true);
            }
        }
    }

    private void enableSingle() {
        this.btnSingleType[0].setEnabled(true);
        this.btnSingleType[1].setEnabled(true);
    }

    private void disableSingle() {
        this.btnSingleType[0].setEnabled(false);
        this.btnSingleType[1].setEnabled(false);
    }

    private void clearSingle() {
        this.btnSingleType[0].setSelection(false);
        this.btnSingleType[1].setSelection(false);
    }

    private void enableMultiple() {
        this.btnMultipleType[0].setEnabled(true);
        this.btnMultipleType[1].setEnabled(true);
        this.btnMultipleType[2].setEnabled(true);
        this.btnReuse[0].setEnabled(true);
        this.btnReuse[1].setEnabled(true);
        this.btnReuse[2].setEnabled(true);
        this.btnSim[0].setEnabled(true);
        this.btnSim[1].setEnabled(true);
        this.btnSim[2].setEnabled(true);
    }

    private void disableMultiple() {
        this.btnMultipleType[0].setEnabled(false);
        this.btnMultipleType[1].setEnabled(false);
        this.btnMultipleType[2].setEnabled(false);
        this.btnReuse[0].setEnabled(false);
        this.btnReuse[1].setEnabled(false);
        this.btnReuse[2].setEnabled(false);
        this.btnSim[0].setEnabled(false);
        this.btnSim[1].setEnabled(false);
        this.btnSim[2].setEnabled(false);
    }

    private void clearMultiple() {
        this.btnMultipleType[0].setSelection(false);
        this.btnMultipleType[1].setSelection(false);
        this.btnMultipleType[2].setSelection(false);
        this.btnReuse[0].setSelection(false);
        this.btnReuse[1].setSelection(false);
        this.btnReuse[2].setSelection(false);
        this.btnSim[0].setSelection(false);
        this.btnSim[1].setSelection(false);
        this.btnSim[2].setSelection(false);
    }
}

